/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.examples.ml;

import org.apache.spark.ml.regression.GeneralizedLinearRegression;
import org.apache.spark.ml.regression.GeneralizedLinearRegressionModel;
import org.apache.spark.ml.regression.GeneralizedLinearRegressionTrainingSummary;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import scala.Predef$;

public final class GeneralizedLinearRegressionExample$ {
    public static final GeneralizedLinearRegressionExample$ MODULE$ = new GeneralizedLinearRegressionExample$();

    public void main(String[] args) {
        SparkSession spark = SparkSession$.MODULE$.builder().appName("GeneralizedLinearRegressionExample").getOrCreate();
        Dataset dataset = spark.read().format("libsvm").load("data/mllib/sample_linear_regression_data.txt");
        GeneralizedLinearRegression glr = new GeneralizedLinearRegression().setFamily("gaussian").setLink("identity").setMaxIter(10).setRegParam(0.3);
        GeneralizedLinearRegressionModel model = (GeneralizedLinearRegressionModel)glr.fit(dataset);
        Predef$.MODULE$.println((Object)new StringBuilder(14).append("Coefficients: ").append(model.coefficients()).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(11).append("Intercept: ").append(model.intercept()).toString());
        GeneralizedLinearRegressionTrainingSummary summary = model.summary();
        Predef$.MODULE$.println((Object)new StringBuilder(29).append("Coefficient Standard Errors: ").append(Predef$.MODULE$.wrapDoubleArray(summary.coefficientStandardErrors()).mkString(",")).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(10).append("T Values: ").append(Predef$.MODULE$.wrapDoubleArray(summary.tValues()).mkString(",")).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(10).append("P Values: ").append(Predef$.MODULE$.wrapDoubleArray(summary.pValues()).mkString(",")).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(12).append("Dispersion: ").append(summary.dispersion()).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(15).append("Null Deviance: ").append(summary.nullDeviance()).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(33).append("Residual Degree Of Freedom Null: ").append(summary.residualDegreeOfFreedomNull()).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(10).append("Deviance: ").append(summary.deviance()).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(28).append("Residual Degree Of Freedom: ").append(summary.residualDegreeOfFreedom()).toString());
        Predef$.MODULE$.println((Object)new StringBuilder(5).append("AIC: ").append(summary.aic()).toString());
        Predef$.MODULE$.println((Object)"Deviance Residuals: ");
        summary.residuals().show();
        spark.stop();
    }

    private GeneralizedLinearRegressionExample$() {
    }
}

