/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.impl.utils;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolverFactory;
import org.apache.sling.api.resource.observation.ExternalResourceChangeListener;
import org.apache.sling.api.resource.observation.ResourceChange;
import org.apache.sling.api.resource.observation.ResourceChangeListener;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.apache.sling.scripting.api.resource.ScriptingResourceResolverProvider;
import org.apache.sling.scripting.sightly.engine.ResourceResolution;
import org.apache.sling.scripting.sightly.impl.engine.SightlyEngineConfiguration;
import org.apache.sling.scripting.sightly.impl.utils.BindingsUtils;
import org.apache.sling.scripting.sightly.render.RenderContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={ScriptDependencyResolver.class}, property={"resource.paths=.", "resource.change.types=ADDED", "resource.change.types=CHANGED", "resource.change.types=REMOVED"})
public class ScriptDependencyResolver
implements ResourceChangeListener,
ExternalResourceChangeListener,
BundleListener {
    public static final String BUNDLED_SCRIPTS_REQUIREMENT = "osgi.extender;filter:=\"(&(osgi.extender=sling.scripting)(version>=1.0.0)(!(version>=2.0.0)))\"";
    @Reference
    private SightlyEngineConfiguration sightlyEngineConfiguration;
    @Reference
    private ScriptingResourceResolverProvider scriptingResourceResolverProvider;
    @Reference
    private ResourceResolverFactory resourceResolverFactory;
    private Map<String, String> resolutionCache = new ConcurrentHashMap<String, String>();
    private ServiceRegistration<ResourceChangeListener> resourceChangeListenerServiceRegistration;
    private boolean cacheEnabled = false;
    private static final String NOT_FOUND_MARKER = "#NOT_FOUND#";

    @Activate
    private void activate(ComponentContext componentContext) {
        int cacheSize = this.sightlyEngineConfiguration.getScriptResolutionCacheSize();
        boolean bl = this.cacheEnabled = cacheSize >= 1024;
        if (this.cacheEnabled) {
            componentContext.getBundleContext().addBundleListener((BundleListener)this);
            Hashtable<String, Object> resourceChangeListenerProperties = new Hashtable<String, Object>();
            ((Dictionary)resourceChangeListenerProperties).put("resource.paths", ".");
            ((Dictionary)resourceChangeListenerProperties).put("resource.change.types", new String[]{"ADDED", "CHANGED", "REMOVED"});
            this.resourceChangeListenerServiceRegistration = componentContext.getBundleContext().registerService(ResourceChangeListener.class, (Object)this, resourceChangeListenerProperties);
        }
    }

    @Deactivate
    private void deactivate(ComponentContext componentContext) {
        if (this.resourceChangeListenerServiceRegistration != null) {
            this.resourceChangeListenerServiceRegistration.unregister();
        }
        componentContext.getBundleContext().removeBundleListener((BundleListener)this);
    }

    public Resource resolveScript(RenderContext renderContext, String scriptIdentifier) {
        SlingJakartaHttpServletRequest jakartaRequest = BindingsUtils.getJakartaRequest(renderContext.getBindings());
        if (!this.cacheEnabled) {
            return this.internalResolveScript(jakartaRequest, renderContext, scriptIdentifier);
        }
        String cacheKey = jakartaRequest.getResource().getResourceType() + ":" + scriptIdentifier;
        String scriptPath = this.resolutionCache.computeIfAbsent(cacheKey, t -> {
            Resource r = this.internalResolveScript(jakartaRequest, renderContext, scriptIdentifier);
            if (r == null) {
                return NOT_FOUND_MARKER;
            }
            return r.getPath();
        });
        if (scriptPath.equals(NOT_FOUND_MARKER)) {
            return null;
        }
        return this.scriptingResourceResolverProvider.getRequestScopedResourceResolver().getResource(scriptPath);
    }

    @Nullable
    private Resource internalResolveScript(SlingJakartaHttpServletRequest request, RenderContext renderContext, String scriptIdentifier) {
        SlingScriptHelper sling;
        Resource caller = ResourceResolution.getResourceForJakartaRequest(this.scriptingResourceResolverProvider.getRequestScopedResourceResolver(), request);
        Resource result = ResourceResolution.getResourceFromSearchPath(caller, scriptIdentifier);
        if (result == null && (sling = BindingsUtils.getHelper(renderContext.getBindings())) != null) {
            caller = this.scriptingResourceResolverProvider.getRequestScopedResourceResolver().getResource(sling.getScript().getScriptResource().getPath());
            result = ResourceResolution.getResourceFromSearchPath(caller, scriptIdentifier);
        }
        return result;
    }

    public void onChange(@NotNull List<ResourceChange> changes) {
        this.resolutionCache.clear();
    }

    public void bundleChanged(BundleEvent event) {
        Dictionary bundleHeaders = event.getBundle().getHeaders();
        String requireCapabilityHeader = (String)bundleHeaders.get("Require-Capability");
        if (StringUtils.isNotEmpty((CharSequence)requireCapabilityHeader) && requireCapabilityHeader.contains(BUNDLED_SCRIPTS_REQUIREMENT)) {
            this.resolutionCache.clear();
        }
    }
}

