/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.feature.cpconverter.handlers;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.Map;
import java.util.jar.JarFile;
import org.apache.jackrabbit.vault.packaging.PackageType;
import org.apache.sling.feature.Artifact;
import org.apache.sling.feature.ArtifactId;
import org.apache.sling.feature.cpconverter.ContentPackage2FeatureModelConverter;
import org.apache.sling.feature.cpconverter.ConverterException;
import org.apache.sling.feature.cpconverter.handlers.AbstractContentPackageHandler;
import org.apache.sling.feature.cpconverter.handlers.BundleEntryHandler;
import org.apache.sling.feature.cpconverter.handlers.slinginitialcontent.BundleSlingInitialContentExtractContext;
import org.apache.sling.feature.cpconverter.handlers.slinginitialcontent.BundleSlingInitialContentExtractor;
import org.apache.sling.feature.cpconverter.vltpkg.VaultPackageAssembler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SlingInitialContentBundleHandler
extends BundleEntryHandler {
    @NotNull
    private final AbstractContentPackageHandler handler;

    public SlingInitialContentBundleHandler(@NotNull AbstractContentPackageHandler handler, @NotNull ContentPackage2FeatureModelConverter.SlingInitialContentPolicy slingInitialContentPolicy) {
        this.handler = handler;
        this.setSlingInitialContentPolicy(slingInitialContentPolicy);
    }

    @Override
    void processBundleInputStream(@NotNull String path, @NotNull Path originalBundleFile, @NotNull String bundleName, @Nullable String runMode, @Nullable Integer startLevel, @NotNull ContentPackage2FeatureModelConverter converter) throws IOException, ConverterException {
        try (JarFile jarFile = new JarFile(originalBundleFile.toFile());){
            Artifact artifact = this.extractFeatureArtifact(bundleName, jarFile);
            ArtifactId id = artifact.getId();
            BundleSlingInitialContentExtractContext context = new BundleSlingInitialContentExtractContext(this.slingInitialContentPolicy, path, id, jarFile, converter, runMode);
            try (InputStream ignored = new BundleSlingInitialContentExtractorOverride().extract(context);){
                this.logger.info("Ignoring inputstream {} with id {}", (Object)path, (Object)id);
            }
        }
    }

    class BundleSlingInitialContentExtractorOverride
    extends BundleSlingInitialContentExtractor {
        BundleSlingInitialContentExtractorOverride() {
        }

        @Override
        protected void finalizePackageAssembly(@NotNull BundleSlingInitialContentExtractContext context) throws IOException, ConverterException {
            for (Map.Entry<PackageType, VaultPackageAssembler> entry : this.assemblerProvider.getPackageAssemblerEntrySet()) {
                File packageFile = entry.getValue().createPackage();
                ContentPackage2FeatureModelConverter converter = context.getConverter();
                SlingInitialContentBundleHandler.this.handler.processSubPackage(context.getPath() + "-" + entry.getKey(), context.getRunMode(), converter.open(packageFile), converter, true);
            }
        }
    }
}

