/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.event.impl.jobs.tasks;

import java.util.Calendar;
import java.util.Iterator;
import org.apache.sling.api.resource.ModifiableValueMap;
import org.apache.sling.api.resource.PersistenceException;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.event.impl.jobs.JobImpl;
import org.apache.sling.event.impl.jobs.JobTopicTraverser;
import org.apache.sling.event.impl.jobs.config.JobManagerConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FindUnfinishedJobsTask {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final JobManagerConfiguration configuration;

    public FindUnfinishedJobsTask(JobManagerConfiguration config) {
        this.configuration = config;
    }

    public void run() {
        this.initialScan();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialScan() {
        this.logger.debug("Scanning repository for unfinished jobs...");
        ResourceResolver resolver = this.configuration.createResourceResolver();
        if (resolver == null) {
            return;
        }
        try {
            Resource baseResource = resolver.getResource(this.configuration.getLocalJobsPath());
            if (baseResource != null) {
                Iterator topicIter = baseResource.listChildren();
                while (topicIter.hasNext()) {
                    Resource topicResource = (Resource)topicIter.next();
                    this.logger.debug("Found topic {}", (Object)topicResource.getName());
                    this.initTopic(topicResource);
                }
            }
        }
        finally {
            resolver.close();
        }
    }

    private void initTopic(final Resource topicResource) {
        this.logger.debug("Initializing topic {}...", (Object)topicResource.getName());
        JobTopicTraverser.traverse(this.logger, topicResource, new JobTopicTraverser.JobCallback(){

            @Override
            public boolean handle(JobImpl job) {
                if (job.getProcessingStarted() != null) {
                    FindUnfinishedJobsTask.this.logger.debug("Found unfinished job {}", (Object)job.getId());
                    job.retry();
                    try {
                        Resource jobResource = topicResource.getResourceResolver().getResource(job.getResourcePath());
                        if (jobResource != null) {
                            ModifiableValueMap mvm = (ModifiableValueMap)jobResource.adaptTo(ModifiableValueMap.class);
                            mvm.remove((Object)"event.job.started.time");
                            mvm.put((Object)"event.job.retrycount", (Object)job.getRetryCount());
                            if (job.getProperty("event.job.queued.time", Calendar.class) == null) {
                                mvm.put((Object)"event.job.queued.time", (Object)Calendar.getInstance());
                            }
                            jobResource.getResourceResolver().commit();
                        }
                    }
                    catch (PersistenceException ignore) {
                        FindUnfinishedJobsTask.this.logger.error("Unable to update unfinished job " + job, (Throwable)ignore);
                    }
                } else if (job.getProperty("event.job.queued.time", Calendar.class) == null) {
                    FindUnfinishedJobsTask.this.logger.debug("Found job without queued date {}", (Object)job.getId());
                    try {
                        Resource jobResource = topicResource.getResourceResolver().getResource(job.getResourcePath());
                        if (jobResource != null) {
                            ModifiableValueMap mvm = (ModifiableValueMap)jobResource.adaptTo(ModifiableValueMap.class);
                            mvm.put((Object)"event.job.queued.time", (Object)Calendar.getInstance());
                            jobResource.getResourceResolver().commit();
                        }
                    }
                    catch (PersistenceException ignore) {
                        FindUnfinishedJobsTask.this.logger.error("Unable to update queued date for job " + job.getId(), (Throwable)ignore);
                    }
                }
                return true;
            }
        });
        this.logger.debug("Topic {} initialized", (Object)topicResource.getName());
    }
}

