/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.trace.provider.handler.v8.grpc;

import io.grpc.Status;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.skywalking.apm.network.common.v3.Commands;
import org.apache.skywalking.apm.network.language.agent.v3.SpanAttachedEvent;
import org.apache.skywalking.apm.network.language.agent.v3.SpanAttachedEventReportServiceGrpc;
import org.apache.skywalking.oap.server.core.analysis.TimeBucket;
import org.apache.skywalking.oap.server.core.analysis.manual.spanattach.SWSpanAttachedEventRecord;
import org.apache.skywalking.oap.server.core.analysis.manual.spanattach.SpanAttachedEventRecord;
import org.apache.skywalking.oap.server.core.analysis.record.Record;
import org.apache.skywalking.oap.server.core.analysis.worker.RecordStreamProcessor;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.server.grpc.GRPCHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpanAttachedEventReportServiceHandler
extends SpanAttachedEventReportServiceGrpc.SpanAttachedEventReportServiceImplBase
implements GRPCHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SpanAttachedEventReportServiceHandler.class);

    public SpanAttachedEventReportServiceHandler(ModuleManager moduleManager) {
    }

    public StreamObserver<SpanAttachedEvent> collect(final StreamObserver<Commands> responseObserver) {
        return new StreamObserver<SpanAttachedEvent>(){

            public void onNext(SpanAttachedEvent event) {
                if (log.isDebugEnabled()) {
                    log.debug("receive span attached event is streaming");
                }
                switch (event.getTraceContext().getType()) {
                    case SKYWALKING: {
                        SWSpanAttachedEventRecord swRecord = new SWSpanAttachedEventRecord();
                        swRecord.setStartTimeSecond(event.getStartTime().getSeconds());
                        swRecord.setStartTimeNanos(event.getStartTime().getNanos());
                        swRecord.setEvent(event.getEvent());
                        swRecord.setEndTimeSecond(event.getEndTime().getSeconds());
                        swRecord.setEndTimeNanos(event.getEndTime().getNanos());
                        swRecord.setTraceRefType(event.getTraceContext().getTypeValue());
                        swRecord.setRelatedTraceId(event.getTraceContext().getTraceId());
                        swRecord.setTraceSegmentId(event.getTraceContext().getTraceSegmentId());
                        swRecord.setTraceSpanId(event.getTraceContext().getSpanId());
                        swRecord.setDataBinary(event.toByteArray());
                        long timestamp = TimeUnit.SECONDS.toMillis(swRecord.getStartTimeSecond()) + TimeUnit.NANOSECONDS.toMillis(swRecord.getStartTimeNanos());
                        swRecord.setTimeBucket(TimeBucket.getRecordTimeBucket((long)timestamp));
                        swRecord.setTimestamp(timestamp);
                        RecordStreamProcessor.getInstance().in((Record)swRecord);
                        break;
                    }
                    case ZIPKIN: {
                        SpanAttachedEventRecord record = new SpanAttachedEventRecord();
                        record.setStartTimeSecond(event.getStartTime().getSeconds());
                        record.setStartTimeNanos(event.getStartTime().getNanos());
                        record.setEvent(event.getEvent());
                        record.setEndTimeSecond(event.getEndTime().getSeconds());
                        record.setEndTimeNanos(event.getEndTime().getNanos());
                        record.setTraceRefType(event.getTraceContext().getTypeValue());
                        record.setRelatedTraceId(event.getTraceContext().getTraceId());
                        record.setTraceSegmentId(event.getTraceContext().getTraceSegmentId());
                        record.setTraceSpanId(event.getTraceContext().getSpanId());
                        record.setDataBinary(event.toByteArray());
                        long ts = TimeUnit.SECONDS.toMillis(record.getStartTimeSecond()) + TimeUnit.NANOSECONDS.toMillis(record.getStartTimeNanos());
                        record.setTimeBucket(TimeBucket.getRecordTimeBucket((long)ts));
                        record.setTimestamp(ts);
                        RecordStreamProcessor.getInstance().in((Record)record);
                    }
                }
            }

            public void onError(Throwable throwable) {
                Status status = Status.fromThrowable((Throwable)throwable);
                if (Status.CANCELLED.getCode() == status.getCode()) {
                    if (log.isDebugEnabled()) {
                        log.debug(throwable.getMessage(), throwable);
                    }
                    return;
                }
                log.error(throwable.getMessage(), throwable);
            }

            public void onCompleted() {
                responseObserver.onNext((Object)Commands.newBuilder().build());
                responseObserver.onCompleted();
            }
        };
    }
}

