/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.geotiff;

import java.awt.image.BandedSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.SampleModel;
import java.util.Optional;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.math.Vector;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreContentException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.base.StoreResource;
import org.apache.sis.storage.base.TiledGridResource;
import org.apache.sis.storage.event.StoreListeners;
import org.apache.sis.storage.geotiff.CompressedSubset;
import org.apache.sis.storage.geotiff.DataSubset;
import org.apache.sis.storage.geotiff.Reader;
import org.apache.sis.storage.geotiff.base.Compression;
import org.apache.sis.storage.geotiff.base.Predictor;
import org.apache.sis.storage.geotiff.base.Tags;
import org.opengis.util.GenericName;

abstract class DataCube
extends TiledGridResource
implements StoreResource {
    final Reader reader;

    DataCube(Reader reader) {
        super((Resource)reader.store);
        this.reader = reader;
    }

    public final DataStore getOriginator() {
        return this.reader.store;
    }

    protected final Object getSynchronizationLock() {
        return this.reader.store;
    }

    final StoreListeners listeners() {
        return this.listeners;
    }

    final String filename() {
        return this.reader.input.filename;
    }

    public abstract Optional<GenericName> getIdentifier() throws DataStoreException;

    public final Optional<Resource.FileSet> getFileSet() throws DataStoreException {
        return this.reader.store.getFileSet();
    }

    abstract int getNumBands();

    abstract long getNumTiles();

    abstract Vector getTileArrayInfo(boolean var1);

    abstract long getScanlineStride(int var1);

    abstract boolean isBitOrderReversed();

    abstract Compression getCompression();

    abstract Predictor getPredictor();

    abstract Number getReplaceableFillValue();

    protected final boolean canReadTruncatedTiles(int dim, boolean suggested) {
        return suggested | dim >= 1;
    }

    private boolean canReadDirect(TiledGridResource.Subset subset) throws DataStoreException {
        SampleModel model = this.getSampleModel(null);
        int b = model.getNumBands();
        if (b != 1 && !(model instanceof BandedSampleModel) && !subset.isXContiguous()) {
            return false;
        }
        int dataSize = DataBuffer.getDataTypeSize(model.getDataType());
        do {
            if (model.getSampleSize(--b) == dataSize) continue;
            return false;
        } while (b != 0);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final GridCoverage read(GridGeometry domain, int ... ranges) throws DataStoreException {
        DataSubset coverage;
        long startTime = System.nanoTime();
        try {
            Object object = this.getSynchronizationLock();
            synchronized (object) {
                TiledGridResource.Subset subset = new TiledGridResource.Subset((TiledGridResource)this, domain, ranges);
                Compression compression = this.getCompression();
                if (compression == null) {
                    throw new DataStoreContentException(this.reader.resources().getString((short)13, Tags.name((short)259)));
                }
                coverage = compression == Compression.NONE && this.getPredictor() == Predictor.NONE && this.canReadDirect(subset) ? new DataSubset(this, subset) : new CompressedSubset(this, subset);
                coverage = this.preload((GridCoverage)coverage);
            }
        }
        catch (RuntimeException e) {
            throw this.canNotRead(this.filename(), domain, e);
        }
        this.logReadOperation(this.reader.store.path, coverage.getGridGeometry(), startTime);
        return coverage;
    }
}

