/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.otlp.metrics;

import java.io.IOException;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.Marshaler;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.MarshalerUtil;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.MarshalerWithSize;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.ProtoEnumInfo;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.ProtoFieldInfo;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.marshal.Serializer;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.otlp.metrics.HistogramDataPointMarshaler;
import org.apache.shardingsphere.shade.io.opentelemetry.exporter.internal.otlp.metrics.MetricsMarshalerUtil;
import org.apache.shardingsphere.shade.io.opentelemetry.proto.metrics.v1.internal.Histogram;
import org.apache.shardingsphere.shade.io.opentelemetry.sdk.metrics.data.HistogramData;

final class HistogramMarshaler
extends MarshalerWithSize {
    private final HistogramDataPointMarshaler[] dataPoints;
    private final ProtoEnumInfo aggregationTemporality;

    static HistogramMarshaler create(HistogramData histogram) {
        HistogramDataPointMarshaler[] dataPointMarshalers = HistogramDataPointMarshaler.createRepeated(histogram.getPoints());
        return new HistogramMarshaler(dataPointMarshalers, MetricsMarshalerUtil.mapToTemporality(histogram.getAggregationTemporality()));
    }

    private HistogramMarshaler(HistogramDataPointMarshaler[] dataPoints, ProtoEnumInfo aggregationTemporality) {
        super(HistogramMarshaler.calculateSize(dataPoints, aggregationTemporality));
        this.dataPoints = dataPoints;
        this.aggregationTemporality = aggregationTemporality;
    }

    @Override
    public void writeTo(Serializer output) throws IOException {
        output.serializeRepeatedMessage(Histogram.DATA_POINTS, this.dataPoints);
        output.serializeEnum(Histogram.AGGREGATION_TEMPORALITY, this.aggregationTemporality);
    }

    private static int calculateSize(HistogramDataPointMarshaler[] dataPoints, ProtoEnumInfo aggregationTemporality) {
        int size = 0;
        size += MarshalerUtil.sizeRepeatedMessage((ProtoFieldInfo)Histogram.DATA_POINTS, (Marshaler[])dataPoints);
        return size += MarshalerUtil.sizeEnum(Histogram.AGGREGATION_TEMPORALITY, aggregationTemporality);
    }
}

