/*
 * Decompiled with CFR 0.152.
 */
package com.cedarsoftware.util;

import java.math.BigDecimal;
import java.math.BigInteger;

public final class MathUtilities {
    private MathUtilities() {
    }

    public static long minimum(long ... values2) {
        int len = values2.length;
        long current = values2[0];
        for (int i = 1; i < len; ++i) {
            current = Math.min(values2[i], current);
        }
        return current;
    }

    public static long maximum(long ... values2) {
        int len = values2.length;
        long current = values2[0];
        for (int i = 1; i < len; ++i) {
            current = Math.max(values2[i], current);
        }
        return current;
    }

    public static double minimum(double ... values2) {
        int len = values2.length;
        double current = values2[0];
        for (int i = 1; i < len; ++i) {
            current = Math.min(values2[i], current);
        }
        return current;
    }

    public static double maximum(double ... values2) {
        int len = values2.length;
        double current = values2[0];
        for (int i = 1; i < len; ++i) {
            current = Math.max(values2[i], current);
        }
        return current;
    }

    public static BigInteger minimum(BigInteger ... values2) {
        int len = values2.length;
        if (len == 1) {
            if (values2[0] == null) {
                throw new IllegalArgumentException("Cannot passed null BigInteger entry to minimum()");
            }
            return values2[0];
        }
        BigInteger current = values2[0];
        for (int i = 1; i < len; ++i) {
            if (values2[i] == null) {
                throw new IllegalArgumentException("Cannot passed null BigInteger entry to minimum()");
            }
            current = values2[i].min(current);
        }
        return current;
    }

    public static BigInteger maximum(BigInteger ... values2) {
        int len = values2.length;
        if (len == 1) {
            if (values2[0] == null) {
                throw new IllegalArgumentException("Cannot passed null BigInteger entry to maximum()");
            }
            return values2[0];
        }
        BigInteger current = values2[0];
        for (int i = 1; i < len; ++i) {
            if (values2[i] == null) {
                throw new IllegalArgumentException("Cannot passed null BigInteger entry to maximum()");
            }
            current = values2[i].max(current);
        }
        return current;
    }

    public static BigDecimal minimum(BigDecimal ... values2) {
        int len = values2.length;
        if (len == 1) {
            if (values2[0] == null) {
                throw new IllegalArgumentException("Cannot passed null BigDecimal entry to minimum()");
            }
            return values2[0];
        }
        BigDecimal current = values2[0];
        for (int i = 1; i < len; ++i) {
            if (values2[i] == null) {
                throw new IllegalArgumentException("Cannot passed null BigDecimal entry to minimum()");
            }
            current = values2[i].min(current);
        }
        return current;
    }

    public static BigDecimal maximum(BigDecimal ... values2) {
        int len = values2.length;
        if (len == 1) {
            if (values2[0] == null) {
                throw new IllegalArgumentException("Cannot pass null BigDecimal entry to maximum()");
            }
            return values2[0];
        }
        BigDecimal current = values2[0];
        for (int i = 1; i < len; ++i) {
            if (values2[i] == null) {
                throw new IllegalArgumentException("Cannot pass null BigDecimal entry to maximum()");
            }
            current = values2[i].max(current);
        }
        return current;
    }
}

