/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.shaded.s2.primitives;

public final class Sorter {
    private Sorter() {
    }

    public static void sort(SortableCollection data) {
        Sorter.sort(data, 0, data.size() - 1);
    }

    public static void sort(SortableCollection data, int left, int right) {
        while (right - left >= 8) {
            int pivot = Sorter.pickPivot(data, left, right);
            int pa = left;
            int pb = left;
            int pc = right;
            int pd = right;
            while (true) {
                if (pb <= pc && !data.less(pivot, pb)) {
                    if (!data.less(pb, pivot)) {
                        data.swap(pa, pb);
                        pivot = pa++;
                    }
                    ++pb;
                    continue;
                }
                while (pb <= pc && !data.less(pc, pivot)) {
                    if (!data.less(pivot, pc)) {
                        data.swap(pc, pd);
                        pivot = pd--;
                    }
                    --pc;
                }
                if (pb > pc) break;
                if (pb == pivot) {
                    pivot = pc;
                } else if (pc == pivot) {
                    pivot = pb;
                }
                data.swap(pb, pc);
                ++pb;
                --pc;
            }
            int s2 = Math.min(pa - left, pb - pa);
            Sorter.swapRange(data, left, pb - s2, s2);
            s2 = Math.min(pd - pc, right - pd);
            Sorter.swapRange(data, pb, right + 1 - s2, s2);
            int l1 = left;
            int r1 = left + (pb - pa) - 1;
            int l2 = right + 1 - (pd - pc);
            int r2 = right;
            if (r1 - l1 < r2 - l2) {
                left = l2;
                right = r2;
            } else {
                left = l1;
                right = r1;
                l1 = l2;
                r1 = r2;
            }
            if (l1 >= r1) continue;
            Sorter.sort(data, l1, r1);
        }
        Sorter.insertionSort(data, left, right);
    }

    private static void insertionSort(SortableCollection data, int left, int right) {
        for (int i = left; i <= right; ++i) {
            for (int j = i; j > left && data.less(j, j - 1); --j) {
                data.swap(j, j - 1);
            }
        }
    }

    private static int pickPivot(SortableCollection data, int left, int right) {
        if (right - left + 1 > 100) {
            int d = (right - left) / 8;
            int a = Sorter.median(data, left + 0 * d, left + 1 * d, left + 2 * d);
            int b = Sorter.median(data, left + 3 * d, left + 4 * d, left + 5 * d);
            int c = Sorter.median(data, left + 6 * d, left + 7 * d, left + 8 * d);
            return Sorter.median(data, a, b, c);
        }
        return Sorter.median(data, left, (left + right) / 2, right);
    }

    private static int median(SortableCollection data, int a, int b, int c) {
        return data.less(a, b) ? (data.less(b, c) ? b : (data.less(a, c) ? c : a)) : (data.less(c, b) ? b : (data.less(c, a) ? c : a));
    }

    private static void swapRange(SortableCollection data, int p1, int p2, int n) {
        for (int i = 0; i < n; ++i) {
            data.swap(p1 + i, p2 + i);
        }
    }

    public static interface SortableCollection {
        public boolean less(int var1, int var2);

        public void swap(int var1, int var2);

        public int size();

        default public void sort() {
            if (this.size() > 1) {
                Sorter.sort(this, 0, this.size() - 1);
            }
        }

        public void truncate(int var1);

        default public void unique() {
            int size = this.size();
            if (size <= 1) {
                return;
            }
            int dst = 0;
            for (int i = 1; i < size; ++i) {
                if (!this.less(dst, i)) continue;
                this.swap(++dst, i);
            }
            this.truncate(dst + 1);
        }
    }
}

