/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.shaded.s2;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.AbstractList;
import java.util.List;
import org.apache.sedona.shaded.guava.base.Supplier;
import org.apache.sedona.shaded.guava.primitives.ImmutableLongArray;
import org.apache.sedona.shaded.guava.primitives.Ints;
import org.apache.sedona.shaded.s2.InMemoryOutputStream;
import org.apache.sedona.shaded.s2.PrimitiveArrays;
import org.apache.sedona.shaded.s2.S2Coder;
import org.apache.sedona.shaded.s2.S2Shape;
import org.apache.sedona.shaded.s2.S2TaggedShapeCoder;
import org.apache.sedona.shaded.s2.UintVectorCoder;

public class VectorCoder<T>
implements S2Coder<List<T>> {
    static final VectorCoder<byte[]> BYTE_ARRAY = new VectorCoder<byte[]>(new S2Coder<byte[]>(){

        @Override
        public void encode(byte[] value, OutputStream output) throws IOException {
            output.write(value);
        }

        @Override
        public byte[] decode(PrimitiveArrays.Bytes data, PrimitiveArrays.Cursor cursor) throws IOException {
            byte[] b = new byte[Ints.checkedCast(cursor.remaining())];
            try {
                for (int i = 0; i < b.length; ++i) {
                    b[i] = data.get(cursor.position++);
                }
            }
            catch (IndexOutOfBoundsException e) {
                throw new IOException("'data' and 'cursor' are out of sync. Expected to read " + b.length + " bytes.", e);
            }
            return b;
        }

        @Override
        public boolean isLazy() {
            return false;
        }
    });
    public static final VectorCoder<String> STRING = new VectorCoder<String>(new S2Coder<String>(){

        @Override
        public void encode(String value, OutputStream output) throws IOException {
            output.write(value.getBytes(StandardCharsets.UTF_8));
        }

        @Override
        public String decode(PrimitiveArrays.Bytes data, PrimitiveArrays.Cursor cursor) {
            byte[] b = new byte[Ints.checkedCast(cursor.remaining())];
            for (int i = 0; i < b.length; ++i) {
                b[i] = data.get(cursor.position++);
            }
            return new String(b, StandardCharsets.UTF_8);
        }

        @Override
        public boolean isLazy() {
            return false;
        }
    });
    public static final VectorCoder<S2Shape> FAST_SHAPE = new VectorCoder<S2Shape>(S2TaggedShapeCoder.FAST);
    public static final VectorCoder<S2Shape> COMPACT_SHAPE = new VectorCoder<S2Shape>(S2TaggedShapeCoder.COMPACT);
    private final S2Coder<T> coder;
    private final SerializableSupplier inMemoryOutputStreamSupplier;

    private static final InMemoryOutputStream defaultInMemoryOutputStreamSupplier() {
        return new InMemoryOutputStream.ByteArrayInMemoryOutputStream();
    }

    public VectorCoder(S2Coder<T> coder) {
        this.coder = coder;
        this.inMemoryOutputStreamSupplier = VectorCoder::defaultInMemoryOutputStreamSupplier;
    }

    public VectorCoder(S2Coder<T> coder, SerializableSupplier inMemoryOutputStreamSupplier) {
        this.coder = coder;
        this.inMemoryOutputStreamSupplier = inMemoryOutputStreamSupplier;
    }

    @Override
    public void encode(List<T> values, OutputStream output) throws IOException {
        InMemoryOutputStream bos = (InMemoryOutputStream)this.inMemoryOutputStreamSupplier.get();
        ImmutableLongArray.Builder offsetsBuilder = ImmutableLongArray.builder(values.size());
        for (T value : values) {
            this.coder.encode(value, bos);
            offsetsBuilder.add(bos.size());
        }
        UintVectorCoder.UINT64.encode(PrimitiveArrays.Longs.fromImmutableLongArray(offsetsBuilder.build()), output);
        bos.writeTo(output);
    }

    @Override
    public EncodedList<T> decode(final PrimitiveArrays.Bytes data, PrimitiveArrays.Cursor cursor) {
        PrimitiveArrays.Longs offsets;
        try {
            offsets = UintVectorCoder.UINT64.decode(data, cursor);
        }
        catch (IOException e) {
            throw new IllegalStateException("Underlying IO error", e);
        }
        final long offset = cursor.position;
        cursor.position = cursor.position + (offsets.length() > 0 ? offsets.get(offsets.length() - 1) : 0L);
        return new EncodedList<T>(){

            @Override
            public T get(int position) {
                long start = position == 0 ? 0L : offsets.get(position - 1);
                long end = offsets.get(position);
                try {
                    return VectorCoder.this.coder.decode(data, data.cursor(offset + start, offset + end));
                }
                catch (IOException e) {
                    throw new IllegalStateException("Underlying IO error", e);
                }
            }

            @Override
            public int size() {
                return offsets.length();
            }

            @Override
            public long encodedSize(int index) {
                long start = index == 0 ? 0L : offsets.get(index - 1);
                long end = offsets.get(index);
                return end - start;
            }
        };
    }

    @Override
    public boolean isLazy() {
        return true;
    }

    public static abstract class EncodedList<T>
    extends AbstractList<T> {
        public abstract long encodedSize(int var1);
    }

    public static interface SerializableSupplier
    extends Supplier<InMemoryOutputStream>,
    Serializable {
    }
}

