/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.shaded.s2;

import java.util.List;
import java.util.function.BiFunction;
import org.apache.sedona.shaded.fastutil.longs.Long2IntMap;
import org.apache.sedona.shaded.fastutil.longs.Long2IntOpenHashMap;
import org.apache.sedona.shaded.guava.annotations.VisibleForTesting;
import org.apache.sedona.shaded.guava.base.Preconditions;
import org.apache.sedona.shaded.s2.S2Cell;
import org.apache.sedona.shaded.s2.S2Projections;
import org.apache.sedona.shaded.s2.S2RobustCellClipper;
import org.apache.sedona.shaded.s2.S2Shape;
import org.apache.sedona.shaded.s2.primitives.CountingBitset;
import org.jspecify.annotations.Nullable;

public class S2ShapeTracker {
    private int dimension = -1;
    private final CountingBitset chainsSeen = new CountingBitset();
    private final Long2IntMap points0 = new Long2IntOpenHashMap();
    private final Long2IntMap points1 = new Long2IntOpenHashMap();
    private static final BiFunction<Long, Integer, Integer> incrementFn = (key, value) -> {
        if (value == null) {
            return 1;
        }
        if (value == -1) {
            return null;
        }
        return value + 1;
    };
    private static final BiFunction<Long, Integer, Integer> decrementFn = new BiFunction<Long, Integer, Integer>(){

        @Override
        public @Nullable Integer apply(Long key, Integer value) {
            if (value == null) {
                return -1;
            }
            if (value == 1) {
                return null;
            }
            return value - 1;
        }
    };

    public S2ShapeTracker() {
        this.points0.defaultReturnValue(0);
        this.points1.defaultReturnValue(0);
    }

    public S2ShapeTracker(int dimension, int numChains) {
        this.points0.defaultReturnValue(0);
        this.points1.defaultReturnValue(0);
        this.init(dimension, numChains);
    }

    public S2ShapeTracker(S2Shape shape) {
        this.points0.defaultReturnValue(0);
        this.points1.defaultReturnValue(0);
        this.init(shape);
    }

    private Long2IntMap points(int axis) {
        return axis == 0 ? this.points0 : this.points1;
    }

    public void init(int dimension, int numChains) {
        this.dimension = dimension;
        this.chainsSeen.reset(numChains);
        this.points0.clear();
        this.points1.clear();
    }

    public void init(S2Shape shape) {
        int numChains = shape.numChains();
        if (shape.isEmpty() || shape.isFull()) {
            assert (numChains == 1);
            numChains = 0;
        }
        this.init(shape.dimension(), numChains);
    }

    public void markChain(int chain) {
        this.chainsSeen.set(chain);
    }

    public void processCrossings(S2Cell cell, List<S2RobustCellClipper.Crossing> crossings) {
        int ncrossing = crossings.size();
        if (ncrossing == 0 || this.dimension == 0) {
            return;
        }
        double[] cellUvCoords = new double[4];
        int[] cellIjCoords = new int[4];
        for (int k = 0; k < 4; ++k) {
            S2Cell.Boundary b = S2Cell.Boundary.fromValue(k);
            cellUvCoords[k] = cell.getUVCoordOfBoundary(b);
            cellIjCoords[k] = cell.getIJCoordOfBoundary(b);
        }
        if (this.dimension == 1) {
            for (S2RobustCellClipper.Crossing crossing : crossings) {
                int ij = S2ShapeTracker.uvToIjRound(crossing.intercept);
                int face = cell.face();
                int axis = S2ShapeTracker.constantBoundaryAxis(cell.face(), crossing.boundary);
                int coord = cellIjCoords[crossing.boundary.value];
                if (crossing.boundary.value < 2) {
                    this.addPoint(face, axis, coord, ij);
                    continue;
                }
                this.delPoint(face, axis, coord, ij);
            }
            return;
        }
        boolean interior = crossings.get((int)0).crossingType == S2RobustCellClipper.CrossingType.INCOMING;
        int i = 0;
        int[] bs = new int[]{0};
        for (int b = 0; b < 4; ++b) {
            int ij1;
            int ij0;
            double uvprev;
            S2RobustCellClipper.Crossing crossing;
            bs[0] = b;
            S2Cell.Boundary boundary = S2Cell.Boundary.fromValue(b);
            int axis = S2ShapeTracker.constantBoundaryAxis(cell.face(), boundary);
            int coord = cellIjCoords[b];
            int bnext = (b + 1) % 4;
            int bprev = (b + 3) % 4;
            double uvbeg = cellUvCoords[bprev];
            double uvend = cellUvCoords[bnext];
            int ijbeg = cellIjCoords[bprev];
            int ijend = cellIjCoords[bnext];
            XYPredicate ordered = (x, y) -> bs[0] < 2 ? x < y : x > y;
            if (i < ncrossing && crossings.get((int)i).boundary == boundary) {
                crossing = crossings.get(i);
                uvprev = crossing.intercept;
                ++i;
                if (interior && ordered.test(uvbeg, crossing.intercept)) {
                    int ij12;
                    double uv = crossing.intercept;
                    int ij02 = ijbeg;
                    int n = ij12 = b < 2 ? S2ShapeTracker.uvToIjCeil(uv) : S2ShapeTracker.uvToIjFloor(uv);
                    if (ij02 != ij12) {
                        this.addInterval(cell.face(), axis, coord, ij02, ij12);
                    }
                }
                interior = crossing.crossingType == S2RobustCellClipper.CrossingType.OUTGOING;
            } else {
                if (!interior) continue;
                this.addInterval(cell.face(), axis, coord, ijbeg, ijend);
                continue;
            }
            while (i < ncrossing && crossings.get((int)i).boundary == boundary) {
                crossing = crossings.get(i);
                if (interior) {
                    double uv0 = Math.min(uvprev, crossing.intercept);
                    double uv1 = Math.max(uvprev, crossing.intercept);
                    int ij03 = S2ShapeTracker.uvToIjFloor(uv0);
                    int ij13 = S2ShapeTracker.uvToIjCeil(uv1);
                    if (b >= 2) {
                        int tmp = ij03;
                        ij03 = ij13;
                        ij13 = tmp;
                    }
                    if (ij03 != ij13) {
                        this.addInterval(cell.face(), axis, coord, ij03, ij13);
                    }
                }
                interior = crossing.crossingType == S2RobustCellClipper.CrossingType.OUTGOING;
                uvprev = crossing.intercept;
                ++i;
            }
            if (!interior || !ordered.test(uvprev, uvend) || (ij0 = b < 2 ? S2ShapeTracker.uvToIjFloor(uvprev) : S2ShapeTracker.uvToIjCeil(uvprev)) == (ij1 = ijend)) continue;
            this.addInterval(cell.face(), axis, coord, ij0, ij1);
        }
        Preconditions.checkState(i == ncrossing);
    }

    public void addCellBoundary(S2Cell cell) {
        int face = cell.face();
        int bottomAxis = S2ShapeTracker.constantBoundaryAxis(face, S2Cell.Boundary.BOTTOM_EDGE);
        int rightAxis = S2ShapeTracker.constantBoundaryAxis(face, S2Cell.Boundary.RIGHT_EDGE);
        int topAxis = S2ShapeTracker.constantBoundaryAxis(face, S2Cell.Boundary.TOP_EDGE);
        int leftAxis = S2ShapeTracker.constantBoundaryAxis(face, S2Cell.Boundary.LEFT_EDGE);
        int bottomEdgeIJ = cell.getIJCoordOfBoundary(S2Cell.Boundary.BOTTOM_EDGE);
        int rightEdgeIJ = cell.getIJCoordOfBoundary(S2Cell.Boundary.RIGHT_EDGE);
        int topEdgeIJ = cell.getIJCoordOfBoundary(S2Cell.Boundary.TOP_EDGE);
        int leftEdgeIJ = cell.getIJCoordOfBoundary(S2Cell.Boundary.LEFT_EDGE);
        this.addInterval(face, bottomAxis, bottomEdgeIJ, leftEdgeIJ, rightEdgeIJ);
        this.addInterval(face, rightAxis, rightEdgeIJ, bottomEdgeIJ, topEdgeIJ);
        this.addInterval(face, topAxis, topEdgeIJ, rightEdgeIJ, leftEdgeIJ);
        this.addInterval(face, leftAxis, leftEdgeIJ, topEdgeIJ, bottomEdgeIJ);
    }

    public boolean finished() {
        return this.chainsSeen.full() && this.points0.isEmpty() && this.points1.isEmpty();
    }

    private long ijKey(int face, int i, int j) {
        assert (face < 6);
        assert (i <= 0x40000000);
        assert (j <= 0x40000000);
        long ans = 0L;
        ans |= (long)face << 60;
        ans |= (long)i << 30;
        return ans |= (long)j;
    }

    @VisibleForTesting
    void addInterval(int face, int axis, int ijcoord, int ij0, int ij1) {
        assert (ij0 != ij1);
        assert (this.dimension == 2);
        if (ijcoord == 0x40000000) {
            ijcoord = 0;
            face = S2ShapeTracker.adjacentFace(face, axis);
            if (axis == 1) {
                ij0 = 0x40000000 - ij0;
                ij1 = 0x40000000 - ij1;
            }
            axis = 1 - axis;
        }
        this.points(axis).compute(this.ijKey(face, ijcoord, ij0), (BiFunction<? super Long, ? super Integer, ? extends Integer>)incrementFn);
        this.points(axis).compute(this.ijKey(face, ijcoord, ij1), (BiFunction<? super Long, ? super Integer, ? extends Integer>)decrementFn);
    }

    @VisibleForTesting
    void addPoint(int face, int axis, int ijcoord, int ij) {
        boolean flip = false;
        if (ijcoord == 0x40000000) {
            ijcoord = 0;
            face = S2ShapeTracker.adjacentFace(face, axis);
            if (axis == 1) {
                flip = true;
                ij = 0x40000000 - ij;
            }
            axis = 1 - axis;
        }
        if (flip) {
            this.delPoint(face, axis, ijcoord, ij);
            return;
        }
        this.points(axis).compute(this.ijKey(face, ijcoord, ij), (BiFunction<? super Long, ? super Integer, ? extends Integer>)incrementFn);
    }

    @VisibleForTesting
    void delPoint(int face, int axis, int ijcoord, int ij) {
        boolean flip = false;
        if (ijcoord == 0x40000000) {
            ijcoord = 0;
            face = S2ShapeTracker.adjacentFace(face, axis);
            if (axis == 1) {
                flip = true;
                ij = 0x40000000 - ij;
            }
            axis = 1 - axis;
        }
        if (flip) {
            this.addPoint(face, axis, ijcoord, ij);
            return;
        }
        this.points(axis).compute(this.ijKey(face, ijcoord, ij), (BiFunction<? super Long, ? super Integer, ? extends Integer>)decrementFn);
    }

    private static int uvToIjFloor(double uv) {
        return (int)Math.floor(1.073741824E9 * S2Projections.uvToST(uv));
    }

    private static int uvToIjCeil(double uv) {
        return (int)Math.ceil(1.073741824E9 * S2Projections.uvToST(uv));
    }

    private static int uvToIjRound(double uv) {
        return (int)Math.round(1.073741824E9 * S2Projections.uvToST(uv));
    }

    private static int constantBoundaryAxis(int face, S2Cell.Boundary boundary) {
        int axis = 0;
        if (boundary == S2Cell.Boundary.BOTTOM_EDGE || boundary == S2Cell.Boundary.TOP_EDGE) {
            axis = 1;
        }
        return face % 2 == 0 ? axis : 1 - axis;
    }

    private static int adjacentFace(int face, int axis) {
        return (face + (axis == 1 ? 2 : 1)) % 6;
    }

    private static interface XYPredicate {
        public boolean test(double var1, double var3);
    }
}

