/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.shaded.s2;

import org.apache.sedona.shaded.s2.R1Interval;
import org.apache.sedona.shaded.s2.R2Edge;
import org.apache.sedona.shaded.s2.R2Rect;
import org.apache.sedona.shaded.s2.R2Vector;
import org.apache.sedona.shaded.s2.S2EdgeUtil;

public class R2EdgeClipper {
    public static final double MAX_UNIT_CLIP_ERROR = 9.992007221626409E-16;
    public static final byte INSIDE = 0;
    public static final byte BOTTOM = 1;
    public static final byte RIGHT = 2;
    public static final byte TOP = 4;
    public static final byte LEFT = 8;
    public static final byte OUTSIDE = -1;
    private double xMin;
    private double xMax;
    private double yMin;
    private double yMax;
    private R2Edge edge;
    private byte lastOutcode;
    public final R2Edge clippedEdge = new R2Edge();
    public byte outcode0;
    public byte outcode1;

    public R2EdgeClipper() {
    }

    public R2EdgeClipper(R2Rect rectangle) {
        this.init(rectangle);
    }

    public void init(R2Rect rectangle) {
        this.xMin = rectangle.x().lo();
        this.xMax = rectangle.x().hi();
        this.yMin = rectangle.y().lo();
        this.yMax = rectangle.y().hi();
    }

    public R2Rect clipRect() {
        return new R2Rect(new R1Interval(this.xMin, this.xMax), new R1Interval(this.yMin, this.yMax));
    }

    public boolean clipEdge(R2Edge edge, boolean connected) {
        byte code1;
        this.outcode0 = (byte)-1;
        this.outcode1 = (byte)-1;
        byte code0 = connected ? this.lastOutcode : this.outcode(edge.v0);
        this.lastOutcode = code1 = this.outcode(edge.v1);
        if ((code0 & code1) != 0) {
            return false;
        }
        this.clippedEdge.init(edge);
        if (code0 != 0) {
            code0 = this.clipVertex(this.clippedEdge.v0, edge, code0);
        }
        if (code1 != 0) {
            code1 = this.clipVertex(this.clippedEdge.v1, edge, code1);
        }
        this.outcode0 = code0;
        this.outcode1 = code1;
        return code0 != -1 && code1 != -1;
    }

    public void clip(R2Edge edge, byte outcode, R2Vector result) {
        this.edge = edge;
        assert (outcode > 0);
        assert ((outcode & outcode - 1) == 0);
        switch (outcode) {
            case 1: {
                this.clipBottom(result);
                break;
            }
            case 2: {
                this.clipRight(result);
                break;
            }
            case 4: {
                this.clipTop(result);
                break;
            }
            case 8: {
                this.clipLeft(result);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid outcode: " + outcode);
            }
        }
    }

    private byte outcode(R2Vector uv) {
        byte code = 0;
        if (uv.x() < this.xMin) {
            code = (byte)(code | 8);
        } else if (uv.x() > this.xMax) {
            code = (byte)(code | 2);
        }
        if (uv.y() < this.yMin) {
            code = (byte)(code | 1);
        } else if (uv.y() > this.yMax) {
            code = (byte)(code | 4);
        }
        return code;
    }

    private void clipBottom(R2Vector intersection) {
        intersection.set(this.interpolateX(this.yMin), this.yMin);
    }

    private void clipRight(R2Vector intersection) {
        intersection.set(this.xMax, this.interpolateY(this.xMax));
    }

    private void clipTop(R2Vector intersection) {
        intersection.set(this.interpolateX(this.yMax), this.yMax);
    }

    private void clipLeft(R2Vector intersection) {
        intersection.set(this.xMin, this.interpolateY(this.xMin));
    }

    private double interpolateY(double x) {
        R2Vector v0 = this.edge.v0;
        R2Vector v1 = this.edge.v1;
        return S2EdgeUtil.interpolateDouble(x, v0.x(), v1.x(), v0.y(), v1.y());
    }

    private double interpolateX(double y) {
        R2Vector v0 = this.edge.v0;
        R2Vector v1 = this.edge.v1;
        return S2EdgeUtil.interpolateDouble(y, v0.y(), v1.y(), v0.x(), v1.x());
    }

    private byte clipVertex(R2Vector v0, R2Edge edge, byte code) {
        byte outb;
        byte outa;
        this.edge = edge;
        assert (code != 0);
        assert (code != -1);
        if ((code & code - 1) == 0) {
            this.clip(edge, code, v0);
            if (this.outcode(v0) != 0) {
                return -1;
            }
            return code;
        }
        R2Vector va = new R2Vector();
        R2Vector vb = new R2Vector();
        switch (code) {
            case 12: {
                outa = 4;
                outb = 8;
                this.clipTop(va);
                this.clipLeft(vb);
                break;
            }
            case 6: {
                outa = 4;
                outb = 2;
                this.clipTop(va);
                this.clipRight(vb);
                break;
            }
            case 9: {
                outa = 1;
                outb = 8;
                this.clipBottom(va);
                this.clipLeft(vb);
                break;
            }
            case 3: {
                outa = 1;
                outb = 2;
                this.clipBottom(va);
                this.clipRight(vb);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid outcode: " + code);
            }
        }
        if (this.outcode(va) == 0) {
            v0.set(va);
            return outa;
        }
        if (this.outcode(vb) == 0) {
            v0.set(vb);
            return outb;
        }
        return -1;
    }
}

