/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.shaded.s2;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Collection;
import org.apache.sedona.shaded.guava.base.Preconditions;
import org.apache.sedona.shaded.s2.R2Rect;
import org.apache.sedona.shaded.s2.R2Vector;
import org.apache.sedona.shaded.s2.S2Cap;
import org.apache.sedona.shaded.s2.S2Cell;
import org.apache.sedona.shaded.s2.S2CellId;
import org.apache.sedona.shaded.s2.S2CellUnion;
import org.apache.sedona.shaded.s2.S2ContainsPointQuery;
import org.apache.sedona.shaded.s2.S2EdgeUtil;
import org.apache.sedona.shaded.s2.S2Iterator;
import org.apache.sedona.shaded.s2.S2LatLngRect;
import org.apache.sedona.shaded.s2.S2Point;
import org.apache.sedona.shaded.s2.S2Region;
import org.apache.sedona.shaded.s2.S2Shape;
import org.apache.sedona.shaded.s2.S2ShapeIndex;
import org.apache.sedona.shaded.s2.primitives.IntVector;

public class S2ShapeIndexRegion
implements S2Region {
    private final S2ContainsPointQuery containsQuery;
    private final S2ShapeIndex index;
    private final S2Iterator<S2ShapeIndex.Cell> it;
    private final S2CellUnion union = new S2CellUnion();
    private final S2Shape.MutableEdge edge = new S2Shape.MutableEdge();
    private final R2Rect bound = new R2Rect();
    private final R2Vector p0 = new R2Vector();
    private final R2Vector p1 = new R2Vector();
    private final IntVector ids = new IntVector();

    public S2ShapeIndexRegion(S2ShapeIndex index) {
        this(index, S2ContainsPointQuery.S2VertexModel.SEMI_OPEN);
    }

    public S2ShapeIndexRegion(S2ShapeIndex index, S2ContainsPointQuery.S2VertexModel model) {
        this.index = index;
        this.it = index.iterator();
        this.containsQuery = new S2ContainsPointQuery(index, new S2ContainsPointQuery.Options(model));
    }

    @Override
    public S2Cap getCapBound() {
        this.getCellUnionBound(this.union.cellIds());
        return this.union.getCapBound();
    }

    @Override
    public S2LatLngRect getRectBound() {
        this.getCellUnionBound(this.union.cellIds());
        return this.union.getRectBound();
    }

    @Override
    public void getCellUnionBound(Collection<S2CellId> cellIds) {
        cellIds.clear();
        this.it.finish();
        if (!this.it.prev()) {
            return;
        }
        S2CellId lastIndexId = this.it.id();
        this.it.restart();
        S2CellId currentIndexId = this.it.id();
        if (!currentIndexId.equals(lastIndexId)) {
            int level = currentIndexId.getCommonAncestorLevel(lastIndexId) + 1;
            S2CellId lastId = lastIndexId.parent(level);
            S2CellId id = currentIndexId.parent(level);
            while (!id.equals(lastId)) {
                S2CellId max = id.rangeMax();
                if (!max.lessThan(currentIndexId)) {
                    this.it.seek(max.next());
                    this.it.prev();
                    S2ShapeIndexRegion.coverRange(currentIndexId, this.it.id(), cellIds);
                    this.it.next();
                    currentIndexId = this.it.id();
                }
                id = id.next();
            }
        }
        S2ShapeIndexRegion.coverRange(currentIndexId, lastIndexId, cellIds);
    }

    private static void coverRange(S2CellId first, S2CellId last, Collection<S2CellId> cellIds) {
        if (first.equals(last)) {
            cellIds.add(first);
        } else {
            int level = first.getCommonAncestorLevel(last);
            Preconditions.checkArgument(level >= 0, "First and last must have a common ancestor.");
            cellIds.add(first.parent(level));
        }
    }

    @Override
    public boolean contains(S2Point p) {
        if (this.it.locate(p)) {
            S2Point center = this.it.center();
            S2ShapeIndex.Cell cell = this.it.entry();
            for (int s2 = 0; s2 < cell.numShapes(); ++s2) {
                if (!this.containsQuery.shapeContains(center, cell.clipped(s2), p)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean contains(S2Cell target) {
        S2ShapeIndex.CellRelation relation = this.it.locate(target.id());
        if (relation != S2ShapeIndex.CellRelation.INDEXED) {
            return false;
        }
        S2ShapeIndex.Cell cell = this.it.entry();
        S2Point center = this.it.center();
        for (int s2 = 0; s2 < cell.numShapes(); ++s2) {
            S2Shape shape;
            S2ShapeIndex.S2ClippedShape clipped = cell.clipped(s2);
            if (!(this.it.id().equals(target.id()) ? clipped.numEdges() == 0 && clipped.containsCenter() : (shape = this.index.getShapes().get(clipped.shapeId())).hasInterior() && !this.anyEdgeIntersects(clipped, target) && this.containsQuery.shapeContains(center, clipped, target.getCenter()))) continue;
            return true;
        }
        return false;
    }

    @CanIgnoreReturnValue
    public boolean visitIntersectingShapes(S2Cell target, ShapeVisitor visitor) {
        S2ShapeIndex.CellRelation relation = this.it.locate(target.id());
        switch (relation) {
            case DISJOINT: {
                return true;
            }
            case SUBDIVIDED: {
                this.ids.clear();
                S2CellId max = target.id().rangeMax();
                while (!this.it.done() && this.it.id().lessOrEquals(max)) {
                    S2ShapeIndex.Cell cell = this.it.entry();
                    for (int s2 = 0; s2 < cell.numShapes(); ++s2) {
                        S2ShapeIndex.S2ClippedShape clipped = cell.clipped(s2);
                        boolean containsTarget = clipped.numEdges() == 0 && clipped.containsCenter();
                        this.ids.add(clipped.shapeId() << 1 | (containsTarget ? 1 : 0));
                    }
                    this.it.next();
                }
                this.ids.sort();
                this.ids.unique();
                int last = -1;
                for (int i = 0; i < this.ids.size(); ++i) {
                    int id = this.ids.get(i);
                    boolean contains = (id & 1) != 0;
                    int shapeId = id >>> 1;
                    if (last != shapeId && !visitor.test(shapeId, contains)) {
                        return false;
                    }
                    last = shapeId;
                }
                return true;
            }
            case INDEXED: {
                S2ShapeIndex.Cell cell = this.it.entry();
                for (int s3 = 0; s3 < cell.numShapes(); ++s3) {
                    S2ShapeIndex.S2ClippedShape clipped = cell.clipped(s3);
                    boolean contains = false;
                    if (cell.id() == target.id().id()) {
                        contains = clipped.numEdges() == 0 && clipped.containsCenter();
                    } else if (!this.anyEdgeIntersects(clipped, target)) {
                        if (!this.containsQuery.shapeContains(this.it.center(), clipped, target.getCenter())) continue;
                        contains = true;
                    }
                    if (visitor.test(clipped.shapeId(), contains)) continue;
                    return false;
                }
                return true;
            }
        }
        throw new IllegalStateException("Unknown S2ShapeIndex.CellRelation " + relation);
    }

    @Override
    public boolean mayIntersect(S2Cell target) {
        S2ShapeIndex.CellRelation relation = this.it.locate(target.id());
        if (relation == S2ShapeIndex.CellRelation.DISJOINT) {
            return false;
        }
        if (relation == S2ShapeIndex.CellRelation.SUBDIVIDED) {
            return true;
        }
        if (this.it.compareTo(target.id()) == 0) {
            return true;
        }
        S2ShapeIndex.Cell cell = this.it.entry();
        S2Point center = this.it.center();
        for (int s2 = 0; s2 < cell.numShapes(); ++s2) {
            S2ShapeIndex.S2ClippedShape clipped = cell.clipped(s2);
            if (!this.anyEdgeIntersects(clipped, target) && !this.containsQuery.shapeContains(center, clipped, target.getCenter())) continue;
            return true;
        }
        return false;
    }

    private boolean anyEdgeIntersects(S2ShapeIndex.S2ClippedShape clipped, S2Cell target) {
        target.setBoundUV(this.bound);
        this.bound.expand(S2EdgeUtil.MAX_CELL_EDGE_ERROR);
        int face = target.face();
        S2Shape shape = this.index.getShapes().get(clipped.shapeId());
        int numEdges = clipped.numEdges();
        for (int i = 0; i < numEdges; ++i) {
            shape.getEdge(clipped.edge(i), this.edge);
            if (!S2EdgeUtil.clipToPaddedFace(this.edge.a, this.edge.b, face, S2EdgeUtil.MAX_CELL_EDGE_ERROR, this.p0, this.p1) || !S2EdgeUtil.intersectsRect(this.p0, this.p1, this.bound)) continue;
            return true;
        }
        return false;
    }

    public static interface ShapeVisitor {
        public boolean test(int var1, boolean var2);
    }
}

