/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.S2Geography;

import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.UnsafeInput;
import com.esotericsoftware.kryo.io.UnsafeOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.sedona.common.S2Geography.EncodeOptions;
import org.apache.sedona.common.S2Geography.EncodeTag;
import org.apache.sedona.common.S2Geography.Geography;
import org.apache.sedona.common.S2Geography.PolygonGeography;
import org.apache.sedona.shaded.guava.collect.ImmutableList;
import org.apache.sedona.shaded.s2.S2Polygon;
import org.apache.sedona.shaded.s2.S2Region;
import org.apache.sedona.shaded.s2.S2RegionUnion;
import org.apache.sedona.shaded.s2.S2Shape;

public class GeographyCollection
extends Geography {
    private static final Logger logger = Logger.getLogger(GeographyCollection.class.getName());
    public final List<Geography> features;
    public final List<Integer> numShapesList;
    public int totalShapes;

    public GeographyCollection() {
        super(Geography.GeographyKind.GEOGRAPHY_COLLECTION);
        this.features = new ArrayList<Geography>();
        this.numShapesList = new ArrayList<Integer>();
        this.totalShapes = 0;
    }

    public GeographyCollection(Geography.GeographyKind kind, List<S2Polygon> polygons) {
        super(kind);
        if (kind != Geography.GeographyKind.MULTIPOLYGON) {
            throw new IllegalArgumentException("Invalid GeographyKind, only allow Multipolygon as in geographyCollection: " + String.valueOf((Object)kind));
        }
        List<Object> inputPolygons = polygons == null ? Collections.emptyList() : polygons;
        this.features = inputPolygons.stream().map(PolygonGeography::new).collect(Collectors.toUnmodifiableList());
        this.numShapesList = new ArrayList<Integer>();
        this.totalShapes = 0;
        this.countShapes();
    }

    public GeographyCollection(List<Geography> features) {
        super(Geography.GeographyKind.GEOGRAPHY_COLLECTION);
        this.features = new ArrayList<Geography>(features);
        this.numShapesList = new ArrayList<Integer>();
        this.totalShapes = 0;
        this.countShapes();
    }

    @Override
    public int dimension() {
        return this.computeDimensionFromShapes();
    }

    @Override
    public int numShapes() {
        return this.totalShapes;
    }

    @Override
    public S2Shape shape(int id) {
        int sum = 0;
        for (int i = 0; i < this.features.size(); ++i) {
            int n = this.numShapesList.get(i);
            if (id >= (sum += n)) continue;
            return this.features.get(i).shape(id - (sum - n));
        }
        throw new IllegalArgumentException("Shape id out of bounds: " + id);
    }

    @Override
    public S2Region region() {
        ArrayList<S2Region> regs = new ArrayList<S2Region>();
        for (Geography geo : this.features) {
            regs.add(geo.region());
        }
        return new S2RegionUnion(regs);
    }

    public List<Geography> getFeatures() {
        return ImmutableList.copyOf(this.features);
    }

    @Override
    public void encode(UnsafeOutput out, EncodeOptions opts) throws IOException {
        EncodeOptions childOptions = new EncodeOptions(opts);
        childOptions.setIncludeCovering(false);
        out.writeInt(this.features.size());
        for (Geography feature : this.features) {
            feature.encodeTagged((OutputStream)out, opts);
        }
        out.flush();
    }

    public static GeographyCollection decode(UnsafeInput in, EncodeTag tag) throws IOException {
        GeographyCollection geo = new GeographyCollection();
        if ((tag.getFlags() & 1) != 0) {
            logger.fine("Decoded empty GeographyCollection.");
            return geo;
        }
        tag.skipCovering(in);
        try {
            int count = in.readInt();
            if (count < 0) {
                throw new IOException("GeographyCollection.decodeTagged error: negative count: " + count);
            }
            for (int i = 0; i < count; ++i) {
                tag = EncodeTag.decode((Input)in);
                Geography feature = Geography.decode(in, tag);
                geo.features.add(feature);
            }
            geo.countShapes();
        }
        catch (EOFException e) {
            throw new IOException("GeographyCollection.decodeTagged error: insufficient data to decode all parts of the geography.", e);
        }
        return geo;
    }

    void countShapes() {
        this.numShapesList.clear();
        this.totalShapes = 0;
        for (Geography geo : this.features) {
            int n = geo.numShapes();
            this.numShapesList.add(n);
            this.totalShapes += n;
        }
    }
}

