/*
 * Decompiled with CFR 0.152.
 */
package com.mapzen.jpostal;

import com.mapzen.jpostal.Config;
import com.mapzen.jpostal.ExpanderOptions;
import com.mapzen.jpostal.LibPostal;
import java.nio.charset.StandardCharsets;

public class AddressExpander {
    private static volatile AddressExpander instance = null;
    private final LibPostal libPostal;

    private static synchronized native void setup();

    private static synchronized native void setupDataDir(String var0);

    private static synchronized native byte[][] libpostalExpand(byte[] var0, ExpanderOptions var1);

    private static synchronized native void teardown();

    public static AddressExpander getInstanceDataDir(String dataDir) {
        return AddressExpander.getInstanceConfig(Config.builder().dataDir(dataDir).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AddressExpander getInstanceConfig(Config config) {
        if (instance == null) {
            Class<AddressExpander> clazz = AddressExpander.class;
            synchronized (AddressExpander.class) {
                if (instance == null) {
                    instance = new AddressExpander(LibPostal.getInstance(config));
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
        } else if (!AddressExpander.instance.libPostal.getConfig().equals(config)) {
            throw Config.mismatchException(AddressExpander.instance.libPostal.getConfig(), config);
        }
        return instance;
    }

    public static AddressExpander getInstance() {
        return AddressExpander.getInstanceDataDir(null);
    }

    public static boolean isInitialized() {
        return instance != null;
    }

    public String[] expandAddress(String address) {
        return this.expandAddressWithOptions(address, new ExpanderOptions.Builder().build());
    }

    public String[] expandAddressWithOptions(String address, ExpanderOptions options) {
        if (address == null) {
            throw new NullPointerException("String address must not be null");
        }
        if (options == null) {
            throw new NullPointerException("ExpanderOptions options must not be null");
        }
        byte[][] expansionBytes = AddressExpander.libpostalExpand(address.getBytes(), options);
        String[] expansions = new String[expansionBytes.length];
        for (int i = 0; i < expansionBytes.length; ++i) {
            expansions[i] = new String(expansionBytes[i], StandardCharsets.UTF_8);
        }
        return expansions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AddressExpander(LibPostal libPostal) {
        if (libPostal == null) {
            throw new NullPointerException("LibPostal must not be null");
        }
        this.libPostal = libPostal;
        String dataDir = libPostal.getConfig().getDataDir();
        LibPostal libPostal2 = this.libPostal;
        synchronized (libPostal2) {
            if (dataDir == null) {
                AddressExpander.setup();
            } else {
                AddressExpander.setupDataDir(dataDir);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() {
        LibPostal libPostal = this.libPostal;
        synchronized (libPostal) {
            AddressExpander.teardown();
        }
    }

    public static void close() {
        LibPostal.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void _close() {
        if (instance == null) return;
        Class<AddressExpander> clazz = AddressExpander.class;
        synchronized (AddressExpander.class) {
            if (instance == null) return;
            AddressExpander.teardown();
            instance = null;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

