/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.geoparquet.internal;

import java.io.Serializable;
import org.apache.spark.SparkThrowable;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.Cast;
import org.apache.spark.sql.catalyst.expressions.Cast$;
import org.apache.spark.sql.catalyst.expressions.EvalMode$;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.optimizer.ConstantFolding$;
import org.apache.spark.sql.catalyst.parser.CatalystSqlParser;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.OneRowRelation;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.trees.TreePattern$;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.PortableSQLConf$;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.QueryCompilationErrors$;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.ResolveDefaultColumns$DefaultColumnAnalyzer$;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.ResolveDefaultColumns$DefaultColumnOptimizer$;
import org.apache.spark.sql.execution.datasources.geoparquet.internal.ResolveDefaultColumnsUtils;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.;
import scala.$less$colon$less$;
import scala.Array$;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple3;
import scala.collection.ArrayOps$;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

public final class ResolveDefaultColumns$
implements ResolveDefaultColumnsUtils {
    public static final ResolveDefaultColumns$ MODULE$ = new ResolveDefaultColumns$();
    private static String CURRENT_DEFAULT_COLUMN_METADATA_KEY;
    private static String EXISTS_DEFAULT_COLUMN_METADATA_KEY;

    static {
        ResolveDefaultColumnsUtils.$init$(MODULE$);
    }

    @Override
    public String CURRENT_DEFAULT_COLUMN_METADATA_KEY() {
        return CURRENT_DEFAULT_COLUMN_METADATA_KEY;
    }

    @Override
    public String EXISTS_DEFAULT_COLUMN_METADATA_KEY() {
        return EXISTS_DEFAULT_COLUMN_METADATA_KEY;
    }

    @Override
    public void org$apache$spark$sql$execution$datasources$geoparquet$internal$ResolveDefaultColumnsUtils$_setter_$CURRENT_DEFAULT_COLUMN_METADATA_KEY_$eq(String x$1) {
        CURRENT_DEFAULT_COLUMN_METADATA_KEY = x$1;
    }

    @Override
    public void org$apache$spark$sql$execution$datasources$geoparquet$internal$ResolveDefaultColumnsUtils$_setter_$EXISTS_DEFAULT_COLUMN_METADATA_KEY_$eq(String x$1) {
        EXISTS_DEFAULT_COLUMN_METADATA_KEY = x$1;
    }

    public Expression analyze(StructField field, String statementType, String metadataKey) {
        return this.analyze(field.name(), field.dataType(), field.metadata().getString(metadataKey), statementType);
    }

    public Expression analyze(String colName, DataType dataType, String defaultSQL, String statementType) {
        None$ none$;
        LogicalPlan logicalPlan;
        Expression expression;
        LazyRef parser$lzy = new LazyRef();
        try {
            expression = ResolveDefaultColumns$.parser$1(parser$lzy).parseExpression(defaultSQL);
        }
        catch (ParseException ex) {
            throw new IllegalArgumentException(new StringBuilder(133).append("Failed to execute ").append(statementType).append(" command because the destination table column ").append(colName).append(" has a DEFAULT value of ").append(defaultSQL).append(" which fails to parse as a valid ").append("expression: ").append(ex.getMessage()).toString());
        }
        Expression parsed = expression;
        if (parsed.containsPattern(TreePattern$.MODULE$.PLAN_EXPRESSION())) {
            throw new IllegalArgumentException(new StringBuilder(94).append("Default values may not contain sub query expressions: ").append(statementType).append(" command for column ").append(colName).append(" with default value ").append(defaultSQL).toString());
        }
        try {
            ResolveDefaultColumns$DefaultColumnAnalyzer$ analyzer = ResolveDefaultColumns$DefaultColumnAnalyzer$.MODULE$;
            Expression x$12 = parsed;
            String x$2 = colName;
            ExprId x$3 = Alias$.MODULE$.apply$default$3(x$12, x$2);
            Seq x$4 = Alias$.MODULE$.apply$default$4(x$12, x$2);
            Option x$5 = Alias$.MODULE$.apply$default$5(x$12, x$2);
            Seq x$6 = Alias$.MODULE$.apply$default$6(x$12, x$2);
            LogicalPlan analyzed = analyzer.execute((LogicalPlan)new Project((Seq)new .colon.colon((Object)new Alias(x$12, x$2, x$3, x$4, x$5, x$6), (List)Nil$.MODULE$), (LogicalPlan)new OneRowRelation()));
            analyzer.checkAnalysis(analyzed);
            logicalPlan = ConstantFolding$.MODULE$.apply(ResolveDefaultColumns$DefaultColumnOptimizer$.MODULE$.FinishAnalysis().apply(analyzed));
        }
        catch (AnalysisException ex) {
            throw new IllegalArgumentException(new StringBuilder(135).append("Failed to execute ").append(statementType).append(" command because the destination table column ").append(colName).append(" has a DEFAULT value of ").append(defaultSQL).append(" which fails to resolve as a valid ").append("expression: ").append(ex.getMessage()).toString());
        }
        LogicalPlan plan = logicalPlan;
        Expression analyzed = (Expression)plan.collectFirst((PartialFunction)new Serializable(){
            private static final long serialVersionUID = 0L;

            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                A1 A1 = x1;
                if (A1 instanceof Project) {
                    NamedExpression a;
                    SeqOps seqOps;
                    Project project = (Project)A1;
                    Seq seq = project.projectList();
                    LogicalPlan logicalPlan = project.child();
                    if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (a = (NamedExpression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof Alias) {
                        Alias alias = (Alias)a;
                        if (logicalPlan instanceof OneRowRelation) {
                            return (B1)alias.child();
                        }
                    }
                }
                return (B1)function1.apply(x1);
            }

            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                if (logicalPlan instanceof Project) {
                    NamedExpression a;
                    SeqOps seqOps;
                    Project project = (Project)logicalPlan;
                    Seq seq = project.projectList();
                    LogicalPlan logicalPlan2 = project.child();
                    if (seq != null && !SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq((SeqOps)seq)) && new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) != null && SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1) == 0 && (a = (NamedExpression)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0)) instanceof Alias && logicalPlan2 instanceof OneRowRelation) {
                        return true;
                    }
                }
                return false;
            }
        }).get();
        if (!analyzed.foldable()) {
            throw new IllegalArgumentException(new StringBuilder(71).append("Default value is not constant: ").append(statementType).append(" command for column ").append(colName).append(" with default value ").append(defaultSQL).toString());
        }
        if (!analyzed.resolved()) {
            throw new IllegalArgumentException(new StringBuilder(81).append("Unresolved expression in default values: ").append(statementType).append(" command for column ").append(colName).append(" with default value ").append(defaultSQL).toString());
        }
        DataType dataType2 = dataType;
        DataType dataType3 = analyzed.dataType();
        if (!(dataType2 != null ? !dataType2.equals(dataType3) : dataType3 != null)) {
            return analyzed;
        }
        if (Cast$.MODULE$.canUpCast(analyzed.dataType(), dataType)) {
            return new Cast(analyzed, dataType, Cast$.MODULE$.apply$default$3(), Cast$.MODULE$.apply$default$4());
        }
        if (analyzed instanceof Literal && !new .colon.colon((Object)dataType, (List)new .colon.colon((Object)analyzed.dataType(), (List)Nil$.MODULE$)).exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ResolveDefaultColumns$.$anonfun$analyze$1(x$1)))) {
            try {
                Expression x$7 = analyzed;
                DataType x$8 = dataType;
                Enumeration.Value x$9 = EvalMode$.MODULE$.TRY();
                Option x$10 = Cast$.MODULE$.apply$default$3();
                Cast qual$1 = new Cast(x$7, x$8, x$10, x$9);
                InternalRow x$11 = qual$1.eval$default$1();
                Object casted = qual$1.eval(x$11);
                if (casted != null) {
                    none$ = new Some((Object)new Literal(casted, dataType));
                }
                none$ = None$.MODULE$;
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof SparkThrowable ? true : throwable2 instanceof RuntimeException) {
                    none$ = None$.MODULE$;
                }
                throw throwable;
            }
        } else {
            none$ = None$.MODULE$;
        }
        None$ result = none$;
        return (Expression)result.getOrElse((Function0 & Serializable)() -> {
            throw new IllegalArgumentException(new StringBuilder(107).append("Default values data type error. data type: ").append(dataType).append(", analyzed data type: ").append(analyzed.dataType()).append(": ").append(statementType).append(" command for column ").append(colName).append(" with default value ").append(defaultSQL).toString());
        });
    }

    public String analyze$default$3() {
        return this.CURRENT_DEFAULT_COLUMN_METADATA_KEY();
    }

    public String normalizeFieldName(String str) {
        if (PortableSQLConf$.MODULE$.get().caseSensitiveAnalysis()) {
            return str;
        }
        return str.toLowerCase();
    }

    public Object[] getExistenceDefaultValues(StructType schema) {
        return (Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fields()), (Function1 & Serializable)field -> {
            Option defaultValue = field.getExistenceDefaultValue();
            return defaultValue.map((Function1 & Serializable)text -> {
                Expression expression;
                try {
                    Expression expr;
                    Expression expression2 = expr = MODULE$.analyze((StructField)field, "", MODULE$.EXISTS_DEFAULT_COLUMN_METADATA_KEY());
                    if (!(expression2 instanceof Literal ? true : expression2 instanceof Cast)) {
                        throw new MatchError((Object)expression2);
                    }
                    expression = expr;
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof AnalysisException ? true : throwable2 instanceof MatchError) {
                        throw QueryCompilationErrors$.MODULE$.failedToParseExistenceDefaultAsLiteral(field.name(), (String)text);
                    }
                    throw throwable;
                }
                Expression expr = expression;
                return expr.eval(expr.eval$default$1());
            }).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }, ClassTag$.MODULE$.Any());
    }

    public boolean[] getExistenceDefaultsBitmask(StructType schema) {
        return (boolean[])Array$.MODULE$.fill(ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.genericArrayOps((Object)this.existenceDefaultValues(schema))), (Function0)(JFunction0.mcZ.sp & Serializable)() -> true, (ClassTag)ClassTag$.MODULE$.Boolean());
    }

    public void resetExistenceDefaultsBitmask(StructType schema, boolean[] bitmask) {
        Object[] defaultValues = this.existenceDefaultValues(schema);
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.genericArrayOps((Object)defaultValues))).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
            bitmask$1[i] = defaultValues[i] != null;
        });
    }

    public void applyExistenceDefaultValuesToRow(StructType schema, InternalRow row, boolean[] bitmask) {
        Object[] existingValues = this.existenceDefaultValues(schema);
        if (this.hasExistenceDefaultValues(schema)) {
            RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), ArrayOps$.MODULE$.size$extension(Predef$.MODULE$.genericArrayOps((Object)existingValues))).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                if (bitmask[i]) {
                    row.update(i, existingValues[i]);
                    return;
                }
            });
            return;
        }
    }

    public Seq<Tuple3<String, String, String>> getDescribeMetadata(StructType schema) {
        ArrayBuffer rows;
        block0: {
            rows = new ArrayBuffer();
            if (!ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])schema.fields()), (Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ResolveDefaultColumns$.$anonfun$getDescribeMetadata$1(x$2)))) break block0;
            rows.append((Object)new Tuple3((Object)"", (Object)"", (Object)""));
            rows.append((Object)new Tuple3((Object)"# Column Default Values", (Object)"", (Object)""));
            schema.foreach((Function1 & Serializable)column -> column.getCurrentDefaultValue().map((Function1 & Serializable)value -> (ArrayBuffer)rows.append((Object)new Tuple3((Object)column.name(), (Object)column.dataType().simpleString(), value))));
        }
        return rows.toSeq();
    }

    public Object[] existenceDefaultValues(StructType schema) {
        return this.getExistenceDefaultValues(schema);
    }

    public boolean[] existenceDefaultsBitmask(StructType schema) {
        return this.getExistenceDefaultsBitmask(schema);
    }

    public boolean hasExistenceDefaultValues(StructType schema) {
        return ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.genericArrayOps((Object)this.existenceDefaultValues(schema)), (Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ResolveDefaultColumns$.$anonfun$hasExistenceDefaultValues$1(x$3)));
    }

    private static final /* synthetic */ CatalystSqlParser parser$lzycompute$1(LazyRef parser$lzy$1) {
        CatalystSqlParser catalystSqlParser;
        LazyRef lazyRef = parser$lzy$1;
        synchronized (lazyRef) {
            catalystSqlParser = parser$lzy$1.initialized() ? (CatalystSqlParser)parser$lzy$1.value() : (CatalystSqlParser)parser$lzy$1.initialize((Object)new CatalystSqlParser());
        }
        return catalystSqlParser;
    }

    private static final CatalystSqlParser parser$1(LazyRef parser$lzy$1) {
        if (parser$lzy$1.initialized()) {
            return (CatalystSqlParser)parser$lzy$1.value();
        }
        return ResolveDefaultColumns$.parser$lzycompute$1(parser$lzy$1);
    }

    public static final /* synthetic */ boolean $anonfun$analyze$1(DataType x$1) {
        DataType dataType = x$1;
        return dataType instanceof BooleanType ? true : (dataType instanceof ArrayType ? true : (dataType instanceof StructType ? true : dataType instanceof MapType));
    }

    public static final /* synthetic */ boolean $anonfun$getDescribeMetadata$1(StructField x$2) {
        return x$2.metadata().contains(MODULE$.CURRENT_DEFAULT_COLUMN_METADATA_KEY());
    }

    public static final /* synthetic */ boolean $anonfun$hasExistenceDefaultValues$1(Object x$3) {
        return x$3 != null;
    }

    private ResolveDefaultColumns$() {
    }
}

