/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sedona_sql.io.raster;

import java.awt.RenderingHints;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.Serializable;
import java.nio.file.Paths;
import javax.media.jai.RasterFactory;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.sedona.sql.utils.GeometrySerializer$;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.sedona_sql.io.raster.ImageWriteOptions;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridFormatFinder;
import org.geotools.gce.geotiff.GeoTiffFormat;
import org.geotools.gce.geotiff.GeoTiffWriteParams;
import org.geotools.gce.geotiff.GeoTiffWriter;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.WKTReader;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001a4A!\u0004\b\u0005;!Aa\u0005\u0001B\u0001B\u0003%q\u0005\u0003\u00055\u0001\t\u0005\t\u0015!\u00036\u0011!I\u0004A!A!\u0002\u0013Q\u0004\u0002\u0003!\u0001\u0005\u0003\u0005\u000b\u0011B!\t\u000b%\u0003A\u0011\u0001&\t\u000fA\u0003!\u0019!C\u0005#\"1A\f\u0001Q\u0001\nICq!\u0018\u0001C\u0002\u0013%a\f\u0003\u0004f\u0001\u0001\u0006Ia\u0018\u0005\u0006M\u0002!\te\u001a\u0005\u0006i\u0002!\t%\u001e\u0005\u0006m\u0002!\ta\u001e\u0002\u0012\u000f\u0016|G/\u001b4g\r&dWm\u0016:ji\u0016\u0014(BA\b\u0011\u0003\u0019\u0011\u0018m\u001d;fe*\u0011\u0011CE\u0001\u0003S>T!a\u0005\u000b\u0002\u0015M,Gm\u001c8b?N\fHN\u0003\u0002\u0016-\u0005\u00191/\u001d7\u000b\u0005]A\u0012!B:qCJ\\'BA\r\u001b\u0003\u0019\t\u0007/Y2iK*\t1$A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001=A\u0011q\u0004J\u0007\u0002A)\u0011\u0011EI\u0001\fI\u0006$\u0018m]8ve\u000e,7O\u0003\u0002$)\u0005IQ\r_3dkRLwN\\\u0005\u0003K\u0001\u0012AbT;uaV$xK]5uKJ\f\u0001b]1wKB\u000bG\u000f\u001b\t\u0003QEr!!K\u0018\u0011\u0005)jS\"A\u0016\u000b\u00051b\u0012A\u0002\u001fs_>$hHC\u0001/\u0003\u0015\u00198-\u00197b\u0013\t\u0001T&\u0001\u0004Qe\u0016$WMZ\u0005\u0003eM\u0012aa\u0015;sS:<'B\u0001\u0019.\u0003EIW.Y4f/JLG/Z(qi&|gn\u001d\t\u0003m]j\u0011AD\u0005\u0003q9\u0011\u0011#S7bO\u0016<&/\u001b;f\u001fB$\u0018n\u001c8t\u0003)!\u0017\r^1TG\",W.\u0019\t\u0003wyj\u0011\u0001\u0010\u0006\u0003{Q\tQ\u0001^=qKNL!a\u0010\u001f\u0003\u0015M#(/^2u)f\u0004X-A\u0004d_:$X\r\u001f;\u0011\u0005\t;U\"A\"\u000b\u0005\u0011+\u0015!C7baJ,G-^2f\u0015\t1\u0005$\u0001\u0004iC\u0012|w\u000e]\u0005\u0003\u0011\u000e\u0013!\u0003V1tW\u0006#H/Z7qi\u000e{g\u000e^3yi\u00061A(\u001b8jiz\"Ra\u0013'N\u001d>\u0003\"A\u000e\u0001\t\u000b\u0019*\u0001\u0019A\u0014\t\u000bQ*\u0001\u0019A\u001b\t\u000be*\u0001\u0019\u0001\u001e\t\u000b\u0001+\u0001\u0019A!\u0002)\u0011+e)Q+M)~;&+\u0013+F?B\u000b%+Q'T+\u0005\u0011\u0006CA*[\u001b\u0005!&BA+W\u0003\u001d9Wm\u001c;jM\u001aT!a\u0016-\u0002\u0007\u001d\u001cWM\u0003\u0002Z5\u0005Aq-Z8u_>d7/\u0003\u0002\\)\n\u0011r)Z8US\u001a4wK]5uKB\u000b'/Y7t\u0003U!UIR!V\u0019R{vKU%U\u000b~\u0003\u0016IU!N'\u0002\n1\u0001\u001b4t+\u0005y\u0006C\u00011d\u001b\u0005\t'B\u00012F\u0003\t17/\u0003\u0002eC\nQa)\u001b7f'f\u001cH/Z7\u0002\t!47\u000fI\u0001\u0006oJLG/\u001a\u000b\u0003Q2\u0004\"!\u001b6\u000e\u00035J!a[\u0017\u0003\tUs\u0017\u000e\u001e\u0005\u0006[*\u0001\rA\\\u0001\u0004e><\bCA8s\u001b\u0005\u0001(BA9\u0015\u0003!\u0019\u0017\r^1msN$\u0018BA:q\u0005-Ie\u000e^3s]\u0006d'k\\<\u0002\u000b\rdwn]3\u0015\u0003!\fA\u0001]1uQR\tq\u0005")
public class GeotiffFileWriter
extends OutputWriter {
    private final String savePath;
    private final ImageWriteOptions imageWriteOptions;
    private final StructType dataSchema;
    private final GeoTiffWriteParams DEFAULT_WRITE_PARAMS;
    private final FileSystem hfs;

    private GeoTiffWriteParams DEFAULT_WRITE_PARAMS() {
        return this.DEFAULT_WRITE_PARAMS;
    }

    private FileSystem hfs() {
        return this.hfs;
    }

    public void write(InternalRow row) {
        InternalRow rowFields = row;
        StructType schemaFields = this.dataSchema;
        String[] fields = this.dataSchema.fieldNames();
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fields)).contains((Object)this.imageWriteOptions.colImage())) {
            schemaFields = (StructType)this.dataSchema.fields()[this.dataSchema.fieldIndex(this.imageWriteOptions.colImage())].dataType();
            rowFields = row.getStruct(this.dataSchema.fieldIndex(this.imageWriteOptions.colImage()), 6);
        }
        String tiffOrigin = rowFields.getString(schemaFields.fieldIndex(this.imageWriteOptions.colOrigin()));
        int tiffBands = rowFields.getInt(schemaFields.fieldIndex(this.imageWriteOptions.colBands()));
        int tiffWidth = rowFields.getInt(schemaFields.fieldIndex(this.imageWriteOptions.colWidth()));
        int tiffHeight = rowFields.getInt(schemaFields.fieldIndex(this.imageWriteOptions.colHeight()));
        Object tiffGeometry = Row$.MODULE$.fromSeq(rowFields.toSeq(schemaFields)).get(schemaFields.fieldIndex(this.imageWriteOptions.colGeometry()));
        double[] tiffData = rowFields.getArray(schemaFields.fieldIndex(this.imageWriteOptions.colData())).toDoubleArray();
        if (tiffBands == -1) {
            return;
        }
        WritableRaster raster = RasterFactory.createBandedRaster((int)5, (int)tiffWidth, (int)tiffHeight, (int)tiffBands, null);
        double[] pixelVal = (double[])Array$.MODULE$.ofDim(tiffBands, ClassTag$.MODULE$.Double());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), tiffHeight).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), tiffWidth).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)j -> {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), tiffBands).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)k -> {
                pixelVal$1[k] = tiffData[tiffHeight * tiffWidth * k + i * tiffWidth + j];
            });
            raster.setPixel(j, i, pixelVal);
        }));
        CoordinateReferenceSystem crs = CRS.decode((String)this.imageWriteOptions.writeToCRS(), (boolean)true);
        Coordinate[] coordinateList = null;
        if (tiffGeometry instanceof UTF8String) {
            WKTReader wktReader = new WKTReader();
            Polygon envGeom = (Polygon)wktReader.read(tiffGeometry.toString());
            coordinateList = envGeom.getCoordinates();
        } else {
            Geometry envGeom = GeometrySerializer$.MODULE$.deserialize((byte[])tiffGeometry);
            coordinateList = envGeom.getCoordinates();
        }
        ReferencedEnvelope referencedEnvelope = new ReferencedEnvelope(coordinateList[0].x, coordinateList[2].x, coordinateList[0].y, coordinateList[2].y, crs);
        String writePath = ((Object)Paths.get(this.savePath, new Path(tiffOrigin).getName())).toString();
        FSDataOutputStream out = this.hfs().create(new Path(writePath));
        AbstractGridFormat format = GridFormatFinder.findFormat((Object)out);
        Hints hints = null;
        if (format instanceof GeoTiffFormat) {
            hints = new Hints((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)BoxesRunTime.boxToBoolean((boolean)true));
        }
        GridCoverageFactory factory = CoverageFactoryFinder.getGridCoverageFactory(hints);
        GridCoverage2D gc = factory.create((CharSequence)"GRID", raster, (Envelope)referencedEnvelope);
        GeoTiffWriter writer = new GeoTiffWriter((Object)out, hints);
        ParameterValueGroup gtiffParams = new GeoTiffFormat().getWriteParameters();
        gtiffParams.parameter(AbstractGridFormat.GEOTOOLS_WRITE_PARAMS.getName().toString()).setValue((Object)this.DEFAULT_WRITE_PARAMS());
        GeneralParameterValue[] wps = (GeneralParameterValue[])gtiffParams.values().toArray((Object[])new GeneralParameterValue[1]);
        try {
            writer.write((GridCoverage)gc, wps);
            writer.dispose();
            out.close();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl = throwable2 instanceof IllegalArgumentException ? true : throwable2 instanceof IOException;
            if (bl) {
                throwable2.printStackTrace();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    public void close() {
        this.hfs().close();
    }

    public String path() {
        return this.savePath;
    }

    public GeotiffFileWriter(String savePath, ImageWriteOptions imageWriteOptions, StructType dataSchema, TaskAttemptContext context) {
        this.savePath = savePath;
        this.imageWriteOptions = imageWriteOptions;
        this.dataSchema = dataSchema;
        this.DEFAULT_WRITE_PARAMS = new GeoTiffWriteParams();
        this.DEFAULT_WRITE_PARAMS().setCompressionMode(2);
        this.DEFAULT_WRITE_PARAMS().setCompressionType("LZW");
        this.DEFAULT_WRITE_PARAMS().setCompressionQuality(0.75f);
        this.DEFAULT_WRITE_PARAMS().setTilingMode(2);
        this.DEFAULT_WRITE_PARAMS().setTiling(512, 512);
        this.hfs = new Path(savePath).getFileSystem(context.getConfiguration());
    }
}

