/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.config.sql;

import java.util.List;
import org.apache.seatunnel.config.sql.model.Option;
import org.apache.seatunnel.config.sql.model.SeaTunnelConfig;
import org.apache.seatunnel.config.sql.model.SinkConfig;
import org.apache.seatunnel.config.sql.model.SourceConfig;
import org.apache.seatunnel.config.sql.model.TransformConfig;

public class ConfigTemplate {
    private static String globalConfig(List<String> envConfigs) {
        StringBuilder result = new StringBuilder();
        envConfigs.forEach(envConfig -> result.append((String)envConfig).append("\n"));
        return result.toString();
    }

    private static String sourceItems(List<SourceConfig> sourceConfigs) {
        StringBuilder sourceItems = new StringBuilder();
        for (SourceConfig sourceConfig : sourceConfigs) {
            if (sourceConfig.getOptions().isEmpty()) continue;
            sourceItems.append("  ").append(sourceConfig.getConnector()).append(" {\n");
            for (Option option : sourceConfig.getOptions()) {
                sourceItems.append("    ").append(option.getKey()).append(" = ").append(option.getValue()).append("\n");
            }
            sourceItems.append("  }\n");
        }
        return sourceItems.toString();
    }

    private static String sinkItems(List<SinkConfig> sinkConfigs) {
        StringBuilder sinkItems = new StringBuilder();
        for (SinkConfig sinkConfig : sinkConfigs) {
            if (sinkConfig.getOptions().isEmpty()) continue;
            sinkItems.append("  ").append(sinkConfig.getConnector()).append(" {\n");
            for (Option option : sinkConfig.getOptions()) {
                sinkItems.append("    ").append(option.getKey()).append(" = ").append(option.getValue()).append("\n");
            }
            sinkItems.append("  }\n");
        }
        return sinkItems.toString();
    }

    private static String transformItems(List<TransformConfig> transformConfigs) {
        StringBuilder transformItems = new StringBuilder();
        for (TransformConfig transformConfig : transformConfigs) {
            transformItems.append("  sql {\n");
            transformItems.append("    source_table_name = \"").append(transformConfig.getSourceTableName()).append("\"\n");
            transformItems.append("    query = \"\"\"").append(transformConfig.getQuery()).append("\"\"\"\n");
            transformItems.append("    result_table_name = \"").append(transformConfig.getResultTableName()).append("\"\n");
            transformItems.append("  }\n");
        }
        return transformItems.toString();
    }

    public static String generate(SeaTunnelConfig seaTunnelConfig) {
        String globalConfig = ConfigTemplate.globalConfig(seaTunnelConfig.getEnvConfigs());
        String sourceTemplate = "source {\n" + ConfigTemplate.sourceItems(seaTunnelConfig.getSourceConfigs()) + "}\n";
        String sinkTemplate = "sink {\n" + ConfigTemplate.sinkItems(seaTunnelConfig.getSinkConfigs()) + "}\n";
        String transformTemplate = "transform {\n" + ConfigTemplate.transformItems(seaTunnelConfig.getTransformConfigs()) + "}\n";
        return globalConfig + sourceTemplate + transformTemplate + sinkTemplate;
    }
}

