/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.core.starter.spark.execution;

import com.google.common.collect.Lists;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.seatunnel.api.common.JobContext;
import org.apache.seatunnel.api.source.SeaTunnelSource;
import org.apache.seatunnel.common.utils.SerializationUtils;
import org.apache.seatunnel.core.starter.spark.execution.AbstractPluginExecuteProcessor;
import org.apache.seatunnel.plugin.discovery.PluginIdentifier;
import org.apache.seatunnel.plugin.discovery.seatunnel.SeaTunnelSourcePluginDiscovery;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.spark.SparkEnvironment;
import org.apache.seatunnel.translation.spark.common.utils.TypeConverterUtils;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.types.StructType;

public class SourceExecuteProcessor
extends AbstractPluginExecuteProcessor<SeaTunnelSource<?, ?, ?>> {
    private static final String PLUGIN_TYPE = "source";

    public SourceExecuteProcessor(SparkEnvironment sparkEnvironment, JobContext jobContext, List<? extends Config> sourceConfigs) {
        super(sparkEnvironment, jobContext, sourceConfigs);
    }

    @Override
    public List<Dataset<Row>> execute(List<Dataset<Row>> upstreamDataStreams) {
        ArrayList<Dataset<Row>> sources = new ArrayList<Dataset<Row>>();
        for (int i = 0; i < this.plugins.size(); ++i) {
            SeaTunnelSource source = (SeaTunnelSource)this.plugins.get(i);
            Config pluginConfig = (Config)this.pluginConfigs.get(i);
            int parallelism = pluginConfig.hasPath("parallelism") ? pluginConfig.getInt("parallelism") : this.sparkEnvironment.getSparkConf().getInt("parallelism", 1);
            Dataset dataset = this.sparkEnvironment.getSparkSession().read().format(SeaTunnelSource.class.getSimpleName()).option("parallelism", (long)parallelism).option("source.serialization", SerializationUtils.objectToString(source)).schema((StructType)TypeConverterUtils.convert(source.getProducedType())).load();
            sources.add((Dataset<Row>)dataset);
            this.registerInputTempView((Config)this.pluginConfigs.get(i), (Dataset<Row>)dataset);
        }
        return sources;
    }

    @Override
    protected List<SeaTunnelSource<?, ?, ?>> initializePlugins(List<? extends Config> pluginConfigs) {
        SeaTunnelSourcePluginDiscovery sourcePluginDiscovery = new SeaTunnelSourcePluginDiscovery();
        ArrayList sources = new ArrayList();
        HashSet<URL> jars = new HashSet<URL>();
        for (Config config : pluginConfigs) {
            PluginIdentifier pluginIdentifier = PluginIdentifier.of("seatunnel", PLUGIN_TYPE, config.getString("plugin_name"));
            jars.addAll(sourcePluginDiscovery.getPluginJarPaths(Lists.newArrayList(pluginIdentifier)));
            SeaTunnelSource seaTunnelSource = (SeaTunnelSource)sourcePluginDiscovery.createPluginInstance(pluginIdentifier);
            seaTunnelSource.prepare(config);
            seaTunnelSource.setJobContext(this.jobContext);
            sources.add(seaTunnelSource);
        }
        this.sparkEnvironment.registerPlugin(new ArrayList<URL>(jars));
        return sources;
    }
}

