/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.configuration.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.util.Condition;
import org.apache.seatunnel.api.configuration.util.Expression;

public interface RequiredOption {

    public static class ConditionalRequiredOptions
    implements RequiredOption {
        private final Expression expression;
        private final Set<Option<?>> requiredOption;

        ConditionalRequiredOptions(Expression expression, Set<Option<?>> requiredOption) {
            this.expression = expression;
            this.requiredOption = requiredOption;
        }

        public static ConditionalRequiredOptions of(Expression expression, Set<Option<?>> requiredOption) {
            return new ConditionalRequiredOptions(expression, requiredOption);
        }

        public static ConditionalRequiredOptions of(Condition<?> condition, Set<Option<?>> requiredOption) {
            return new ConditionalRequiredOptions(Expression.of(condition), requiredOption);
        }

        public Expression getExpression() {
            return this.expression;
        }

        public Set<Option<?>> getRequiredOption() {
            return this.requiredOption;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ConditionalRequiredOptions)) {
                return false;
            }
            ConditionalRequiredOptions that = (ConditionalRequiredOptions)obj;
            return Objects.equals(this.expression, that.expression) && Objects.equals(this.requiredOption, that.requiredOption);
        }

        public int hashCode() {
            return this.requiredOption.hashCode();
        }

        public String toString() {
            return String.format("Condition expression: %s, Required options: %s", this.expression, ExclusiveRequiredOptions.getOptionKeys(this.requiredOption));
        }
    }

    public static class AbsolutelyRequiredOption<T>
    implements RequiredOption {
        private final Option<T> requiredOption;

        AbsolutelyRequiredOption(Option<T> requiredOption) {
            this.requiredOption = requiredOption;
        }

        public static <T> AbsolutelyRequiredOption<T> of(Option<T> requiredOption) {
            return new AbsolutelyRequiredOption<T>(requiredOption);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof AbsolutelyRequiredOption)) {
                return false;
            }
            AbsolutelyRequiredOption that = (AbsolutelyRequiredOption)obj;
            return Objects.equals(this.requiredOption, that.requiredOption);
        }

        public int hashCode() {
            return this.requiredOption.hashCode();
        }

        public String toString() {
            return String.format("Absolutely required option: '%s'", this.requiredOption.key());
        }
    }

    public static class ExclusiveRequiredOptions
    implements RequiredOption {
        private final Set<Option<?>> exclusiveOptions;

        ExclusiveRequiredOptions(Set<Option<?>> exclusiveOptions) {
            this.exclusiveOptions = exclusiveOptions;
        }

        public static ExclusiveRequiredOptions of(Option<?> ... exclusiveOptions) {
            return new ExclusiveRequiredOptions(new HashSet(Arrays.asList(exclusiveOptions)));
        }

        public Set<Option<?>> getExclusiveOptions() {
            return this.exclusiveOptions;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ExclusiveRequiredOptions)) {
                return false;
            }
            ExclusiveRequiredOptions that = (ExclusiveRequiredOptions)obj;
            return Objects.equals(this.exclusiveOptions, that.exclusiveOptions);
        }

        public int hashCode() {
            return Objects.hash(this.exclusiveOptions);
        }

        static String getOptionKeys(Set<Option<?>> options) {
            StringBuilder builder = new StringBuilder();
            int i = 0;
            for (Option<?> option : options) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append("'").append(option.key()).append("'");
                ++i;
            }
            return builder.toString();
        }

        public String toString() {
            return String.format("Exclusive required options: %s", ExclusiveRequiredOptions.getOptionKeys(this.exclusiveOptions));
        }
    }
}

