/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.task;

import java.net.URL;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.seatunnel.api.serialization.Serializer;
import org.apache.seatunnel.engine.common.utils.ExceptionUtil;
import org.apache.seatunnel.engine.server.checkpoint.operation.TaskReportStatusOperation;
import org.apache.seatunnel.engine.server.execution.ProgressState;
import org.apache.seatunnel.engine.server.execution.Task;
import org.apache.seatunnel.engine.server.execution.TaskExecutionContext;
import org.apache.seatunnel.engine.server.execution.TaskLocation;
import org.apache.seatunnel.engine.server.task.Progress;
import org.apache.seatunnel.engine.server.task.statemachine.SeaTunnelTaskState;

public abstract class AbstractTask
implements Task {
    private static final long serialVersionUID = -2524701323779523718L;
    protected TaskExecutionContext executionContext;
    protected final long jobID;
    protected final TaskLocation taskLocation;
    protected volatile boolean restoreComplete;
    protected volatile boolean startCalled;
    protected volatile boolean closeCalled;
    protected volatile boolean prepareCloseStatus;
    protected AtomicLong prepareCloseBarrierId;
    protected Progress progress;

    public AbstractTask(long jobID, TaskLocation taskLocation) {
        this.taskLocation = taskLocation;
        this.jobID = jobID;
        this.progress = new Progress();
        this.restoreComplete = false;
        this.startCalled = false;
        this.closeCalled = false;
        this.prepareCloseStatus = false;
        this.prepareCloseBarrierId = new AtomicLong(-1L);
    }

    public abstract Set<URL> getJarsUrl();

    @Override
    public void setTaskExecutionContext(TaskExecutionContext taskExecutionContext) {
        this.executionContext = taskExecutionContext;
    }

    public TaskExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    @Override
    public void init() throws Exception {
        this.progress.start();
    }

    @Override
    @NonNull
    public ProgressState call() throws Exception {
        return this.progress.toState();
    }

    public TaskLocation getTaskLocation() {
        return this.taskLocation;
    }

    @Override
    @NonNull
    public Long getTaskID() {
        return this.taskLocation.getTaskID();
    }

    protected void reportTaskStatus(SeaTunnelTaskState status) {
        this.getExecutionContext().sendToMaster(new TaskReportStatusOperation(this.taskLocation, status)).join();
    }

    public static <T> List<byte[]> serializeStates(Serializer<T> serializer, List<T> states) {
        return states.stream().map(state -> ExceptionUtil.sneaky(() -> serializer.serialize(state))).collect(Collectors.toList());
    }

    public void startCall() {
        this.startCalled = true;
    }

    public void tryClose(long checkpointId) {
        if (this.prepareCloseStatus && this.prepareCloseBarrierId.get() == checkpointId) {
            this.closeCall();
        }
    }

    public void closeCall() {
        this.closeCalled = true;
    }
}

