/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.checkpoint;

import com.beust.jcommander.internal.Nullable;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.seatunnel.engine.common.utils.PassiveCompletableFuture;
import org.apache.seatunnel.engine.core.checkpoint.Checkpoint;
import org.apache.seatunnel.engine.core.checkpoint.CheckpointType;
import org.apache.seatunnel.engine.server.checkpoint.ActionState;
import org.apache.seatunnel.engine.server.checkpoint.ActionSubtaskState;
import org.apache.seatunnel.engine.server.checkpoint.CheckpointException;
import org.apache.seatunnel.engine.server.checkpoint.CheckpointFailureReason;
import org.apache.seatunnel.engine.server.checkpoint.CompletedCheckpoint;
import org.apache.seatunnel.engine.server.checkpoint.SubtaskStatistics;
import org.apache.seatunnel.engine.server.checkpoint.SubtaskStatus;
import org.apache.seatunnel.engine.server.checkpoint.TaskStatistics;
import org.apache.seatunnel.engine.server.execution.TaskLocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PendingCheckpoint
implements Checkpoint {
    private static final Logger LOG = LoggerFactory.getLogger(PendingCheckpoint.class);
    private final long jobId;
    private final int pipelineId;
    private final long checkpointId;
    private final long triggerTimestamp;
    private final CheckpointType checkpointType;
    private final Set<Long> notYetAcknowledgedTasks;
    private final Map<Long, TaskStatistics> taskStatistics;
    private final Map<Long, ActionState> actionStates;
    private final CompletableFuture<CompletedCheckpoint> completableFuture;
    private CheckpointException failureCause;

    public PendingCheckpoint(long jobId, int pipelineId, long checkpointId, long triggerTimestamp, CheckpointType checkpointType, Set<Long> notYetAcknowledgedTasks, Map<Long, TaskStatistics> taskStatistics, Map<Long, ActionState> actionStates) {
        this.jobId = jobId;
        this.pipelineId = pipelineId;
        this.checkpointId = checkpointId;
        this.triggerTimestamp = triggerTimestamp;
        this.checkpointType = checkpointType;
        this.notYetAcknowledgedTasks = notYetAcknowledgedTasks;
        this.taskStatistics = taskStatistics;
        this.actionStates = actionStates;
        this.completableFuture = new CompletableFuture();
    }

    @Override
    public long getCheckpointId() {
        return this.checkpointId;
    }

    @Override
    public int getPipelineId() {
        return this.pipelineId;
    }

    @Override
    public long getJobId() {
        return this.jobId;
    }

    @Override
    public long getCheckpointTimestamp() {
        return this.triggerTimestamp;
    }

    @Override
    public CheckpointType getCheckpointType() {
        return this.checkpointType;
    }

    protected Map<Long, TaskStatistics> getTaskStatistics() {
        return this.taskStatistics;
    }

    protected Map<Long, ActionState> getActionStates() {
        return this.actionStates;
    }

    public PassiveCompletableFuture<CompletedCheckpoint> getCompletableFuture() {
        return new PassiveCompletableFuture<CompletedCheckpoint>(this.completableFuture);
    }

    public void acknowledgeTask(TaskLocation taskLocation, List<ActionSubtaskState> states, SubtaskStatus subtaskStatus) {
        boolean exist = this.notYetAcknowledgedTasks.remove(taskLocation.getTaskID());
        if (!exist) {
            return;
        }
        TaskStatistics statistics = this.taskStatistics.get(taskLocation.getTaskVertexId());
        long stateSize = 0L;
        for (ActionSubtaskState state : states) {
            ActionState actionState = this.actionStates.get(state.getActionId());
            if (actionState == null) {
                return;
            }
            stateSize += state.getState().stream().filter(Objects::nonNull).map(s2 -> ((byte[])s2).length).count();
            actionState.reportState(state.getIndex(), state);
        }
        statistics.reportSubtaskStatistics(new SubtaskStatistics(taskLocation.getTaskIndex(), Instant.now().toEpochMilli(), stateSize, subtaskStatus));
        if (this.isFullyAcknowledged()) {
            LOG.debug("checkpoint is full ack!");
            this.completableFuture.complete(this.toCompletedCheckpoint());
        }
    }

    protected boolean isFullyAcknowledged() {
        return this.notYetAcknowledgedTasks.size() == 0;
    }

    private CompletedCheckpoint toCompletedCheckpoint() {
        return new CompletedCheckpoint(this.jobId, this.pipelineId, this.checkpointId, this.triggerTimestamp, this.checkpointType, System.currentTimeMillis(), this.actionStates, this.taskStatistics);
    }

    public void abortCheckpoint(CheckpointFailureReason failureReason, @Nullable Throwable cause) {
        this.failureCause = new CheckpointException(failureReason, cause);
        this.completableFuture.completeExceptionally(this.failureCause);
    }

    public CheckpointException getFailureCause() {
        return this.failureCause;
    }
}

