/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.examples.arithmetic.expression;

import java.util.Map;
import org.apache.ratis.examples.arithmetic.expression.Expression;
import org.apache.ratis.util.Preconditions;

public final class NullValue
implements Expression {
    private static final NullValue INSTANCE = new NullValue();

    public static NullValue getInstance() {
        return INSTANCE;
    }

    private NullValue() {
    }

    @Override
    public int toBytes(byte[] buf, int offset) {
        Preconditions.assertTrue(offset + this.length() <= buf.length);
        buf[offset] = Expression.Type.NULL.byteValue();
        return this.length();
    }

    @Override
    public int length() {
        return 1;
    }

    @Override
    public Double evaluate(Map<String, Double> variableMap) {
        return null;
    }

    public String toString() {
        return "null";
    }
}

