/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.batch.implementation;

import com.google.common.reflect.TypeToken;
import com.microsoft.azure.AzureServiceFuture;
import com.microsoft.azure.CloudException;
import com.microsoft.azure.ListOperationCallback;
import com.microsoft.azure.Page;
import com.microsoft.azure.PagedList;
import com.microsoft.azure.management.batch.ApplicationCreateParameters;
import com.microsoft.azure.management.batch.ApplicationUpdateParameters;
import com.microsoft.azure.management.batch.implementation.ApplicationInner;
import com.microsoft.azure.management.batch.implementation.BatchManagementClientImpl;
import com.microsoft.azure.management.batch.implementation.PageImpl;
import com.microsoft.rest.ServiceCallback;
import com.microsoft.rest.ServiceFuture;
import com.microsoft.rest.ServiceResponse;
import com.microsoft.rest.Validator;
import java.io.IOException;
import java.util.List;
import okhttp3.ResponseBody;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.HTTP;
import retrofit2.http.Header;
import retrofit2.http.Headers;
import retrofit2.http.PATCH;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;
import retrofit2.http.Url;
import rx.Observable;
import rx.functions.Func1;

public class ApplicationsInner {
    private ApplicationsService service;
    private BatchManagementClientImpl client;

    public ApplicationsInner(Retrofit retrofit, BatchManagementClientImpl client) {
        this.service = (ApplicationsService)retrofit.create(ApplicationsService.class);
        this.client = client;
    }

    public ApplicationInner create(String resourceGroupName, String accountName, String applicationId) {
        return (ApplicationInner)((ServiceResponse)this.createWithServiceResponseAsync(resourceGroupName, accountName, applicationId).toBlocking().single()).body();
    }

    public ServiceFuture<ApplicationInner> createAsync(String resourceGroupName, String accountName, String applicationId, ServiceCallback<ApplicationInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createWithServiceResponseAsync(resourceGroupName, accountName, applicationId), serviceCallback);
    }

    public Observable<ApplicationInner> createAsync(String resourceGroupName, String accountName, String applicationId) {
        return this.createWithServiceResponseAsync(resourceGroupName, accountName, applicationId).map((Func1)new Func1<ServiceResponse<ApplicationInner>, ApplicationInner>(){

            public ApplicationInner call(ServiceResponse<ApplicationInner> response) {
                return (ApplicationInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ApplicationInner>> createWithServiceResponseAsync(String resourceGroupName, String accountName, String applicationId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (applicationId == null) {
            throw new IllegalArgumentException("Parameter applicationId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        ApplicationCreateParameters parameters = null;
        return this.service.create(resourceGroupName, accountName, applicationId, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ApplicationInner>>>(){

            public Observable<ServiceResponse<ApplicationInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ApplicationsInner.this.createDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public ApplicationInner create(String resourceGroupName, String accountName, String applicationId, ApplicationCreateParameters parameters) {
        return (ApplicationInner)((ServiceResponse)this.createWithServiceResponseAsync(resourceGroupName, accountName, applicationId, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<ApplicationInner> createAsync(String resourceGroupName, String accountName, String applicationId, ApplicationCreateParameters parameters, ServiceCallback<ApplicationInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.createWithServiceResponseAsync(resourceGroupName, accountName, applicationId, parameters), serviceCallback);
    }

    public Observable<ApplicationInner> createAsync(String resourceGroupName, String accountName, String applicationId, ApplicationCreateParameters parameters) {
        return this.createWithServiceResponseAsync(resourceGroupName, accountName, applicationId, parameters).map((Func1)new Func1<ServiceResponse<ApplicationInner>, ApplicationInner>(){

            public ApplicationInner call(ServiceResponse<ApplicationInner> response) {
                return (ApplicationInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ApplicationInner>> createWithServiceResponseAsync(String resourceGroupName, String accountName, String applicationId, ApplicationCreateParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (applicationId == null) {
            throw new IllegalArgumentException("Parameter applicationId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.create(resourceGroupName, accountName, applicationId, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ApplicationInner>>>(){

            public Observable<ServiceResponse<ApplicationInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ApplicationsInner.this.createDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ApplicationInner> createDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(201, new TypeToken<ApplicationInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void delete(String resourceGroupName, String accountName, String applicationId) {
        ((ServiceResponse)this.deleteWithServiceResponseAsync(resourceGroupName, accountName, applicationId).toBlocking().single()).body();
    }

    public ServiceFuture<Void> deleteAsync(String resourceGroupName, String accountName, String applicationId, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.deleteWithServiceResponseAsync(resourceGroupName, accountName, applicationId), serviceCallback);
    }

    public Observable<Void> deleteAsync(String resourceGroupName, String accountName, String applicationId) {
        return this.deleteWithServiceResponseAsync(resourceGroupName, accountName, applicationId).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> deleteWithServiceResponseAsync(String resourceGroupName, String accountName, String applicationId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (applicationId == null) {
            throw new IllegalArgumentException("Parameter applicationId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.delete(resourceGroupName, accountName, applicationId, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ApplicationsInner.this.deleteDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> deleteDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public ApplicationInner get(String resourceGroupName, String accountName, String applicationId) {
        return (ApplicationInner)((ServiceResponse)this.getWithServiceResponseAsync(resourceGroupName, accountName, applicationId).toBlocking().single()).body();
    }

    public ServiceFuture<ApplicationInner> getAsync(String resourceGroupName, String accountName, String applicationId, ServiceCallback<ApplicationInner> serviceCallback) {
        return ServiceFuture.fromResponse(this.getWithServiceResponseAsync(resourceGroupName, accountName, applicationId), serviceCallback);
    }

    public Observable<ApplicationInner> getAsync(String resourceGroupName, String accountName, String applicationId) {
        return this.getWithServiceResponseAsync(resourceGroupName, accountName, applicationId).map((Func1)new Func1<ServiceResponse<ApplicationInner>, ApplicationInner>(){

            public ApplicationInner call(ServiceResponse<ApplicationInner> response) {
                return (ApplicationInner)response.body();
            }
        });
    }

    public Observable<ServiceResponse<ApplicationInner>> getWithServiceResponseAsync(String resourceGroupName, String accountName, String applicationId) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (applicationId == null) {
            throw new IllegalArgumentException("Parameter applicationId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.get(resourceGroupName, accountName, applicationId, this.client.subscriptionId(), this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<ApplicationInner>>>(){

            public Observable<ServiceResponse<ApplicationInner>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ApplicationsInner.this.getDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<ApplicationInner> getDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<ApplicationInner>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public void update(String resourceGroupName, String accountName, String applicationId, ApplicationUpdateParameters parameters) {
        ((ServiceResponse)this.updateWithServiceResponseAsync(resourceGroupName, accountName, applicationId, parameters).toBlocking().single()).body();
    }

    public ServiceFuture<Void> updateAsync(String resourceGroupName, String accountName, String applicationId, ApplicationUpdateParameters parameters, ServiceCallback<Void> serviceCallback) {
        return ServiceFuture.fromResponse(this.updateWithServiceResponseAsync(resourceGroupName, accountName, applicationId, parameters), serviceCallback);
    }

    public Observable<Void> updateAsync(String resourceGroupName, String accountName, String applicationId, ApplicationUpdateParameters parameters) {
        return this.updateWithServiceResponseAsync(resourceGroupName, accountName, applicationId, parameters).map((Func1)new Func1<ServiceResponse<Void>, Void>(){

            public Void call(ServiceResponse<Void> response) {
                return (Void)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Void>> updateWithServiceResponseAsync(String resourceGroupName, String accountName, String applicationId, ApplicationUpdateParameters parameters) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (applicationId == null) {
            throw new IllegalArgumentException("Parameter applicationId is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (parameters == null) {
            throw new IllegalArgumentException("Parameter parameters is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Validator.validate((Object)parameters);
        return this.service.update(resourceGroupName, accountName, applicationId, this.client.subscriptionId(), parameters, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Void>>>(){

            public Observable<ServiceResponse<Void>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse clientResponse = ApplicationsInner.this.updateDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)clientResponse);
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<Void> updateDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(204, new TypeToken<Void>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ApplicationInner> list(String resourceGroupName, String accountName) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(resourceGroupName, accountName).toBlocking().single();
        return new PagedList<ApplicationInner>((Page)response.body()){

            public Page<ApplicationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ApplicationsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ApplicationInner>> listAsync(String resourceGroupName, String accountName, ListOperationCallback<ApplicationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(resourceGroupName, accountName), (Func1)new Func1<String, Observable<ServiceResponse<Page<ApplicationInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationInner>>> call(String nextPageLink) {
                return ApplicationsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ApplicationInner>> listAsync(String resourceGroupName, String accountName) {
        return this.listWithServiceResponseAsync(resourceGroupName, accountName).map((Func1)new Func1<ServiceResponse<Page<ApplicationInner>>, Page<ApplicationInner>>(){

            public Page<ApplicationInner> call(ServiceResponse<Page<ApplicationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationInner>>> listWithServiceResponseAsync(String resourceGroupName, String accountName) {
        return this.listSinglePageAsync(resourceGroupName, accountName).concatMap((Func1)new Func1<ServiceResponse<Page<ApplicationInner>>, Observable<ServiceResponse<Page<ApplicationInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationInner>>> call(ServiceResponse<Page<ApplicationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ApplicationsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationInner>>> listSinglePageAsync(String resourceGroupName, String accountName) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        Integer maxresults = null;
        return this.service.list(resourceGroupName, accountName, this.client.subscriptionId(), maxresults, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ApplicationInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ApplicationsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    public PagedList<ApplicationInner> list(String resourceGroupName, String accountName, Integer maxresults) {
        ServiceResponse response = (ServiceResponse)this.listSinglePageAsync(resourceGroupName, accountName, maxresults).toBlocking().single();
        return new PagedList<ApplicationInner>((Page)response.body()){

            public Page<ApplicationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ApplicationsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ApplicationInner>> listAsync(String resourceGroupName, String accountName, Integer maxresults, ListOperationCallback<ApplicationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listSinglePageAsync(resourceGroupName, accountName, maxresults), (Func1)new Func1<String, Observable<ServiceResponse<Page<ApplicationInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationInner>>> call(String nextPageLink) {
                return ApplicationsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ApplicationInner>> listAsync(String resourceGroupName, String accountName, Integer maxresults) {
        return this.listWithServiceResponseAsync(resourceGroupName, accountName, maxresults).map((Func1)new Func1<ServiceResponse<Page<ApplicationInner>>, Page<ApplicationInner>>(){

            public Page<ApplicationInner> call(ServiceResponse<Page<ApplicationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationInner>>> listWithServiceResponseAsync(String resourceGroupName, String accountName, Integer maxresults) {
        return this.listSinglePageAsync(resourceGroupName, accountName, maxresults).concatMap((Func1)new Func1<ServiceResponse<Page<ApplicationInner>>, Observable<ServiceResponse<Page<ApplicationInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationInner>>> call(ServiceResponse<Page<ApplicationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ApplicationsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationInner>>> listSinglePageAsync(String resourceGroupName, String accountName, Integer maxresults) {
        if (resourceGroupName == null) {
            throw new IllegalArgumentException("Parameter resourceGroupName is required and cannot be null.");
        }
        if (accountName == null) {
            throw new IllegalArgumentException("Parameter accountName is required and cannot be null.");
        }
        if (this.client.subscriptionId() == null) {
            throw new IllegalArgumentException("Parameter this.client.subscriptionId() is required and cannot be null.");
        }
        if (this.client.apiVersion() == null) {
            throw new IllegalArgumentException("Parameter this.client.apiVersion() is required and cannot be null.");
        }
        return this.service.list(resourceGroupName, accountName, this.client.subscriptionId(), maxresults, this.client.apiVersion(), this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ApplicationInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ApplicationsInner.this.listDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ApplicationInner>> listDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ApplicationInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    public PagedList<ApplicationInner> listNext(String nextPageLink) {
        ServiceResponse response = (ServiceResponse)this.listNextSinglePageAsync(nextPageLink).toBlocking().single();
        return new PagedList<ApplicationInner>((Page)response.body()){

            public Page<ApplicationInner> nextPage(String nextPageLink) {
                return (Page)((ServiceResponse)ApplicationsInner.this.listNextSinglePageAsync(nextPageLink).toBlocking().single()).body();
            }
        };
    }

    public ServiceFuture<List<ApplicationInner>> listNextAsync(String nextPageLink, ServiceFuture<List<ApplicationInner>> serviceFuture, ListOperationCallback<ApplicationInner> serviceCallback) {
        return AzureServiceFuture.fromPageResponse(this.listNextSinglePageAsync(nextPageLink), (Func1)new Func1<String, Observable<ServiceResponse<Page<ApplicationInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationInner>>> call(String nextPageLink) {
                return ApplicationsInner.this.listNextSinglePageAsync(nextPageLink);
            }
        }, serviceCallback);
    }

    public Observable<Page<ApplicationInner>> listNextAsync(String nextPageLink) {
        return this.listNextWithServiceResponseAsync(nextPageLink).map((Func1)new Func1<ServiceResponse<Page<ApplicationInner>>, Page<ApplicationInner>>(){

            public Page<ApplicationInner> call(ServiceResponse<Page<ApplicationInner>> response) {
                return (Page)response.body();
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationInner>>> listNextWithServiceResponseAsync(String nextPageLink) {
        return this.listNextSinglePageAsync(nextPageLink).concatMap((Func1)new Func1<ServiceResponse<Page<ApplicationInner>>, Observable<ServiceResponse<Page<ApplicationInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationInner>>> call(ServiceResponse<Page<ApplicationInner>> page) {
                String nextPageLink = ((Page)page.body()).nextPageLink();
                if (nextPageLink == null) {
                    return Observable.just(page);
                }
                return Observable.just(page).concatWith(ApplicationsInner.this.listNextWithServiceResponseAsync(nextPageLink));
            }
        });
    }

    public Observable<ServiceResponse<Page<ApplicationInner>>> listNextSinglePageAsync(String nextPageLink) {
        if (nextPageLink == null) {
            throw new IllegalArgumentException("Parameter nextPageLink is required and cannot be null.");
        }
        String nextUrl = String.format("%s", nextPageLink);
        return this.service.listNext(nextUrl, this.client.acceptLanguage(), this.client.userAgent()).flatMap((Func1)new Func1<Response<ResponseBody>, Observable<ServiceResponse<Page<ApplicationInner>>>>(){

            public Observable<ServiceResponse<Page<ApplicationInner>>> call(Response<ResponseBody> response) {
                try {
                    ServiceResponse result = ApplicationsInner.this.listNextDelegate((Response<ResponseBody>)response);
                    return Observable.just((Object)new ServiceResponse(result.body(), result.response()));
                }
                catch (Throwable t) {
                    return Observable.error((Throwable)t);
                }
            }
        });
    }

    private ServiceResponse<PageImpl<ApplicationInner>> listNextDelegate(Response<ResponseBody> response) throws CloudException, IOException, IllegalArgumentException {
        return this.client.restClient().responseBuilderFactory().newInstance(this.client.serializerAdapter()).register(200, new TypeToken<PageImpl<ApplicationInner>>(){}.getType()).registerError(CloudException.class).build(response);
    }

    static interface ApplicationsService {
        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.Applications create"})
        @PUT(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/applications/{applicationId}")
        public Observable<Response<ResponseBody>> create(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="applicationId") String var3, @Path(value="subscriptionId") String var4, @Body ApplicationCreateParameters var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.Applications delete"})
        @HTTP(path="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/applications/{applicationId}", method="DELETE", hasBody=true)
        public Observable<Response<ResponseBody>> delete(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="applicationId") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.Applications get"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/applications/{applicationId}")
        public Observable<Response<ResponseBody>> get(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="applicationId") String var3, @Path(value="subscriptionId") String var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.Applications update"})
        @PATCH(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/applications/{applicationId}")
        public Observable<Response<ResponseBody>> update(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="applicationId") String var3, @Path(value="subscriptionId") String var4, @Body ApplicationUpdateParameters var5, @Query(value="api-version") String var6, @Header(value="accept-language") String var7, @Header(value="User-Agent") String var8);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.Applications list"})
        @GET(value="subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Batch/batchAccounts/{accountName}/applications")
        public Observable<Response<ResponseBody>> list(@Path(value="resourceGroupName") String var1, @Path(value="accountName") String var2, @Path(value="subscriptionId") String var3, @Query(value="maxresults") Integer var4, @Query(value="api-version") String var5, @Header(value="accept-language") String var6, @Header(value="User-Agent") String var7);

        @Headers(value={"Content-Type: application/json; charset=utf-8", "x-ms-logging-context: com.microsoft.azure.management.batch.Applications listNext"})
        @GET
        public Observable<Response<ResponseBody>> listNext(@Url String var1, @Header(value="accept-language") String var2, @Header(value="User-Agent") String var3);
    }
}

