/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.store.raw.data;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.apache.derby.iapi.services.io.FileUtil;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.log.LogInstant;
import org.apache.derby.iapi.util.InterruptDetectedException;
import org.apache.derby.iapi.util.InterruptStatus;
import org.apache.derby.impl.store.raw.data.BaseContainerHandle;
import org.apache.derby.impl.store.raw.data.BaseDataFileFactory;
import org.apache.derby.impl.store.raw.data.BasePage;
import org.apache.derby.impl.store.raw.data.FileContainer;
import org.apache.derby.io.StorageFile;
import org.apache.derby.io.StorageRandomAccessFile;
import org.apache.derby.shared.common.error.StandardException;

class RAFContainer
extends FileContainer {
    protected StorageRandomAccessFile fileData;
    protected boolean needsSync;
    private int actionCode;
    private static final int GET_FILE_NAME_ACTION = 1;
    private static final int CREATE_CONTAINER_ACTION = 2;
    private static final int REMOVE_FILE_ACTION = 3;
    private static final int OPEN_CONTAINER_ACTION = 4;
    private static final int STUBBIFY_ACTION = 5;
    private static final int GET_RANDOM_ACCESS_FILE_ACTION = 7;
    private static final int REOPEN_CONTAINER_ACTION = 8;
    private ContainerKey actionIdentity;
    private boolean actionStub;
    private boolean actionErrorOK;
    private boolean actionTryAlternatePath;
    private StorageFile actionFile;
    private LogInstant actionInstant;
    private boolean inBackup = false;
    private boolean inRemove = false;
    private String fileName;

    RAFContainer(BaseDataFileFactory baseDataFileFactory) {
        super(baseDataFileFactory);
    }

    @Override
    public synchronized boolean isDirty() {
        return super.isDirty() || this.needsSync;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removeContainer(LogInstant logInstant, boolean bl) throws StandardException {
        RAFContainer rAFContainer;
        try {
            rAFContainer = this;
            synchronized (rAFContainer) {
                this.inRemove = true;
                while (this.inBackup) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        InterruptStatus.setInterrupted();
                    }
                }
            }
            this.pageCache.discard(this.identity);
            this.stubbify(logInstant);
        }
        finally {
            rAFContainer = this;
            synchronized (rAFContainer) {
                this.inRemove = false;
                this.notifyAll();
            }
        }
    }

    @Override
    void closeContainer() {
        if (this.fileData != null) {
            try {
                this.fileData.close();
            }
            catch (IOException iOException) {
            }
            finally {
                this.fileData = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void readPage(long l, byte[] byArray) throws IOException, StandardException {
        long l2 = l * (long)this.pageSize;
        RAFContainer rAFContainer = this;
        synchronized (rAFContainer) {
            this.fileData.seek(l2);
            this.fileData.readFully(byArray, 0, this.pageSize);
        }
        if (this.dataFactory.databaseEncrypted() && l != 0L) {
            this.decryptPage(byArray, this.pageSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void writePage(long l, byte[] byArray, boolean bl) throws IOException, StandardException {
        RAFContainer rAFContainer = this;
        synchronized (rAFContainer) {
            if (this.getCommittedDropState()) {
                return;
            }
            long l2 = l * (long)this.pageSize;
            byte[] byArray2 = null;
            if (this.dataFactory.databaseEncrypted() && l != 0L) {
                byArray2 = this.getEncryptionBuffer();
            }
            byte[] byArray3 = this.updatePageArray(l, byArray, byArray2, false);
            try {
                this.fileData.seek(l2);
                if (this.fileData.getFilePointer() != l2) {
                    this.padFile(this.fileData, l2);
                }
                this.dataFactory.writeInProgress();
                try {
                    this.fileData.write(byArray3, 0, this.pageSize);
                }
                finally {
                    this.dataFactory.writeFinished();
                }
            }
            catch (IOException iOException) {
                if (!this.padFile(this.fileData, l2)) {
                    throw iOException;
                }
                this.fileData.seek(l2);
                this.dataFactory.writeInProgress();
                try {
                    this.fileData.write(byArray3, 0, this.pageSize);
                }
                finally {
                    this.dataFactory.writeFinished();
                }
            }
            if (bl) {
                this.dataFactory.writeInProgress();
                try {
                    if (this.dataFactory.dataNotSyncedAtAllocation) return;
                    this.fileData.sync();
                }
                finally {
                    this.dataFactory.writeFinished();
                }
            } else {
                this.needsSync = true;
            }
            return;
        }
    }

    protected byte[] updatePageArray(long l, byte[] byArray, byte[] byArray2, boolean bl) throws StandardException, IOException {
        if (l == 0L) {
            this.writeHeader(this.getIdentity(), byArray);
            return byArray;
        }
        if (byArray2 != null && (this.dataFactory.databaseEncrypted() || bl)) {
            return this.encryptPage(byArray, this.pageSize, byArray2, bl);
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean padFile(StorageRandomAccessFile storageRandomAccessFile, long l) throws IOException, StandardException {
        long l2 = storageRandomAccessFile.length();
        if (l2 >= l) {
            return false;
        }
        byte[] byArray = new byte[this.pageSize];
        storageRandomAccessFile.seek(l2);
        while (l2 < l) {
            this.dataFactory.writeInProgress();
            try {
                long l3 = l - l2;
                if (l3 > (long)this.pageSize) {
                    l3 = this.pageSize;
                }
                storageRandomAccessFile.write(byArray, 0, (int)l3);
            }
            finally {
                this.dataFactory.writeFinished();
            }
            l2 += (long)this.pageSize;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clean(boolean bl) throws StandardException {
        boolean bl2 = false;
        boolean bl3 = false;
        int n = 120;
        while (!bl3) {
            bl3 = true;
            RAFContainer rAFContainer = this;
            synchronized (rAFContainer) {
                if (this.getCommittedDropState()) {
                    this.clearDirty();
                    return;
                }
                while (this.preDirty) {
                    bl2 = true;
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        InterruptStatus.setInterrupted();
                    }
                }
                if (bl2 && this.getCommittedDropState()) {
                    this.clearDirty();
                    return;
                }
                if (!bl && this.isDirty()) {
                    try {
                        this.writeRAFHeader(this.getIdentity(), this.fileData, false, true);
                        this.clearDirty();
                    }
                    catch (InterruptDetectedException interruptDetectedException) {
                        if (--n > 0) {
                            bl3 = false;
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException interruptedException) {
                                InterruptStatus.setInterrupted();
                            }
                            continue;
                        }
                        throw StandardException.newException((String)"XSDG9.D", (Throwable)((Object)interruptDetectedException), (Object[])new Object[0]);
                    }
                    catch (IOException iOException) {
                        throw this.dataFactory.markCorrupt(StandardException.newException((String)"XSDG3.D", (Throwable)iOException, (Object[])new Object[]{this.getIdentity() != null ? this.getIdentity().toString() : "unknown", "clean", this.fileName}));
                    }
                }
            }
        }
    }

    private void clearDirty() {
        this.isDirty = false;
        this.needsSync = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int preAllocate(long l, int n) {
        int n2 = this.doPreAllocatePages(l, n);
        if (n2 > 0) {
            RAFContainer rAFContainer = this;
            synchronized (rAFContainer) {
                boolean bl = false;
                try {
                    this.dataFactory.writeInProgress();
                    bl = true;
                    if (!this.dataFactory.dataNotSyncedAtAllocation) {
                        this.fileData.sync();
                    }
                }
                catch (IOException iOException) {
                    n2 = 0;
                }
                catch (StandardException standardException) {
                    n2 = 0;
                }
                finally {
                    if (bl) {
                        this.dataFactory.writeFinished();
                    }
                }
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void truncatePages(long l) throws StandardException {
        RAFContainer rAFContainer = this;
        synchronized (rAFContainer) {
            boolean bl = false;
            try {
                this.dataFactory.writeInProgress();
                bl = true;
                this.fileData.setLength((l + 1L) * (long)this.pageSize);
            }
            catch (IOException iOException) {
            }
            catch (StandardException standardException) {
            }
            finally {
                if (bl) {
                    this.dataFactory.writeFinished();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRAFHeader(Object object, StorageRandomAccessFile storageRandomAccessFile, boolean bl, boolean bl2) throws IOException, StandardException {
        byte[] byArray = bl ? new byte[this.pageSize] : this.getEmbryonicPage(storageRandomAccessFile, 0L);
        this.writeHeader(object, storageRandomAccessFile, bl, byArray);
        if (bl2) {
            this.dataFactory.writeInProgress();
            try {
                if (!this.dataFactory.dataNotSyncedAtCheckpoint) {
                    storageRandomAccessFile.sync();
                }
            }
            finally {
                this.dataFactory.writeFinished();
            }
        }
    }

    @Override
    protected void flushAll() throws StandardException {
        this.pageCache.clean(this.identity);
        this.clean(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized StorageFile getFileName(ContainerKey containerKey, boolean bl, boolean bl2, boolean bl3) throws StandardException {
        this.actionCode = 1;
        this.actionIdentity = containerKey;
        this.actionStub = bl;
        this.actionErrorOK = bl2;
        this.actionTryAlternatePath = bl3;
        try {
            StorageFile storageFile = (StorageFile)this.run();
            return storageFile;
        }
        finally {
            this.actionIdentity = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StorageFile privGetFileName(ContainerKey containerKey, boolean bl, boolean bl2, boolean bl3) throws StandardException {
        StorageFile storageFile;
        StorageFile storageFile2 = this.dataFactory.getContainerPath(containerKey, bl);
        if (!storageFile2.exists() && bl3) {
            storageFile2 = this.dataFactory.getAlternateContainerPath(containerKey, bl);
        }
        if (!storageFile2.exists() && !(storageFile = storageFile2.getParentDir()).exists()) {
            BaseDataFileFactory baseDataFileFactory = this.dataFactory;
            synchronized (baseDataFileFactory) {
                if (!storageFile.exists()) {
                    if (!storageFile.mkdirs()) {
                        if (bl2) {
                            return null;
                        }
                        throw StandardException.newException((String)"XSDF3.S", (Object[])new Object[]{storageFile});
                    }
                    try {
                        storageFile.limitAccessToOwner();
                    }
                    catch (IOException iOException) {
                        if (bl2) {
                            return null;
                        }
                        throw StandardException.newException((String)"XSDF3.S", (Throwable)iOException, (Object[])new Object[]{storageFile});
                    }
                }
            }
        }
        return storageFile2;
    }

    @Override
    synchronized void createContainer(ContainerKey containerKey) throws StandardException {
        this.actionCode = 2;
        this.actionIdentity = containerKey;
        try {
            this.run();
        }
        finally {
            this.actionIdentity = null;
        }
    }

    private void copyFile(StorageFile storageFile, File file) throws StandardException {
        boolean bl = FileUtil.copyFile(this.dataFactory.getStorageFactory(), storageFile, file);
        if (!bl) {
            throw StandardException.newException((String)"XSRS5.S", (Object[])new Object[]{storageFile, file});
        }
    }

    private void removeFile(File file) throws StandardException {
        boolean bl;
        boolean bl2 = bl = !file.exists() || file.delete();
        if (!bl) {
            throw StandardException.newException((String)"XBM0R.D", (Object[])new Object[]{file});
        }
    }

    synchronized boolean removeFile(StorageFile storageFile) throws StandardException {
        this.actionCode = 3;
        this.actionFile = storageFile;
        try {
            boolean bl = this.run() != null;
            return bl;
        }
        finally {
            this.actionFile = null;
        }
    }

    private boolean privRemoveFile(StorageFile storageFile) throws StandardException {
        this.closeContainer();
        this.dataFactory.writeInProgress();
        try {
            if (storageFile.exists()) {
                boolean bl = storageFile.delete();
                return bl;
            }
        }
        finally {
            this.dataFactory.writeFinished();
        }
        return true;
    }

    @Override
    synchronized boolean openContainer(ContainerKey containerKey) throws StandardException {
        this.actionCode = 4;
        this.actionIdentity = containerKey;
        try {
            boolean bl = this.run() != null;
            return bl;
        }
        catch (Exception exception) {
            this.closeContainer();
            throw exception;
        }
        finally {
            this.actionIdentity = null;
        }
    }

    protected synchronized void reopenContainer(ContainerKey containerKey) throws StandardException {
        this.actionCode = 8;
        this.actionIdentity = containerKey;
        try {
            this.run();
        }
        catch (Exception exception) {
            this.closeContainer();
            throw exception;
        }
        finally {
            this.actionIdentity = null;
        }
    }

    private synchronized void stubbify(LogInstant logInstant) throws StandardException {
        this.setDroppedState(true);
        this.setCommittedDropState(true);
        this.actionIdentity = (ContainerKey)this.getIdentity();
        this.actionInstant = logInstant;
        this.actionCode = 5;
        try {
            this.run();
        }
        finally {
            this.actionIdentity = null;
            this.actionInstant = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected void backupContainer(BaseContainerHandle var1_1, String var2_2) throws StandardException {
        var3_3 = false;
        var4_4 = null;
        var5_5 = null;
        var6_6 = false;
        var7_7 = null;
        while (!var3_3) {
            block43: {
                block44: {
                    var8_8 = this;
                    synchronized (var8_8) {
                        while (this.inRemove) {
                            try {
                                this.wait();
                            }
                            catch (InterruptedException var9_13) {
                                InterruptStatus.setInterrupted();
                            }
                        }
                        if (this.getCommittedDropState()) {
                            var6_6 = true;
                        }
                        this.inBackup = true;
                    }
                    if (!var6_6) break block44;
                    var8_8 = this.getFileName((ContainerKey)this.getIdentity(), true, false, true);
                    var4_4 = new File(var2_2, var8_8.getName());
                    this.copyFile((StorageFile)var8_8, var4_4);
                    ** GOTO lbl75
                }
                var8_9 = this.getLastPageNumber(var1_1);
                if (var8_9 != -1L) break block43;
                var10_14 = this;
                synchronized (var10_14) {
                    this.inBackup = false;
                    this.notifyAll();
                }
                if (var7_7 != null) {
                    var7_7.unlatch();
                    var7_7 = null;
                }
                if (!var3_3 && var4_4 != null) {
                    if (var5_5 != null) {
                        try {
                            var5_5.close();
                            var5_5 = null;
                        }
                        catch (IOException var10_16) {
                            throw StandardException.newException((String)"XSDFH.S", (Throwable)var10_16, (Object[])new Object[]{var4_4});
                        }
                    }
                    this.removeFile(var4_4);
                }
                return;
            }
            try {
                var10_14 = this.getFileName((ContainerKey)this.getIdentity(), false, false, true);
                var4_4 = new File(var2_2, var10_14.getName());
                var5_5 = this.getRandomAccessFile(var4_4);
                var11_17 = null;
                if (this.dataFactory.databaseEncrypted()) {
                    var11_17 = new byte[this.pageSize];
                }
                for (var12_19 = 0L; var12_19 <= var8_9; ++var12_19) {
                    var7_7 = this.getLatchedPage(var1_1, var12_19);
                    var14_20 = this.updatePageArray(var12_19, var7_7.getPageArray(), var11_17, false);
                    var5_5.write(var14_20, 0, this.pageSize);
                    var7_7.unlatch();
                    var7_7 = null;
                    var15_21 = this;
                    synchronized (var15_21) {
                        if (this.inRemove) {
                            break;
                        }
                        continue;
                    }
                }
lbl75:
                // 3 sources

                if (!var6_6) {
                    var5_5.getFD().sync();
                    var5_5.close();
                    var5_5 = null;
                }
                var3_3 = true;
                var8_8 = this;
            }
            catch (IOException var8_12) {
                try {
                    throw StandardException.newException((String)"XSDFH.S", (Throwable)var8_12, (Object[])new Object[]{var4_4});
                }
                catch (Throwable var18_24) {
                    var19_25 = this;
                    synchronized (var19_25) {
                        this.inBackup = false;
                        this.notifyAll();
                    }
                    if (var7_7 != null) {
                        var7_7.unlatch();
                        var7_7 = null;
                    }
                    if (!var3_3 && var4_4 != null) {
                        if (var5_5 != null) {
                            try {
                                var5_5.close();
                                var5_5 = null;
                            }
                            catch (IOException var19_26) {
                                throw StandardException.newException((String)"XSDFH.S", (Throwable)var19_26, (Object[])new Object[]{var4_4});
                            }
                        }
                        this.removeFile(var4_4);
                    }
                    throw var18_24;
                }
            }
            synchronized (var8_8) {
                this.inBackup = false;
                this.notifyAll();
            }
            if (var7_7 != null) {
                var7_7.unlatch();
                var7_7 = null;
            }
            if (var3_3 || var4_4 == null) continue;
            if (var5_5 != null) {
                try {
                    var5_5.close();
                    var5_5 = null;
                }
                catch (IOException var8_11) {
                    throw StandardException.newException((String)"XSDFH.S", (Throwable)var8_11, (Object[])new Object[]{var4_4});
                }
            }
            this.removeFile(var4_4);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void encryptOrDecryptContainer(BaseContainerHandle baseContainerHandle, String string, boolean bl) throws StandardException {
        BasePage basePage = null;
        StorageFile storageFile = this.dataFactory.getStorageFactory().newStorageFile(string);
        StorageRandomAccessFile storageRandomAccessFile = null;
        try {
            long l = this.getLastPageNumber(baseContainerHandle);
            storageRandomAccessFile = this.getRandomAccessFile(storageFile);
            byte[] byArray = null;
            if (bl) {
                byArray = new byte[this.pageSize];
            }
            for (long i = 0L; i <= l; ++i) {
                basePage = this.getLatchedPage(baseContainerHandle, i);
                byte[] byArray2 = this.updatePageArray(i, basePage.getPageArray(), byArray, true);
                storageRandomAccessFile.write(byArray2, 0, this.pageSize);
                basePage.unlatch();
                basePage = null;
            }
            storageRandomAccessFile.sync();
            storageRandomAccessFile.close();
            storageRandomAccessFile = null;
            if (basePage != null) {
                basePage.unlatch();
                basePage = null;
            }
            if (storageRandomAccessFile == null) return;
        }
        catch (IOException iOException) {
            try {
                throw StandardException.newException((String)"XSDG3.D", (Throwable)iOException, (Object[])new Object[]{this.getIdentity() != null ? this.getIdentity().toString() : "unknown", bl ? "encrypt" : "decrypt", string});
            }
            catch (Throwable throwable) {
                if (basePage != null) {
                    basePage.unlatch();
                    basePage = null;
                }
                if (storageRandomAccessFile == null) throw throwable;
                try {
                    storageRandomAccessFile.close();
                    throw throwable;
                }
                catch (IOException iOException2) {
                    storageRandomAccessFile = null;
                    throw StandardException.newException((String)"XSDG3.D", (Throwable)iOException2, (Object[])new Object[]{this.getIdentity() != null ? this.getIdentity().toString() : "unknown", bl ? "encrypt-close" : "decrypt-close", string});
                }
            }
        }
        try {
            storageRandomAccessFile.close();
            return;
        }
        catch (IOException iOException) {
            storageRandomAccessFile = null;
            throw StandardException.newException((String)"XSDG3.D", (Throwable)iOException, (Object[])new Object[]{this.getIdentity() != null ? this.getIdentity().toString() : "unknown", bl ? "encrypt-close" : "decrypt-close", string});
        }
    }

    private RandomAccessFile getRandomAccessFile(File file) throws IOException {
        boolean bl = file.exists();
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "rw");
        if (!bl) {
            FileUtil.limitAccessToOwner(file);
        }
        return randomAccessFile;
    }

    synchronized StorageRandomAccessFile getRandomAccessFile(StorageFile storageFile) throws StandardException {
        this.actionCode = 7;
        this.actionFile = storageFile;
        try {
            StorageRandomAccessFile storageRandomAccessFile = (StorageRandomAccessFile)this.run();
            return storageRandomAccessFile;
        }
        finally {
            this.actionFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object run() throws StandardException {
        switch (this.actionCode) {
            case 1: {
                return this.privGetFileName(this.actionIdentity, this.actionStub, this.actionErrorOK, this.actionTryAlternatePath);
            }
            case 2: {
                StorageFile storageFile = this.privGetFileName(this.actionIdentity, false, false, false);
                if (storageFile.exists()) {
                    throw StandardException.newException((String)"XSDF0.S", (Object[])new Object[]{storageFile});
                }
                try {
                    this.dataFactory.writeInProgress();
                    try {
                        this.fileData = storageFile.getRandomAccessFile("rw");
                        storageFile.limitAccessToOwner();
                    }
                    finally {
                        this.dataFactory.writeFinished();
                    }
                    this.canUpdate = true;
                    this.writeRAFHeader(this.actionIdentity, this.fileData, true, this.actionIdentity.getSegmentId() != -1L);
                }
                catch (IOException iOException) {
                    this.canUpdate = false;
                    boolean bl = this.privRemoveFile(storageFile);
                    if (!bl) {
                        throw StandardException.newException((String)"XSDF2.S", (Throwable)iOException, (Object[])new Object[]{storageFile, iOException.toString()});
                    }
                    throw StandardException.newException((String)"XSDF1.S", (Throwable)iOException, (Object[])new Object[]{storageFile});
                }
                return null;
            }
            case 3: {
                return this.privRemoveFile(this.actionFile) ? this : null;
            }
            case 4: {
                boolean bl = false;
                StorageFile storageFile = this.privGetFileName(this.actionIdentity, false, true, true);
                if (storageFile == null) {
                    return null;
                }
                if (!storageFile.exists()) {
                    storageFile = this.privGetFileName(this.actionIdentity, true, true, true);
                    if (!storageFile.exists()) {
                        return null;
                    }
                    bl = true;
                }
                this.canUpdate = false;
                if (!this.dataFactory.isReadOnly() && storageFile.canWrite()) {
                    this.canUpdate = true;
                }
                this.fileName = storageFile.toString();
                try {
                    this.fileData = storageFile.getRandomAccessFile(this.canUpdate ? "rw" : "r");
                    this.readHeader(this.getEmbryonicPage(this.fileData, 0L));
                }
                catch (IOException iOException) {
                    if (bl) {
                        throw this.dataFactory.markCorrupt(StandardException.newException((String)"XSDG3.D", (Throwable)iOException, (Object[])new Object[]{this.getIdentity() != null ? this.getIdentity().toString() : "unknown", "read", this.fileName}));
                    }
                    StorageFile storageFile2 = this.privGetFileName(this.actionIdentity, true, true, true);
                    if (storageFile2.exists()) {
                        try {
                            boolean bl2 = this.privRemoveFile(storageFile);
                            this.fileData = storageFile2.getRandomAccessFile(this.canUpdate ? "rw" : "r");
                            this.readHeader(this.getEmbryonicPage(this.fileData, 0L));
                        }
                        catch (IOException iOException2) {
                            throw this.dataFactory.markCorrupt(StandardException.newException((String)"XSDG3.D", (Throwable)iOException2, (Object[])new Object[]{this.getIdentity() != null ? this.getIdentity().toString() : "unknown", "delete-stub", this.fileName}));
                        }
                    }
                    throw this.dataFactory.markCorrupt(StandardException.newException((String)"XSDG3.D", (Throwable)iOException, (Object[])new Object[]{this.getIdentity() != null ? this.getIdentity().toString() : "unknown", "read", this.fileName}));
                }
                return this;
            }
            case 8: {
                StorageFile storageFile = this.privGetFileName(this.actionIdentity, false, true, true);
                RAFContainer rAFContainer = this;
                synchronized (rAFContainer) {
                    try {
                        this.fileData = storageFile.getRandomAccessFile(this.canUpdate ? "rw" : "r");
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        throw this.dataFactory.markCorrupt(StandardException.newException((String)"XSDG3.D", (Throwable)fileNotFoundException, (Object[])new Object[]{this.getIdentity() != null ? this.getIdentity().toString() : "unknown", "read", this.fileName}));
                    }
                }
                return this;
            }
            case 5: {
                StorageFile storageFile = this.privGetFileName(this.actionIdentity, false, false, true);
                StorageFile storageFile3 = this.privGetFileName(this.actionIdentity, true, false, false);
                StorageRandomAccessFile storageRandomAccessFile = null;
                try {
                    if (!storageFile3.exists()) {
                        storageRandomAccessFile = storageFile3.getRandomAccessFile("rw");
                        storageFile3.limitAccessToOwner();
                        this.writeRAFHeader(this.actionIdentity, storageRandomAccessFile, true, true);
                        storageRandomAccessFile.close();
                        storageRandomAccessFile = null;
                    }
                    this.dataFactory.flush(this.actionInstant);
                    this.privRemoveFile(storageFile);
                }
                catch (IOException iOException) {
                    try {
                        if (storageRandomAccessFile != null) {
                            storageRandomAccessFile.close();
                            storageFile3.delete();
                            storageRandomAccessFile = null;
                        }
                        if (this.fileData != null) {
                            this.fileData.close();
                            this.fileData = null;
                        }
                    }
                    catch (IOException iOException3) {
                        throw StandardException.newException((String)"XSDF4.S", (Throwable)iOException3, (Object[])new Object[]{storageFile, iOException.toString()});
                    }
                }
                this.dataFactory.stubFileToRemoveAfterCheckPoint(storageFile3, this.actionInstant, this.getIdentity());
                return null;
            }
            case 7: {
                try {
                    boolean bl = this.actionFile.exists();
                    StorageRandomAccessFile storageRandomAccessFile = this.actionFile.getRandomAccessFile("rw");
                    if (!bl) {
                        this.actionFile.limitAccessToOwner();
                    }
                    return storageRandomAccessFile;
                }
                catch (IOException iOException) {
                    throw StandardException.newException((String)"XSDF1.S", (Throwable)iOException, (Object[])new Object[]{this.actionFile.getPath()});
                }
            }
        }
        return null;
    }
}

