/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class CollectionUtils {
    private CollectionUtils() {
    }

    public static <T> T getOnlyElement(Collection<T> collection) {
        Objects.requireNonNull(collection);
        if (collection.isEmpty()) {
            throw new NoSuchElementException("Expected collection to have at least one element");
        }
        if (collection.size() > 1) {
            throw new IllegalArgumentException("Expected one element but was: <" + collection.size() + ">");
        }
        return collection.iterator().next();
    }

    public static <T> List<List<T>> partitions(List<T> source, int length) {
        if (length <= 0) {
            throw new IllegalArgumentException("length = " + length);
        }
        int size = source.size();
        if (size == 0) {
            return new ArrayList<List<T>>();
        }
        int fullChunks = (size - 1) / length;
        return IntStream.range(0, fullChunks + 1).mapToObj(n -> source.subList(n * length, n == fullChunks ? size : (n + 1) * length)).collect(Collectors.toList());
    }

    public static <T> List<T> nullSafeList(T[] array) {
        if (array == null) {
            return new ArrayList();
        }
        return Arrays.asList(array);
    }
}

