/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.message.internal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.qpid.server.bytebuffer.QpidByteBuffer;
import org.apache.qpid.server.message.AMQMessageHeader;
import org.apache.qpid.server.message.AbstractServerMessageImpl;
import org.apache.qpid.server.message.ServerMessage;
import org.apache.qpid.server.message.internal.InternalMessageHeader;
import org.apache.qpid.server.message.internal.InternalMessageMetaData;
import org.apache.qpid.server.store.MessageHandle;
import org.apache.qpid.server.store.MessageStore;
import org.apache.qpid.server.store.StoredMessage;
import org.apache.qpid.server.store.TransactionLogResource;
import org.apache.qpid.server.util.ConnectionScopedRuntimeException;

public class InternalMessage
extends AbstractServerMessageImpl<InternalMessage, InternalMessageMetaData> {
    private static final String NON_AMQP_MESSAGE = "Non-AMQP Message";
    private final Object _messageBody;
    private final InternalMessageHeader _header;
    private final String _destinationName;
    private String _initialRoutingAddress;

    public InternalMessage(StoredMessage<InternalMessageMetaData> handle, InternalMessageHeader header, Object messageBody, String destinationName) {
        super(handle, null);
        this._initialRoutingAddress = "";
        this._header = header;
        this._messageBody = messageBody;
        this._destinationName = destinationName;
    }

    InternalMessage(StoredMessage<InternalMessageMetaData> msg, String destinationName) {
        block15: {
            super(msg, null);
            this._initialRoutingAddress = "";
            this._header = msg.getMetaData().getHeader();
            long contentSize = this.getSize();
            if (contentSize > 0L) {
                try (QpidByteBuffer buf = msg.getContent(0, (int)contentSize);
                     ObjectInputStream is = new ObjectInputStream(buf.asInputStream());){
                    this._messageBody = is.readObject();
                    break block15;
                }
                catch (IOException e) {
                    throw new ConnectionScopedRuntimeException("Unexpected IO Exception in operation in memory", e);
                }
                catch (ClassNotFoundException e) {
                    throw new ConnectionScopedRuntimeException("Object message contained an object which could not be deserialized", e);
                }
            }
            this._messageBody = null;
        }
        this._destinationName = destinationName;
    }

    @Override
    public String getInitialRoutingAddress() {
        return this._initialRoutingAddress;
    }

    @Override
    public String getTo() {
        return this._destinationName;
    }

    @Override
    public InternalMessageHeader getMessageHeader() {
        return this._header;
    }

    @Override
    public long getExpiration() {
        return this._header.getExpiration();
    }

    @Override
    public String getMessageType() {
        return NON_AMQP_MESSAGE;
    }

    @Override
    public long getArrivalTime() {
        return this._header.getArrivalTime();
    }

    @Override
    public boolean isResourceAcceptable(TransactionLogResource resource) {
        return true;
    }

    public Object getMessageBody() {
        return this._messageBody;
    }

    public static InternalMessage createMessage(MessageStore store, AMQMessageHeader header, Serializable bodyObject, boolean persistent, String destinationName) {
        InternalMessage internalMessage;
        InternalMessageHeader internalHeader = header instanceof InternalMessageHeader ? (InternalMessageHeader)header : new InternalMessageHeader(header);
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        ObjectOutputStream os = new ObjectOutputStream(bytesOut);
        try {
            os.writeObject(bodyObject);
            os.close();
            byte[] bytes = bytesOut.toByteArray();
            InternalMessageMetaData metaData = InternalMessageMetaData.create(persistent, internalHeader, bytes.length);
            MessageHandle<InternalMessageMetaData> handle = store.addMessage(metaData);
            try (QpidByteBuffer wrap = QpidByteBuffer.wrap(bytes);){
                handle.addContent(wrap);
            }
            StoredMessage<InternalMessageMetaData> storedMessage = handle.allContentAdded();
            internalMessage = new InternalMessage(storedMessage, internalHeader, bodyObject, destinationName);
        }
        catch (Throwable throwable) {
            try {
                try {
                    os.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new ConnectionScopedRuntimeException("Unexpected IO Exception on operation in memory", e);
            }
        }
        os.close();
        return internalMessage;
    }

    public static InternalMessage createStringMessage(MessageStore store, AMQMessageHeader header, String messageBody) {
        return InternalMessage.createStringMessage(store, header, messageBody, false);
    }

    public static InternalMessage createStringMessage(MessageStore store, AMQMessageHeader header, String messageBody, boolean persistent) {
        return InternalMessage.createMessage(store, header, (Serializable)((Object)messageBody), persistent, null);
    }

    public static InternalMessage createMapMessage(MessageStore store, AMQMessageHeader header, Map<? extends Object, ? extends Object> messageBody) {
        return InternalMessage.createMessage(store, header, new LinkedHashMap<Object, Object>(messageBody), false, null);
    }

    public static InternalMessage createListMessage(MessageStore store, AMQMessageHeader header, List<? extends Object> messageBody) {
        return InternalMessage.createMessage(store, header, new ArrayList<Object>(messageBody), false, null);
    }

    public static InternalMessage createBytesMessage(MessageStore store, AMQMessageHeader header, byte[] messageBody) {
        return InternalMessage.createBytesMessage(store, header, messageBody, false);
    }

    public static InternalMessage createBytesMessage(MessageStore store, AMQMessageHeader header, byte[] messageBody, boolean persist) {
        return InternalMessage.createMessage(store, header, (Serializable)messageBody, persist, null);
    }

    public static InternalMessage convert(ServerMessage serverMessage, AMQMessageHeader header, Object messageBody) {
        long messageNumber = serverMessage.getMessageNumber();
        boolean persistent = serverMessage.isPersistent();
        String destinationName = serverMessage.getTo();
        InternalMessageHeader convertedHeader = new InternalMessageHeader(header, serverMessage.getArrivalTime());
        StoredMessage<InternalMessageMetaData> handle = InternalMessage.createReadOnlyHandle(messageNumber, persistent, convertedHeader, messageBody);
        InternalMessage internalMessage = new InternalMessage(handle, convertedHeader, messageBody, destinationName);
        internalMessage.setInitialRoutingAddress(serverMessage.getInitialRoutingAddress());
        return internalMessage;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static StoredMessage<InternalMessageMetaData> createReadOnlyHandle(final long messageNumber, boolean persistent, InternalMessageHeader header, Object messageBody) {
        try (ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();){
            StoredMessage<InternalMessageMetaData> storedMessage;
            try (ObjectOutputStream os = new ObjectOutputStream(bytesOut);){
                os.writeObject(messageBody);
                final byte[] bytes = bytesOut.toByteArray();
                final InternalMessageMetaData metaData = InternalMessageMetaData.create(persistent, header, bytes.length);
                final int metadataSize = metaData.getStorableSize();
                storedMessage = new StoredMessage<InternalMessageMetaData>(){

                    @Override
                    public InternalMessageMetaData getMetaData() {
                        return metaData;
                    }

                    @Override
                    public long getMessageNumber() {
                        return messageNumber;
                    }

                    @Override
                    public QpidByteBuffer getContent(int offset, int length) {
                        return QpidByteBuffer.wrap(bytes, offset, length);
                    }

                    @Override
                    public int getContentSize() {
                        return bytes.length;
                    }

                    @Override
                    public int getMetadataSize() {
                        return metadataSize;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public boolean isInContentInMemory() {
                        return true;
                    }

                    @Override
                    public long getInMemorySize() {
                        return this.getContentSize() + this.getMetadataSize();
                    }

                    @Override
                    public boolean flowToDisk() {
                        return false;
                    }

                    @Override
                    public void reallocate() {
                    }
                };
            }
            return storedMessage;
        }
        catch (IOException e) {
            throw new ConnectionScopedRuntimeException("Unexpected IO Exception on operation in memory", e);
        }
    }

    public void setInitialRoutingAddress(String initialRoutingAddress) {
        this._initialRoutingAddress = initialRoutingAddress == null ? "" : initialRoutingAddress;
    }
}

