/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.management.plugin.controller.v6_1;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.qpid.server.management.plugin.ManagementController;
import org.apache.qpid.server.management.plugin.ManagementException;
import org.apache.qpid.server.management.plugin.controller.AbstractLegacyConfiguredObjectController;
import org.apache.qpid.server.management.plugin.controller.ConverterHelper;
import org.apache.qpid.server.management.plugin.controller.LegacyConfiguredObject;
import org.apache.qpid.server.model.ConfiguredObject;

public class LegacyManagementController
extends AbstractLegacyConfiguredObjectController {
    private static final String DEPTH_PARAM = "depth";
    private static final String OVERSIZE_PARAM = "oversize";
    private static final String ACTUALS_PARAM = "actuals";
    private static final String INCLUDE_SYS_CONTEXT_PARAM = "includeSysContext";
    private static final String INHERITED_ACTUALS_PARAM = "inheritedActuals";
    private static final String EXCLUDE_INHERITED_CONTEXT_PARAM = "excludeInheritedContext";
    private static final int DEFAULT_DEPTH = 1;
    private static final int DEFAULT_OVERSIZE = 120;

    LegacyManagementController(ManagementController nextVersionManagementController) {
        super("6.1", nextVersionManagementController);
    }

    @Override
    public Object get(ConfiguredObject<?> root, String category, List<String> path, Map<String, List<String>> parameters) throws ManagementException {
        Object result = super.get(root, category, path, this.convertQueryParameters(parameters));
        if (result instanceof LegacyConfiguredObject) {
            return Collections.singletonList(result);
        }
        return result;
    }

    @Override
    public Map<String, List<String>> convertQueryParameters(Map<String, List<String>> requestParameters) {
        Map<String, List<String>> params = requestParameters.entrySet().stream().filter(e -> !INCLUDE_SYS_CONTEXT_PARAM.equals(e.getKey()) && !INHERITED_ACTUALS_PARAM.equals(e.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>(params);
        boolean excludeInheritedContext = this.isInheritedContextExcluded(params);
        parameters.put(EXCLUDE_INHERITED_CONTEXT_PARAM, List.of(String.valueOf(excludeInheritedContext)));
        if (!parameters.containsKey(DEPTH_PARAM)) {
            parameters.put(DEPTH_PARAM, List.of("1"));
        }
        return parameters;
    }

    @Override
    public Object formatConfiguredObject(Object content, Map<String, List<String>> parameters, boolean isSecureOrAllowedOnInsecureChannel) {
        int depth = ConverterHelper.getIntParameterFromRequest(parameters, DEPTH_PARAM, 1);
        int oversizeThreshold = ConverterHelper.getIntParameterFromRequest(parameters, OVERSIZE_PARAM, 120);
        boolean actuals = Boolean.parseBoolean(ConverterHelper.getParameter(ACTUALS_PARAM, parameters));
        boolean excludeInheritedContext = this.isInheritedContextExcluded(parameters);
        if (content instanceof LegacyConfiguredObject) {
            LegacyConfiguredObject legacyConfiguredObjectObject = (LegacyConfiguredObject)content;
            return this.convertManageableToMap(legacyConfiguredObjectObject, depth, actuals, oversizeThreshold, excludeInheritedContext);
        }
        if (content instanceof Collection) {
            return ((Collection)content).stream().filter(o -> o instanceof LegacyConfiguredObject).map(LegacyConfiguredObject.class::cast).map(o -> this.convertManageableToMap((LegacyConfiguredObject)o, depth, actuals, oversizeThreshold, excludeInheritedContext)).collect(Collectors.toSet());
        }
        return content;
    }

    private Map<String, Object> convertManageableToMap(LegacyConfiguredObject legacyConfiguredObjectObject, int depth, boolean actuals, int oversizeThreshold, boolean excludeInheritedContext) {
        return this.convertObject(legacyConfiguredObjectObject, depth, actuals, oversizeThreshold, true, excludeInheritedContext);
    }

    private boolean isInheritedContextExcluded(Map<String, List<String>> params) {
        boolean excludeInheritedContext;
        boolean actuals = Boolean.parseBoolean(ConverterHelper.getParameter(ACTUALS_PARAM, params));
        String includeSystemContextParameter = ConverterHelper.getParameter(INCLUDE_SYS_CONTEXT_PARAM, params);
        String inheritedActualsParameter = ConverterHelper.getParameter(INHERITED_ACTUALS_PARAM, params);
        String excludeInheritedContextParameter = ConverterHelper.getParameter(EXCLUDE_INHERITED_CONTEXT_PARAM, params);
        if (excludeInheritedContextParameter == null) {
            excludeInheritedContext = inheritedActualsParameter == null && includeSystemContextParameter == null ? actuals : (inheritedActualsParameter != null && includeSystemContextParameter != null ? (actuals ? !Boolean.parseBoolean(inheritedActualsParameter) : !Boolean.parseBoolean(includeSystemContextParameter)) : (inheritedActualsParameter != null ? actuals && !Boolean.parseBoolean(inheritedActualsParameter) : actuals || !Boolean.parseBoolean(includeSystemContextParameter)));
        } else {
            if (inheritedActualsParameter != null || includeSystemContextParameter != null) {
                throw ManagementException.createUnprocessableManagementException(String.format("Parameter '%s' cannot be specified together with '%s' or '%s'", EXCLUDE_INHERITED_CONTEXT_PARAM, INHERITED_ACTUALS_PARAM, INCLUDE_SYS_CONTEXT_PARAM));
            }
            excludeInheritedContext = Boolean.parseBoolean(excludeInheritedContextParameter);
        }
        return excludeInheritedContext;
    }
}

