/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.grpc;

import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.exporter.internal.ExporterMetrics;
import io.opentelemetry.exporter.internal.FailedExportException;
import io.opentelemetry.exporter.internal.grpc.GrpcExporterUtil;
import io.opentelemetry.exporter.internal.grpc.GrpcResponse;
import io.opentelemetry.exporter.internal.grpc.GrpcSender;
import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.internal.ThrottlingLogger;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class GrpcExporter<T extends Marshaler> {
    private static final Logger internalLogger = Logger.getLogger(GrpcExporter.class.getName());
    private final ThrottlingLogger logger = new ThrottlingLogger(internalLogger);
    private final AtomicBoolean loggedUnimplemented = new AtomicBoolean();
    private final AtomicBoolean isShutdown = new AtomicBoolean();
    private final String type;
    private final GrpcSender<T> grpcSender;
    private final ExporterMetrics exporterMetrics;

    public GrpcExporter(String exporterName, String type, GrpcSender<T> grpcSender, Supplier<MeterProvider> meterProviderSupplier) {
        this.type = type;
        this.grpcSender = grpcSender;
        this.exporterMetrics = ExporterMetrics.createGrpc(exporterName, type, meterProviderSupplier);
    }

    public CompletableResultCode export(T exportRequest, int numItems) {
        if (this.isShutdown.get()) {
            return CompletableResultCode.ofFailure();
        }
        this.exporterMetrics.addSeen(numItems);
        CompletableResultCode result = new CompletableResultCode();
        this.grpcSender.send(exportRequest, grpcResponse -> this.onResponse(result, numItems, (GrpcResponse)grpcResponse), throwable -> this.onError(result, numItems, (Throwable)throwable));
        return result;
    }

    private void onResponse(CompletableResultCode result, int numItems, GrpcResponse grpcResponse) {
        int statusCode = grpcResponse.grpcStatusValue();
        if (statusCode == 0) {
            this.exporterMetrics.addSuccess(numItems);
            result.succeed();
            return;
        }
        this.exporterMetrics.addFailed(numItems);
        switch (statusCode) {
            case 12: {
                if (!this.loggedUnimplemented.compareAndSet(false, true)) break;
                GrpcExporterUtil.logUnimplemented(internalLogger, this.type, grpcResponse.grpcStatusDescription());
                break;
            }
            case 14: {
                this.logger.log(Level.SEVERE, "Failed to export " + this.type + "s. Server is UNAVAILABLE. Make sure your collector is running and reachable from this network. Full error message:" + grpcResponse.grpcStatusDescription());
                break;
            }
            default: {
                this.logger.log(Level.WARNING, "Failed to export " + this.type + "s. Server responded with gRPC status code " + statusCode + ". Error message: " + grpcResponse.grpcStatusDescription());
            }
        }
        result.failExceptionally((Throwable)FailedExportException.grpcFailedWithResponse(grpcResponse));
    }

    private void onError(CompletableResultCode result, int numItems, Throwable e) {
        this.exporterMetrics.addFailed(numItems);
        this.logger.log(Level.SEVERE, "Failed to export " + this.type + "s. The request could not be executed. Error message: " + e.getMessage(), e);
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.log(Level.FINEST, "Failed to export " + this.type + "s. Details follow: " + e);
        }
        result.failExceptionally((Throwable)FailedExportException.grpcFailedExceptionally(e));
    }

    public CompletableResultCode shutdown() {
        if (!this.isShutdown.compareAndSet(false, true)) {
            this.logger.log(Level.INFO, "Calling shutdown() multiple times.");
            return CompletableResultCode.ofSuccess();
        }
        return this.grpcSender.shutdown();
    }
}

