/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pulsar.websocket.service;

import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import lombok.Generated;
import org.apache.pulsar.broker.authorization.PulsarAuthorizationProvider;
import org.apache.pulsar.common.configuration.FieldContext;
import org.apache.pulsar.common.configuration.PulsarConfiguration;

public class WebSocketProxyConfiguration
implements PulsarConfiguration {
    @FieldContext(required=true, doc="Name of the cluster to which this broker belongs to")
    private String clusterName;
    @FieldContext(doc="The HTTPS REST service URL to connect to broker")
    private String serviceUrl;
    @FieldContext(doc="The HTTPS REST service TLS URL")
    private String serviceUrlTls;
    @FieldContext(doc="The broker binary service URL (for produce and consume operations)")
    private String brokerServiceUrl;
    @FieldContext(doc="The secured broker binary service URL (for produce and consume operations)")
    private String brokerServiceUrlTls;
    @FieldContext(doc="Path for the file used to determine the rotation status for the broker when responding to service discovery health checks")
    private String statusFilePath;
    @Deprecated
    @FieldContext(doc="Configuration Store connection string", deprecated=true)
    private String globalZookeeperServers;
    @Deprecated
    @FieldContext(deprecated=true, doc="Configuration store connection string (as a comma-separated list). Deprecated in favor of `configurationMetadataStoreUrl`")
    private String configurationStoreServers;
    @FieldContext(doc="Connection string of configuration metadata store servers")
    private String configurationMetadataStoreUrl;
    @FieldContext(doc="Metadata store session timeout in milliseconds.")
    private long metadataStoreSessionTimeoutMillis = 30000L;
    @FieldContext(doc="Metadata store cache expiry time in seconds.")
    private int metadataStoreCacheExpirySeconds = 300;
    @FieldContext(deprecated=true, doc="ZooKeeper session timeout in milliseconds. @deprecated - Use metadataStoreSessionTimeoutMillis instead.")
    private long zooKeeperSessionTimeoutMillis = -1L;
    @FieldContext(deprecated=true, doc="ZooKeeper cache expiry time in seconds. @deprecated - Use metadataStoreCacheExpirySeconds instead.")
    private int zooKeeperCacheExpirySeconds = -1;
    @FieldContext(doc="Port to use to server HTTP request")
    private Optional<Integer> webServicePort = Optional.of(8080);
    @FieldContext(doc="Port to use to server HTTPS request")
    private Optional<Integer> webServicePortTls = Optional.empty();
    @FieldContext(doc="Hostname or IP address the service binds on, default is 0.0.0.0.")
    private String bindAddress = "0.0.0.0";
    @FieldContext(doc="Enable or disable the use of HA proxy protocol for resolving the client IP for http/https requests. Default is false.")
    private boolean webServiceHaProxyProtocolEnabled = false;
    @FieldContext(doc="Trust X-Forwarded-For header for resolving the client IP for http/https requests.\nDefault is false.")
    private boolean webServiceTrustXForwardedFor = false;
    @FieldContext(doc="Add detailed client/remote and server/local addresses and ports to http/https request logging.\nDefaults to true when either webServiceHaProxyProtocolEnabled or webServiceTrustXForwardedFor is enabled.")
    private Boolean webServiceLogDetailedAddresses;
    @FieldContext(doc="Maximum size of a text message during parsing in WebSocket proxy")
    private int webSocketMaxTextFrameSize = 0x100000;
    @FieldContext(doc="Enable authentication")
    private boolean authenticationEnabled;
    @FieldContext(doc="Authentication provider name list, which is a list of class names")
    private Set<String> authenticationProviders = new TreeSet<String>();
    @FieldContext(doc="Enforce authorization")
    private boolean authorizationEnabled;
    @FieldContext(doc="Authorization provider fully qualified class name")
    private String authorizationProvider = PulsarAuthorizationProvider.class.getName();
    @FieldContext(doc="Role names that are treated as \"super-user\", which means they can do all admin operations and publish to or consume from all topics")
    private Set<String> superUserRoles = new TreeSet<String>();
    @FieldContext(doc="Allow wildcard matching in authorization (wildcard matching only applicable if wildcard-char: presents at first or last position. For example: *.pulsar.service,pulsar.service.*)")
    private boolean authorizationAllowWildcardsMatching = false;
    @FieldContext(doc="Proxy authentication settings used to connect to brokers")
    private String brokerClientAuthenticationPlugin;
    @FieldContext(doc="Proxy authentication parameters used to connect to brokers")
    private String brokerClientAuthenticationParameters;
    @FieldContext(doc="Path for the trusted TLS certificate file for outgoing connection to a server (broker)")
    private String brokerClientTrustCertsFilePath = "";
    @FieldContext(doc="Enable TLS hostname verification when connecting to broker")
    private boolean tlsHostnameVerificationEnabled = false;
    @FieldContext(doc="Number of IO threads in Pulsar client used in WebSocket proxy")
    private int webSocketNumIoThreads = Runtime.getRuntime().availableProcessors();
    @FieldContext(doc="Number of threads to used in HTTP server")
    private int numHttpServerThreads = Math.max(6, Runtime.getRuntime().availableProcessors());
    @FieldContext(doc="Number of threads used by Websocket service")
    private int webSocketNumServiceThreads = 20;
    @FieldContext(doc="Max concurrent web requests")
    private int maxConcurrentHttpRequests = 1024;
    @FieldContext(doc="Capacity for thread pool queue in the HTTP server Default is set to 8192.")
    private int httpServerThreadPoolQueueSize = 8192;
    @FieldContext(doc="Capacity for accept queue in the HTTP server Default is set to 8192.")
    private int httpServerAcceptQueueSize = 8192;
    @FieldContext(doc="Maximum number of inbound http connections. (0 to disable limiting)")
    private int maxHttpServerConnections = 2048;
    @FieldContext(doc="Number of connections per broker in Pulsar client used in WebSocket proxy")
    private int webSocketConnectionsPerBroker = Runtime.getRuntime().availableProcessors();
    @FieldContext(doc="Memory limit in MBs for direct memory in Pulsar Client used in WebSocket proxy")
    private int webSocketPulsarClientMemoryLimitInMB = 0;
    @FieldContext(doc="Timeout of idling WebSocket session (in milliseconds)")
    private int webSocketSessionIdleTimeoutMillis = 300000;
    @FieldContext(doc="Interval of time to sending the ping to keep alive. This value greater than 0 means enabled")
    private int webSocketPingDurationSeconds = -1;
    @FieldContext(doc="When this parameter is not empty, unauthenticated users perform as anonymousUserRole")
    private String anonymousUserRole = null;
    @Deprecated
    private boolean tlsEnabled = false;
    @FieldContext(doc="Enable TLS of broker client")
    private boolean brokerClientTlsEnabled = false;
    @FieldContext(doc="Path for the TLS certificate file")
    private String tlsCertificateFilePath;
    @FieldContext(doc="Path for the TLS private key file")
    private String tlsKeyFilePath;
    @FieldContext(doc="Path for the trusted TLS certificate file")
    private String tlsTrustCertsFilePath = "";
    @FieldContext(doc="Accept untrusted TLS certificate from client and broker")
    private boolean tlsAllowInsecureConnection = false;
    @FieldContext(doc="Specify whether client certificates are required for TLS rejecting the connection if the client certificate is not trusted")
    private boolean tlsRequireTrustedClientCertOnConnect = false;
    @FieldContext(doc="TLS cert refresh duration (in seconds). 0 means checking every new connection.")
    private long tlsCertRefreshCheckDurationSec = 300L;
    @FieldContext(doc="Enable TLS with KeyStore type configuration for WebSocket")
    private boolean tlsEnabledWithKeyStore = false;
    @FieldContext(doc="Specify the TLS provider for the WebSocket service: SunJSSE, Conscrypt and etc.")
    private String tlsProvider = "Conscrypt";
    @FieldContext(doc="TLS KeyStore type configuration in WebSocket: JKS, PKCS12")
    private String tlsKeyStoreType = "JKS";
    @FieldContext(doc="TLS KeyStore path in WebSocket")
    private String tlsKeyStore = null;
    @FieldContext(doc="TLS KeyStore password for WebSocket")
    private String tlsKeyStorePassword = null;
    @FieldContext(doc="TLS TrustStore type configuration in WebSocket: JKS, PKCS12")
    private String tlsTrustStoreType = "JKS";
    @FieldContext(doc="TLS TrustStore path in WebSocket")
    private String tlsTrustStore = null;
    @FieldContext(doc="TLS TrustStore password for WebSocket, null means empty password.")
    private String tlsTrustStorePassword = null;
    @FieldContext(doc="Specify the tls protocols the proxy's web service will use to negotiate during TLS Handshake.\n\nExample:- [TLSv1.3, TLSv1.2]")
    private Set<String> webServiceTlsProtocols = new TreeSet<String>();
    @FieldContext(doc="Specify the tls cipher the proxy's web service will use to negotiate during TLS Handshake.\n\nExample:- [TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256]")
    private Set<String> webServiceTlsCiphers = new TreeSet<String>();
    @FieldContext(doc="CryptoKeyReader factory classname to support encryption at websocket.")
    private String cryptoKeyReaderFactoryClassName;
    @FieldContext(doc="Key-value properties. Types are all String")
    private Properties properties = new Properties();

    public long getMetadataStoreSessionTimeoutMillis() {
        return this.zooKeeperSessionTimeoutMillis > 0L ? this.zooKeeperSessionTimeoutMillis : this.metadataStoreSessionTimeoutMillis;
    }

    public int getMetadataStoreCacheExpirySeconds() {
        return this.zooKeeperCacheExpirySeconds > 0 ? this.zooKeeperCacheExpirySeconds : this.metadataStoreCacheExpirySeconds;
    }

    @Generated
    public String getClusterName() {
        return this.clusterName;
    }

    @Generated
    public String getServiceUrl() {
        return this.serviceUrl;
    }

    @Generated
    public String getServiceUrlTls() {
        return this.serviceUrlTls;
    }

    @Generated
    public String getBrokerServiceUrl() {
        return this.brokerServiceUrl;
    }

    @Generated
    public String getBrokerServiceUrlTls() {
        return this.brokerServiceUrlTls;
    }

    @Generated
    public String getStatusFilePath() {
        return this.statusFilePath;
    }

    @Deprecated
    @Generated
    public String getGlobalZookeeperServers() {
        return this.globalZookeeperServers;
    }

    @Deprecated
    @Generated
    public String getConfigurationStoreServers() {
        return this.configurationStoreServers;
    }

    @Generated
    public String getConfigurationMetadataStoreUrl() {
        return this.configurationMetadataStoreUrl;
    }

    @Generated
    public long getZooKeeperSessionTimeoutMillis() {
        return this.zooKeeperSessionTimeoutMillis;
    }

    @Generated
    public int getZooKeeperCacheExpirySeconds() {
        return this.zooKeeperCacheExpirySeconds;
    }

    @Generated
    public Optional<Integer> getWebServicePort() {
        return this.webServicePort;
    }

    @Generated
    public Optional<Integer> getWebServicePortTls() {
        return this.webServicePortTls;
    }

    @Generated
    public String getBindAddress() {
        return this.bindAddress;
    }

    @Generated
    public boolean isWebServiceHaProxyProtocolEnabled() {
        return this.webServiceHaProxyProtocolEnabled;
    }

    @Generated
    public boolean isWebServiceTrustXForwardedFor() {
        return this.webServiceTrustXForwardedFor;
    }

    @Generated
    public Boolean getWebServiceLogDetailedAddresses() {
        return this.webServiceLogDetailedAddresses;
    }

    @Generated
    public int getWebSocketMaxTextFrameSize() {
        return this.webSocketMaxTextFrameSize;
    }

    @Generated
    public boolean isAuthenticationEnabled() {
        return this.authenticationEnabled;
    }

    @Generated
    public Set<String> getAuthenticationProviders() {
        return this.authenticationProviders;
    }

    @Generated
    public boolean isAuthorizationEnabled() {
        return this.authorizationEnabled;
    }

    @Generated
    public String getAuthorizationProvider() {
        return this.authorizationProvider;
    }

    @Generated
    public Set<String> getSuperUserRoles() {
        return this.superUserRoles;
    }

    @Generated
    public boolean isAuthorizationAllowWildcardsMatching() {
        return this.authorizationAllowWildcardsMatching;
    }

    @Generated
    public String getBrokerClientAuthenticationPlugin() {
        return this.brokerClientAuthenticationPlugin;
    }

    @Generated
    public String getBrokerClientAuthenticationParameters() {
        return this.brokerClientAuthenticationParameters;
    }

    @Generated
    public String getBrokerClientTrustCertsFilePath() {
        return this.brokerClientTrustCertsFilePath;
    }

    @Generated
    public boolean isTlsHostnameVerificationEnabled() {
        return this.tlsHostnameVerificationEnabled;
    }

    @Generated
    public int getWebSocketNumIoThreads() {
        return this.webSocketNumIoThreads;
    }

    @Generated
    public int getNumHttpServerThreads() {
        return this.numHttpServerThreads;
    }

    @Generated
    public int getWebSocketNumServiceThreads() {
        return this.webSocketNumServiceThreads;
    }

    @Generated
    public int getMaxConcurrentHttpRequests() {
        return this.maxConcurrentHttpRequests;
    }

    @Generated
    public int getHttpServerThreadPoolQueueSize() {
        return this.httpServerThreadPoolQueueSize;
    }

    @Generated
    public int getHttpServerAcceptQueueSize() {
        return this.httpServerAcceptQueueSize;
    }

    @Generated
    public int getMaxHttpServerConnections() {
        return this.maxHttpServerConnections;
    }

    @Generated
    public int getWebSocketConnectionsPerBroker() {
        return this.webSocketConnectionsPerBroker;
    }

    @Generated
    public int getWebSocketPulsarClientMemoryLimitInMB() {
        return this.webSocketPulsarClientMemoryLimitInMB;
    }

    @Generated
    public int getWebSocketSessionIdleTimeoutMillis() {
        return this.webSocketSessionIdleTimeoutMillis;
    }

    @Generated
    public int getWebSocketPingDurationSeconds() {
        return this.webSocketPingDurationSeconds;
    }

    @Generated
    public String getAnonymousUserRole() {
        return this.anonymousUserRole;
    }

    @Deprecated
    @Generated
    public boolean isTlsEnabled() {
        return this.tlsEnabled;
    }

    @Generated
    public boolean isBrokerClientTlsEnabled() {
        return this.brokerClientTlsEnabled;
    }

    @Generated
    public String getTlsCertificateFilePath() {
        return this.tlsCertificateFilePath;
    }

    @Generated
    public String getTlsKeyFilePath() {
        return this.tlsKeyFilePath;
    }

    @Generated
    public String getTlsTrustCertsFilePath() {
        return this.tlsTrustCertsFilePath;
    }

    @Generated
    public boolean isTlsAllowInsecureConnection() {
        return this.tlsAllowInsecureConnection;
    }

    @Generated
    public boolean isTlsRequireTrustedClientCertOnConnect() {
        return this.tlsRequireTrustedClientCertOnConnect;
    }

    @Generated
    public long getTlsCertRefreshCheckDurationSec() {
        return this.tlsCertRefreshCheckDurationSec;
    }

    @Generated
    public boolean isTlsEnabledWithKeyStore() {
        return this.tlsEnabledWithKeyStore;
    }

    @Generated
    public String getTlsProvider() {
        return this.tlsProvider;
    }

    @Generated
    public String getTlsKeyStoreType() {
        return this.tlsKeyStoreType;
    }

    @Generated
    public String getTlsKeyStore() {
        return this.tlsKeyStore;
    }

    @Generated
    public String getTlsKeyStorePassword() {
        return this.tlsKeyStorePassword;
    }

    @Generated
    public String getTlsTrustStoreType() {
        return this.tlsTrustStoreType;
    }

    @Generated
    public String getTlsTrustStore() {
        return this.tlsTrustStore;
    }

    @Generated
    public String getTlsTrustStorePassword() {
        return this.tlsTrustStorePassword;
    }

    @Generated
    public Set<String> getWebServiceTlsProtocols() {
        return this.webServiceTlsProtocols;
    }

    @Generated
    public Set<String> getWebServiceTlsCiphers() {
        return this.webServiceTlsCiphers;
    }

    @Generated
    public String getCryptoKeyReaderFactoryClassName() {
        return this.cryptoKeyReaderFactoryClassName;
    }

    @Generated
    public Properties getProperties() {
        return this.properties;
    }

    @Generated
    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    @Generated
    public void setServiceUrl(String serviceUrl) {
        this.serviceUrl = serviceUrl;
    }

    @Generated
    public void setServiceUrlTls(String serviceUrlTls) {
        this.serviceUrlTls = serviceUrlTls;
    }

    @Generated
    public void setBrokerServiceUrl(String brokerServiceUrl) {
        this.brokerServiceUrl = brokerServiceUrl;
    }

    @Generated
    public void setBrokerServiceUrlTls(String brokerServiceUrlTls) {
        this.brokerServiceUrlTls = brokerServiceUrlTls;
    }

    @Generated
    public void setStatusFilePath(String statusFilePath) {
        this.statusFilePath = statusFilePath;
    }

    @Deprecated
    @Generated
    public void setGlobalZookeeperServers(String globalZookeeperServers) {
        this.globalZookeeperServers = globalZookeeperServers;
    }

    @Deprecated
    @Generated
    public void setConfigurationStoreServers(String configurationStoreServers) {
        this.configurationStoreServers = configurationStoreServers;
    }

    @Generated
    public void setConfigurationMetadataStoreUrl(String configurationMetadataStoreUrl) {
        this.configurationMetadataStoreUrl = configurationMetadataStoreUrl;
    }

    @Generated
    public void setMetadataStoreSessionTimeoutMillis(long metadataStoreSessionTimeoutMillis) {
        this.metadataStoreSessionTimeoutMillis = metadataStoreSessionTimeoutMillis;
    }

    @Generated
    public void setMetadataStoreCacheExpirySeconds(int metadataStoreCacheExpirySeconds) {
        this.metadataStoreCacheExpirySeconds = metadataStoreCacheExpirySeconds;
    }

    @Generated
    public void setZooKeeperSessionTimeoutMillis(long zooKeeperSessionTimeoutMillis) {
        this.zooKeeperSessionTimeoutMillis = zooKeeperSessionTimeoutMillis;
    }

    @Generated
    public void setZooKeeperCacheExpirySeconds(int zooKeeperCacheExpirySeconds) {
        this.zooKeeperCacheExpirySeconds = zooKeeperCacheExpirySeconds;
    }

    @Generated
    public void setWebServicePort(Optional<Integer> webServicePort) {
        this.webServicePort = webServicePort;
    }

    @Generated
    public void setWebServicePortTls(Optional<Integer> webServicePortTls) {
        this.webServicePortTls = webServicePortTls;
    }

    @Generated
    public void setBindAddress(String bindAddress) {
        this.bindAddress = bindAddress;
    }

    @Generated
    public void setWebServiceHaProxyProtocolEnabled(boolean webServiceHaProxyProtocolEnabled) {
        this.webServiceHaProxyProtocolEnabled = webServiceHaProxyProtocolEnabled;
    }

    @Generated
    public void setWebServiceTrustXForwardedFor(boolean webServiceTrustXForwardedFor) {
        this.webServiceTrustXForwardedFor = webServiceTrustXForwardedFor;
    }

    @Generated
    public void setWebServiceLogDetailedAddresses(Boolean webServiceLogDetailedAddresses) {
        this.webServiceLogDetailedAddresses = webServiceLogDetailedAddresses;
    }

    @Generated
    public void setWebSocketMaxTextFrameSize(int webSocketMaxTextFrameSize) {
        this.webSocketMaxTextFrameSize = webSocketMaxTextFrameSize;
    }

    @Generated
    public void setAuthenticationEnabled(boolean authenticationEnabled) {
        this.authenticationEnabled = authenticationEnabled;
    }

    @Generated
    public void setAuthenticationProviders(Set<String> authenticationProviders) {
        this.authenticationProviders = authenticationProviders;
    }

    @Generated
    public void setAuthorizationEnabled(boolean authorizationEnabled) {
        this.authorizationEnabled = authorizationEnabled;
    }

    @Generated
    public void setAuthorizationProvider(String authorizationProvider) {
        this.authorizationProvider = authorizationProvider;
    }

    @Generated
    public void setSuperUserRoles(Set<String> superUserRoles) {
        this.superUserRoles = superUserRoles;
    }

    @Generated
    public void setAuthorizationAllowWildcardsMatching(boolean authorizationAllowWildcardsMatching) {
        this.authorizationAllowWildcardsMatching = authorizationAllowWildcardsMatching;
    }

    @Generated
    public void setBrokerClientAuthenticationPlugin(String brokerClientAuthenticationPlugin) {
        this.brokerClientAuthenticationPlugin = brokerClientAuthenticationPlugin;
    }

    @Generated
    public void setBrokerClientAuthenticationParameters(String brokerClientAuthenticationParameters) {
        this.brokerClientAuthenticationParameters = brokerClientAuthenticationParameters;
    }

    @Generated
    public void setBrokerClientTrustCertsFilePath(String brokerClientTrustCertsFilePath) {
        this.brokerClientTrustCertsFilePath = brokerClientTrustCertsFilePath;
    }

    @Generated
    public void setTlsHostnameVerificationEnabled(boolean tlsHostnameVerificationEnabled) {
        this.tlsHostnameVerificationEnabled = tlsHostnameVerificationEnabled;
    }

    @Generated
    public void setWebSocketNumIoThreads(int webSocketNumIoThreads) {
        this.webSocketNumIoThreads = webSocketNumIoThreads;
    }

    @Generated
    public void setNumHttpServerThreads(int numHttpServerThreads) {
        this.numHttpServerThreads = numHttpServerThreads;
    }

    @Generated
    public void setWebSocketNumServiceThreads(int webSocketNumServiceThreads) {
        this.webSocketNumServiceThreads = webSocketNumServiceThreads;
    }

    @Generated
    public void setMaxConcurrentHttpRequests(int maxConcurrentHttpRequests) {
        this.maxConcurrentHttpRequests = maxConcurrentHttpRequests;
    }

    @Generated
    public void setHttpServerThreadPoolQueueSize(int httpServerThreadPoolQueueSize) {
        this.httpServerThreadPoolQueueSize = httpServerThreadPoolQueueSize;
    }

    @Generated
    public void setHttpServerAcceptQueueSize(int httpServerAcceptQueueSize) {
        this.httpServerAcceptQueueSize = httpServerAcceptQueueSize;
    }

    @Generated
    public void setMaxHttpServerConnections(int maxHttpServerConnections) {
        this.maxHttpServerConnections = maxHttpServerConnections;
    }

    @Generated
    public void setWebSocketConnectionsPerBroker(int webSocketConnectionsPerBroker) {
        this.webSocketConnectionsPerBroker = webSocketConnectionsPerBroker;
    }

    @Generated
    public void setWebSocketPulsarClientMemoryLimitInMB(int webSocketPulsarClientMemoryLimitInMB) {
        this.webSocketPulsarClientMemoryLimitInMB = webSocketPulsarClientMemoryLimitInMB;
    }

    @Generated
    public void setWebSocketSessionIdleTimeoutMillis(int webSocketSessionIdleTimeoutMillis) {
        this.webSocketSessionIdleTimeoutMillis = webSocketSessionIdleTimeoutMillis;
    }

    @Generated
    public void setWebSocketPingDurationSeconds(int webSocketPingDurationSeconds) {
        this.webSocketPingDurationSeconds = webSocketPingDurationSeconds;
    }

    @Generated
    public void setAnonymousUserRole(String anonymousUserRole) {
        this.anonymousUserRole = anonymousUserRole;
    }

    @Deprecated
    @Generated
    public void setTlsEnabled(boolean tlsEnabled) {
        this.tlsEnabled = tlsEnabled;
    }

    @Generated
    public void setBrokerClientTlsEnabled(boolean brokerClientTlsEnabled) {
        this.brokerClientTlsEnabled = brokerClientTlsEnabled;
    }

    @Generated
    public void setTlsCertificateFilePath(String tlsCertificateFilePath) {
        this.tlsCertificateFilePath = tlsCertificateFilePath;
    }

    @Generated
    public void setTlsKeyFilePath(String tlsKeyFilePath) {
        this.tlsKeyFilePath = tlsKeyFilePath;
    }

    @Generated
    public void setTlsTrustCertsFilePath(String tlsTrustCertsFilePath) {
        this.tlsTrustCertsFilePath = tlsTrustCertsFilePath;
    }

    @Generated
    public void setTlsAllowInsecureConnection(boolean tlsAllowInsecureConnection) {
        this.tlsAllowInsecureConnection = tlsAllowInsecureConnection;
    }

    @Generated
    public void setTlsRequireTrustedClientCertOnConnect(boolean tlsRequireTrustedClientCertOnConnect) {
        this.tlsRequireTrustedClientCertOnConnect = tlsRequireTrustedClientCertOnConnect;
    }

    @Generated
    public void setTlsCertRefreshCheckDurationSec(long tlsCertRefreshCheckDurationSec) {
        this.tlsCertRefreshCheckDurationSec = tlsCertRefreshCheckDurationSec;
    }

    @Generated
    public void setTlsEnabledWithKeyStore(boolean tlsEnabledWithKeyStore) {
        this.tlsEnabledWithKeyStore = tlsEnabledWithKeyStore;
    }

    @Generated
    public void setTlsProvider(String tlsProvider) {
        this.tlsProvider = tlsProvider;
    }

    @Generated
    public void setTlsKeyStoreType(String tlsKeyStoreType) {
        this.tlsKeyStoreType = tlsKeyStoreType;
    }

    @Generated
    public void setTlsKeyStore(String tlsKeyStore) {
        this.tlsKeyStore = tlsKeyStore;
    }

    @Generated
    public void setTlsKeyStorePassword(String tlsKeyStorePassword) {
        this.tlsKeyStorePassword = tlsKeyStorePassword;
    }

    @Generated
    public void setTlsTrustStoreType(String tlsTrustStoreType) {
        this.tlsTrustStoreType = tlsTrustStoreType;
    }

    @Generated
    public void setTlsTrustStore(String tlsTrustStore) {
        this.tlsTrustStore = tlsTrustStore;
    }

    @Generated
    public void setTlsTrustStorePassword(String tlsTrustStorePassword) {
        this.tlsTrustStorePassword = tlsTrustStorePassword;
    }

    @Generated
    public void setWebServiceTlsProtocols(Set<String> webServiceTlsProtocols) {
        this.webServiceTlsProtocols = webServiceTlsProtocols;
    }

    @Generated
    public void setWebServiceTlsCiphers(Set<String> webServiceTlsCiphers) {
        this.webServiceTlsCiphers = webServiceTlsCiphers;
    }

    @Generated
    public void setCryptoKeyReaderFactoryClassName(String cryptoKeyReaderFactoryClassName) {
        this.cryptoKeyReaderFactoryClassName = cryptoKeyReaderFactoryClassName;
    }

    @Generated
    public void setProperties(Properties properties) {
        this.properties = properties;
    }
}

