/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.exception;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.hbase.index.exception.IndexWriteException;
import org.apache.phoenix.hbase.index.table.HTableInterfaceReference;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;

public class MultiIndexWriteFailureException
extends IndexWriteException {
    public static final String FAILURE_MSG = "Failed to write to multiple index tables: ";
    private List<HTableInterfaceReference> failures;

    public MultiIndexWriteFailureException(List<HTableInterfaceReference> failures, boolean disableIndexOnFailure) {
        super(disableIndexOnFailure);
        this.failures = failures;
    }

    public MultiIndexWriteFailureException(List<HTableInterfaceReference> failures, boolean disableIndexOnFailure, Throwable cause) {
        super(cause, disableIndexOnFailure);
        this.failures = failures;
    }

    public MultiIndexWriteFailureException(String message) {
        super(IndexWriteException.parseDisableIndexOnFailure(message));
        Pattern p = Pattern.compile("Failed to write to multiple index tables: \\[(.*)\\]");
        Matcher m = p.matcher(message);
        if (m.find()) {
            this.failures = Lists.newArrayList();
            String tablesStr = m.group(1);
            for (String tableName : tablesStr.split(",\\s")) {
                HTableInterfaceReference tableRef = new HTableInterfaceReference(new ImmutableBytesPtr(Bytes.toBytes((String)tableName)));
                this.failures.add(tableRef);
            }
        }
    }

    public List<HTableInterfaceReference> getFailedTables() {
        return this.failures;
    }

    public void setFailedTables(List<HTableInterfaceReference> failedTables) {
        this.failures = failedTables;
    }

    @Override
    public String getMessage() {
        return (String)Objects.firstNonNull((Object)super.getMessage(), (Object)"") + " " + FAILURE_MSG + this.failures;
    }
}

