/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.event;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.enterprise.event.ObserverException;
import javax.enterprise.event.TransactionPhase;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AfterTypeDiscovery;
import javax.enterprise.inject.spi.AnnotatedCallable;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessBean;
import javax.enterprise.inject.spi.ProcessBeanAttributes;
import javax.enterprise.inject.spi.ProcessInjectionPoint;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.enterprise.inject.spi.ProcessManagedBean;
import javax.enterprise.inject.spi.ProcessObserverMethod;
import javax.enterprise.inject.spi.ProcessProducer;
import javax.enterprise.inject.spi.ProcessProducerField;
import javax.enterprise.inject.spi.ProcessProducerMethod;
import javax.enterprise.inject.spi.ProcessSyntheticAnnotatedType;
import javax.enterprise.util.TypeLiteral;
import org.apache.webbeans.component.AbstractOwbBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.event.ContainerEventObserverMethodImpl;
import org.apache.webbeans.event.EventMetadataImpl;
import org.apache.webbeans.event.EventUtil;
import org.apache.webbeans.event.ObserverMethodImpl;
import org.apache.webbeans.event.OwbObserverMethod;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.exception.WebBeansDeploymentException;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.logger.WebBeansLoggerFacade;
import org.apache.webbeans.portable.events.ProcessSessionBeanImpl;
import org.apache.webbeans.portable.events.generics.GenericBeanEvent;
import org.apache.webbeans.portable.events.generics.GenericProducerObserverEvent;
import org.apache.webbeans.portable.events.generics.TwoParametersGenericBeanEvent;
import org.apache.webbeans.spi.TransactionService;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.GenericsUtil;
import org.apache.webbeans.util.WebBeansUtil;

public final class NotificationManager {
    private final Map<Type, Set<ObserverMethod<?>>> observers = new ConcurrentHashMap();
    private final WebBeansContext webBeansContext;
    private final ConcurrentMap<Annotation, Boolean> hasContextLifecycleEventObservers = new ConcurrentHashMap<Annotation, Boolean>();
    private final ConcurrentHashMap<Class<?>, Set<ObserverMethod<?>>> observersByRawType = new ConcurrentHashMap();
    public static final Set<Class> CONTAINER_EVENT_CLASSES = new HashSet<Class>(Arrays.asList(AfterBeanDiscovery.class, AfterDeploymentValidation.class, AfterTypeDiscovery.class, BeforeBeanDiscovery.class, BeforeShutdown.class, ProcessAnnotatedType.class, ProcessBean.class, ProcessBeanAttributes.class, ProcessInjectionPoint.class, ProcessInjectionTarget.class, ProcessManagedBean.class, ProcessObserverMethod.class, ProcessProducer.class, ProcessProducerField.class, ProcessProducerMethod.class, ProcessSessionBeanImpl.class, ProcessSyntheticAnnotatedType.class));

    public NotificationManager(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
    }

    public void clearCaches() {
        this.observersByRawType.clear();
        this.hasContextLifecycleEventObservers.clear();
    }

    public boolean hasContextLifecycleObserver(Annotation lifecycleEvent) {
        Boolean hasObserver = (Boolean)this.hasContextLifecycleEventObservers.get(lifecycleEvent);
        if (hasObserver == null) {
            hasObserver = Boolean.FALSE;
            for (ObserverMethod<?> observerMethod : this.getObserverMethods()) {
                if (!observerMethod.getObservedQualifiers().contains(lifecycleEvent)) continue;
                hasObserver = Boolean.TRUE;
                break;
            }
            this.hasContextLifecycleEventObservers.putIfAbsent(lifecycleEvent, hasObserver);
        }
        return hasObserver;
    }

    public List<ObserverMethod<?>> getObserverMethods() {
        ArrayList observerMethods = new ArrayList();
        for (Set<ObserverMethod<?>> methods : this.observers.values()) {
            for (ObserverMethod<?> method : methods) {
                observerMethods.add(method);
            }
        }
        return observerMethods;
    }

    public <T> void addObserver(ObserverMethod<T> observer, Type eventType) {
        this.webBeansContext.getAnnotationManager().checkQualifierConditions(observer.getObservedQualifiers());
        Set<ObserverMethod<?>> set = this.observers.get(eventType);
        if (set == null) {
            set = new HashSet();
            this.observers.put(eventType, set);
        }
        set.add(observer);
    }

    public <T> void addObserver(ObserverMethod<T> observer, TypeLiteral<T> typeLiteral) {
        this.addObserver(observer, typeLiteral.getType());
    }

    public <T> Set<ObserverMethod<? super T>> resolveObservers(T event, EventMetadataImpl metadata, boolean isLifecycleEvent) {
        Type eventType = metadata.validatedType();
        Set<ObserverMethod<T>> observersMethods = this.filterByType(event, eventType, isLifecycleEvent);
        observersMethods = this.filterByQualifiers(observersMethods, metadata.getQualifiers());
        if (isLifecycleEvent && event instanceof ProcessAnnotatedType) {
            observersMethods = this.filterByWithAnnotations(observersMethods, ((ProcessAnnotatedType)event).getAnnotatedType());
        }
        if (!isLifecycleEvent && observersMethods.isEmpty()) {
            EventUtil.checkEventBindings(this.webBeansContext, metadata.getQualifiers());
            EventUtil.checkQualifierImplementations(metadata.getQualifiers());
        }
        return observersMethods;
    }

    private <T> Set<ObserverMethod<? super T>> filterByWithAnnotations(Set<ObserverMethod<? super T>> observersMethods, AnnotatedType annotatedType) {
        HashSet<ObserverMethod<T>> observerMethodsWithAnnotations = new HashSet<ObserverMethod<T>>();
        for (ObserverMethod<T> observerMethod : observersMethods) {
            Class[] withAnnotations = ((ContainerEventObserverMethodImpl)observerMethod).getWithAnnotations();
            if (withAnnotations != null && withAnnotations.length > 0) {
                if (!this.annotatedTypeHasAnnotations(annotatedType, withAnnotations)) continue;
                observerMethodsWithAnnotations.add(observerMethod);
                continue;
            }
            observerMethodsWithAnnotations.add(observerMethod);
        }
        return observerMethodsWithAnnotations;
    }

    private boolean annotatedTypeHasAnnotations(AnnotatedType annotatedType, Class<? extends Annotation>[] withAnnotations) {
        if (this.hasAnnotation(annotatedType.getAnnotations(), withAnnotations)) {
            return true;
        }
        Set fields = annotatedType.getFields();
        for (AnnotatedField annotatedField : fields) {
            if (!this.hasAnnotation(annotatedField.getAnnotations(), withAnnotations)) continue;
            return true;
        }
        Set annotatedMethods = annotatedType.getMethods();
        for (AnnotatedMethod annotatedMethod : annotatedMethods) {
            if (this.hasAnnotation(annotatedMethod.getAnnotations(), withAnnotations)) {
                return true;
            }
            for (AnnotatedParameter annotatedParameter : annotatedMethod.getParameters()) {
                if (!this.hasAnnotation(annotatedParameter.getAnnotations(), withAnnotations)) continue;
                return true;
            }
        }
        Set annotatedConstructors = annotatedType.getConstructors();
        for (AnnotatedConstructor annotatedConstructor : annotatedConstructors) {
            if (this.hasAnnotation(annotatedConstructor.getAnnotations(), withAnnotations)) {
                return true;
            }
            for (AnnotatedParameter annotatedParameter : annotatedConstructor.getParameters()) {
                if (!this.hasAnnotation(annotatedParameter.getAnnotations(), withAnnotations)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasAnnotation(Set<Annotation> annotations, Class<? extends Annotation>[] withAnnotations) {
        for (Class<? extends Annotation> withAnnotation : withAnnotations) {
            for (Annotation annotation : annotations) {
                if (withAnnotation.isAssignableFrom(annotation.annotationType())) {
                    return true;
                }
                for (Annotation meta : annotation.annotationType().getAnnotations()) {
                    if (!withAnnotation.isAssignableFrom(meta.annotationType())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private <T> Set<ObserverMethod<? super T>> filterByType(T event, Type declaredEventType, boolean isLifecycleEvent) {
        Set<ObserverMethod<? super T>> rawTypeObservers;
        if (isLifecycleEvent) {
            return this.filterByExtensionEventType(event, declaredEventType);
        }
        Class<?> eventClass = event.getClass();
        boolean isRawEvent = declaredEventType instanceof Class;
        if (isRawEvent && (rawTypeObservers = this.observersByRawType.get(eventClass)) != null) {
            return rawTypeObservers;
        }
        HashSet<ObserverMethod<T>> matching = new HashSet<ObserverMethod<T>>();
        Set<Type> eventTypes = GenericsUtil.getTypeClosure(declaredEventType, eventClass);
        if (GenericsUtil.containTypeVariable(eventTypes)) {
            throw new IllegalArgumentException("event type may not contain unbound type variable: " + eventTypes);
        }
        block0: for (Map.Entry<Type, Set<ObserverMethod<?>>> observerEntry : this.observers.entrySet()) {
            Type observedType = observerEntry.getKey();
            for (Type eventType : eventTypes) {
                if ((!ParameterizedType.class.isInstance(eventType) || !Class.class.isInstance(observedType) || !GenericsUtil.isAssignableFrom(true, false, observedType, ((ParameterizedType)ParameterizedType.class.cast(eventType)).getRawType())) && !GenericsUtil.isAssignableFrom(true, false, observedType, eventType)) continue;
                Set<ObserverMethod<?>> observerMethods = observerEntry.getValue();
                for (ObserverMethod<?> observerMethod : observerMethods) {
                    matching.add(observerMethod);
                }
                continue block0;
            }
        }
        if (isRawEvent) {
            this.observersByRawType.putIfAbsent(eventClass, matching);
        }
        return matching;
    }

    private <T> Set<ObserverMethod<? super T>> filterByExtensionEventType(T event, Type eventType) {
        Class<?> eventClass = ClassUtil.getClazz(eventType);
        HashSet<ObserverMethod<? super T>> matching = new HashSet<ObserverMethod<? super T>>();
        Set<Type> keySet = this.observers.keySet();
        for (Type type : keySet) {
            Class<?> beanClass;
            Object genericBeanEvent;
            Class<?> observerClass = ClassUtil.getClazz(type);
            if (observerClass == null || !observerClass.isAssignableFrom(eventClass)) continue;
            if (WebBeansUtil.isExtensionBeanEventType(eventType)) {
                if (!WebBeansUtil.isDefaultExtensionBeanEventType(observerClass)) continue;
                genericBeanEvent = (GenericBeanEvent)event;
                beanClass = genericBeanEvent.getBeanClassFor(observerClass);
                if (ClassUtil.isParametrizedType(type)) {
                    Type secondParam = null;
                    if (TwoParametersGenericBeanEvent.class.isInstance(event)) {
                        secondParam = ((TwoParametersGenericBeanEvent)TwoParametersGenericBeanEvent.class.cast(event)).getInjectionType();
                    }
                    this.addToMatchingWithParametrizedForBeans(type, matching, beanClass, secondParam);
                    continue;
                }
                this.addToMatching(type, matching);
                continue;
            }
            if (WebBeansUtil.isExtensionProducerOrObserverEventType(eventType)) {
                genericBeanEvent = (GenericProducerObserverEvent)event;
                beanClass = genericBeanEvent.getBeanClass();
                Class<?> producerOrObserverReturnClass = genericBeanEvent.getProducerOrObserverType();
                if (WebBeansUtil.isDefaultExtensionProducerOrObserverEventType(observerClass)) {
                    boolean processProducerEvent = false;
                    if (observerClass.equals(ProcessProducer.class)) {
                        processProducerEvent = true;
                    }
                    if (ClassUtil.isParametrizedType(type)) {
                        this.addToMatchingWithParametrizedForProducers(processProducerEvent, type, beanClass, producerOrObserverReturnClass, matching);
                        continue;
                    }
                    this.addToMatching(type, matching);
                    continue;
                }
                if (!observerClass.isAssignableFrom(eventClass)) continue;
                if (ClassUtil.isParametrizedType(type)) {
                    this.addToMatchingWithParametrizedForBeans(type, matching, beanClass, null);
                    continue;
                }
                this.addToMatching(type, matching);
                continue;
            }
            if (!observerClass.isAssignableFrom(eventClass)) continue;
            this.addToMatching(type, matching);
        }
        return matching;
    }

    private boolean checkEventTypeParameterForExtensions(Type beanClass, Type observerTypeActualArg) {
        if (ClassUtil.isTypeVariable(observerTypeActualArg)) {
            TypeVariable tv = (TypeVariable)observerTypeActualArg;
            Type tvBound = tv.getBounds()[0];
            if (tvBound instanceof Class) {
                Class clazzTvBound = (Class)tvBound;
                if (Class.class.isInstance(beanClass) && clazzTvBound.isAssignableFrom((Class)Class.class.cast(beanClass))) {
                    return true;
                }
            }
        } else {
            if (ClassUtil.isWildCardType(observerTypeActualArg)) {
                return ClassUtil.checkRequiredTypeIsWildCard(beanClass, observerTypeActualArg);
            }
            if (observerTypeActualArg instanceof Class) {
                Class observerClass = (Class)observerTypeActualArg;
                if (Class.class.isInstance(beanClass) && observerClass.isAssignableFrom((Class)Class.class.cast(beanClass))) {
                    return true;
                }
            }
        }
        return false;
    }

    private <T> void addToMatching(Type type, Set<ObserverMethod<? super T>> matching) {
        Set<ObserverMethod<?>> wrappers = this.observers.get(type);
        for (ObserverMethod<?> wrapper : wrappers) {
            matching.add(wrapper);
        }
    }

    private <T> void addToMatchingWithParametrizedForBeans(Type type, Set<ObserverMethod<? super T>> matching, Class<?> beanClass, Type secondParam) {
        ParameterizedType pt = (ParameterizedType)type;
        Type[] actualArgs = pt.getActualTypeArguments();
        if (actualArgs.length == 0) {
            Class rawType = (Class)pt.getRawType();
            if (rawType.isAssignableFrom(beanClass)) {
                this.addToMatching(type, matching);
            }
        } else if (this.checkEventTypeParameterForExtensions(beanClass, actualArgs[0]) && (secondParam == null || actualArgs.length == 1 || this.checkEventTypeParameterForExtensions(secondParam, actualArgs[1]) || GenericsUtil.isAssignableFrom(true, false, actualArgs[1], secondParam))) {
            this.addToMatching(type, matching);
        }
    }

    private <T> void addToMatchingWithParametrizedForProducers(boolean processProducer, Type type, Class<?> beanClass, Class<?> producerOrObserverReturnClass, Set<ObserverMethod<? super T>> matching) {
        ParameterizedType pt = (ParameterizedType)type;
        Type[] actualArgs = pt.getActualTypeArguments();
        if (actualArgs.length == 0) {
            Class rawType = (Class)pt.getRawType();
            if (rawType.isAssignableFrom(beanClass)) {
                this.addToMatching(type, matching);
            }
        } else {
            Type beanClassArg = actualArgs[1];
            Type returnClassArg = actualArgs[0];
            if (processProducer) {
                beanClassArg = actualArgs[0];
                returnClassArg = actualArgs[1];
            }
            if (this.checkEventTypeParameterForExtensions(beanClass, beanClassArg) && this.checkEventTypeParameterForExtensions(producerOrObserverReturnClass, returnClassArg)) {
                this.addToMatching(type, matching);
            }
        }
    }

    private <T> Set<ObserverMethod<? super T>> filterByQualifiers(Set<ObserverMethod<? super T>> observers, Set<Annotation> eventQualifiers) {
        HashSet<ObserverMethod<T>> matching = new HashSet<ObserverMethod<T>>();
        block0: for (ObserverMethod<T> observerMethod : observers) {
            Set qualifiers = observerMethod.getObservedQualifiers();
            if (qualifiers.size() > eventQualifiers.size()) continue;
            for (Annotation qualifier : qualifiers) {
                boolean found = false;
                for (Annotation inList : eventQualifiers) {
                    if (!AnnotationUtil.isCdiAnnotationEqual(inList, qualifier)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                continue block0;
            }
            matching.add(observerMethod);
        }
        return matching;
    }

    public void fireEvent(Object event, EventMetadataImpl metadata, boolean isLifecycleEvent) {
        if (!isLifecycleEvent && this.webBeansContext.getWebBeansUtil().isContainerEventType(event)) {
            throw new IllegalArgumentException("Firing container events is forbidden");
        }
        Set<ObserverMethod<Object>> observerMethods = this.resolveObservers(event, metadata, isLifecycleEvent);
        for (ObserverMethod<Object> observer : observerMethods) {
            try {
                if (isLifecycleEvent && !Extension.class.isAssignableFrom(observer.getBeanClass())) continue;
                TransactionPhase phase = observer.getTransactionPhase();
                if (phase != null && !phase.equals((Object)TransactionPhase.IN_PROGRESS)) {
                    TransactionService transactionService = this.webBeansContext.getService(TransactionService.class);
                    if (transactionService != null) {
                        transactionService.registerTransactionSynchronization(phase, observer, event);
                        continue;
                    }
                    if (observer instanceof OwbObserverMethod) {
                        ((OwbObserverMethod)observer).notify(event, metadata);
                        continue;
                    }
                    observer.notify(event);
                    continue;
                }
                if (observer instanceof OwbObserverMethod) {
                    ((OwbObserverMethod)observer).notify(event, metadata);
                    continue;
                }
                observer.notify(event);
            }
            catch (WebBeansException e) {
                Throwable exc = e.getCause();
                if (exc instanceof InvocationTargetException) {
                    InvocationTargetException invt = (InvocationTargetException)exc;
                    exc = invt.getCause();
                }
                if (isLifecycleEvent) {
                    if (event instanceof AfterDeploymentValidation) {
                        throw new WebBeansDeploymentException("Error while sending SystemEvent to a CDI Extension! " + event.toString(), e);
                    }
                    throw new WebBeansConfigurationException("Error while sending SystemEvent to a CDI Extension! " + event.toString(), e);
                }
                if (!RuntimeException.class.isAssignableFrom(exc.getClass())) {
                    throw new ObserverException(WebBeansLoggerFacade.getTokenString("EXCEPT_0008") + event.getClass().getName(), (Throwable)e);
                }
                RuntimeException rte = (RuntimeException)exc;
                throw rte;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new WebBeansException(e);
            }
        }
    }

    public <T> ObserverMethod<?> getObservableMethodForAnnotatedMethod(AnnotatedMethod<?> annotatedMethod, AnnotatedParameter<?> annotatedParameter, AbstractOwbBean<T> bean) {
        Asserts.assertNotNull(annotatedParameter, "annotatedParameter");
        ObserverMethodImpl observer = this.isContainerEvent(annotatedParameter) ? new ContainerEventObserverMethodImpl(bean, annotatedMethod, annotatedParameter) : new ObserverMethodImpl(bean, annotatedMethod, annotatedParameter);
        this.addObserver(observer, annotatedParameter.getBaseType());
        return observer;
    }

    public boolean isContainerEvent(AnnotatedParameter<?> annotatedParameter) {
        AnnotatedCallable method = annotatedParameter.getDeclaringCallable();
        if (!AnnotatedMethod.class.isInstance(method) || method.getParameters().size() == 0) {
            return false;
        }
        Class<?> paramType = ((AnnotatedMethod)AnnotatedMethod.class.cast(method)).getJavaMember().getParameterTypes()[0];
        return CONTAINER_EVENT_CLASSES.contains(paramType);
    }
}

