/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.portable.events;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.inject.spi.DefinitionException;
import javax.enterprise.inject.spi.DeploymentException;
import javax.enterprise.inject.spi.Extension;
import org.apache.webbeans.component.ExtensionBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.util.ExceptionUtil;
import org.apache.webbeans.util.WebBeansUtil;

public class ExtensionLoader {
    private final Map<Class<?>, Object> extensions = new ConcurrentHashMap();
    private final Set<Class<? extends Extension>> extensionClasses = new HashSet<Class<? extends Extension>>();
    private final BeanManagerImpl manager;
    private final WebBeansContext webBeansContext;

    public ExtensionLoader(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
        this.manager = this.webBeansContext.getBeanManagerImpl();
    }

    public void loadExtensionServices() {
        this.loadExtensionServices(WebBeansUtil.getCurrentClassLoader());
    }

    public void loadExtensionServices(ClassLoader classLoader) {
        List loader = this.webBeansContext.getLoaderService().load(Extension.class, classLoader);
        for (Extension extension : loader) {
            if (this.extensionClasses.contains(extension.getClass())) continue;
            this.extensionClasses.add(extension.getClass());
            try {
                this.addExtension(extension);
            }
            catch (Exception e) {
                if (e instanceof DefinitionException || e instanceof DeploymentException) {
                    ExceptionUtil.throwAsRuntimeException(e);
                }
                throw new WebBeansException("Error occurred while reading Extension service list", e);
            }
        }
    }

    public <T> T getExtension(Class<T> extensionClass) {
        return (T)this.extensions.get(extensionClass);
    }

    public void addExtension(Extension ext) {
        ExtensionBean<?> bean = this.webBeansContext.getWebBeansUtil().createExtensionComponent(ext.getClass());
        Class<?> extensionClass = ext.getClass();
        this.extensions.put(extensionClass, ext);
        this.manager.addBean(bean);
    }

    public void clear() {
        this.extensions.clear();
        this.extensionClasses.clear();
    }
}

