/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.validator.core.factory;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.el.MethodExpression;
import javax.faces.component.behavior.AjaxBehavior;
import javax.faces.context.FacesContext;
import javax.faces.event.AjaxBehaviorListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtValAjaxBehavior
extends AjaxBehavior {
    private Set<MethodExpression> listenerExpressions;

    public void addAjaxBehaviorListener(AjaxBehaviorListener listener) {
        super.addAjaxBehaviorListener(listener);
        if (this.listenerExpressions == null) {
            this.listenerExpressions = new HashSet<MethodExpression>();
        }
        this.listenerExpressions.addAll(ExtValAjaxBehavior.extractListenerExpressions(listener));
    }

    public void removeAjaxBehaviorListener(AjaxBehaviorListener listener) {
        super.removeAjaxBehaviorListener(listener);
        if (this.listenerExpressions != null) {
            for (MethodExpression expressionToRemove : ExtValAjaxBehavior.extractListenerExpressions(listener)) {
                this.listenerExpressions.remove(expressionToRemove);
            }
        }
    }

    public List<MethodExpression> getListenerExpressions() {
        if (this.listenerExpressions == null) {
            return Collections.emptyList();
        }
        return new ArrayList<MethodExpression>(this.listenerExpressions);
    }

    public void restoreState(FacesContext facesContext, Object o) {
        Object[] state = (Object[])o;
        if (state[0] != null) {
            this.listenerExpressions = (Set)state[0];
        }
        super.restoreState(facesContext, state[1]);
    }

    public Object saveState(FacesContext facesContext) {
        Object[] result = new Object[]{this.listenerExpressions, super.saveState(facesContext)};
        return result;
    }

    private static List<MethodExpression> extractListenerExpressions(AjaxBehaviorListener listener) {
        ArrayList<MethodExpression> result = new ArrayList<MethodExpression>();
        for (Field field : listener.getClass().getDeclaredFields()) {
            field.setAccessible(true);
            try {
                Object fieldValue = field.get(listener);
                if (!(fieldValue instanceof MethodExpression)) continue;
                result.add((MethodExpression)fieldValue);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }
}

