/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.spi.impl;

import jakarta.faces.FacesException;
import jakarta.faces.context.ExternalContext;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.config.DefaultFacesConfigurationProvider;
import org.apache.myfaces.spi.FacesConfigurationProvider;
import org.apache.myfaces.spi.FacesConfigurationProviderFactory;
import org.apache.myfaces.spi.ServiceProviderFinderFactory;
import org.apache.myfaces.util.lang.ClassUtils;

public class DefaultFacesConfigurationProviderFactory
extends FacesConfigurationProviderFactory {
    public static final String FACES_CONFIGURATION_PROVIDER = FacesConfigurationProvider.class.getName();
    public static final String FACES_CONFIGURATION_PROVIDER_LIST = FacesConfigurationProvider.class.getName() + ".LIST";
    public static final String FACES_CONFIGURATION_PROVIDER_INSTANCE_KEY = FacesConfigurationProvider.class.getName() + ".INSTANCE";

    private Logger getLogger() {
        return Logger.getLogger(DefaultFacesConfigurationProviderFactory.class.getName());
    }

    @Override
    public FacesConfigurationProvider getFacesConfigurationProvider(ExternalContext externalContext) {
        FacesConfigurationProvider returnValue = (FacesConfigurationProvider)externalContext.getApplicationMap().get(FACES_CONFIGURATION_PROVIDER_INSTANCE_KEY);
        if (returnValue == null) {
            ExternalContext extContext = externalContext;
            try {
                returnValue = System.getSecurityManager() != null ? (FacesConfigurationProvider)AccessController.doPrivileged(() -> this.resolveFacesConfigurationProviderFromService(extContext)) : this.resolveFacesConfigurationProviderFromService(extContext);
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoClassDefFoundError | InvocationTargetException e) {
                this.getLogger().log(Level.SEVERE, "", e);
            }
            catch (PrivilegedActionException e) {
                throw new FacesException(e);
            }
        }
        if (returnValue == null) {
            returnValue = new DefaultFacesConfigurationProvider();
        }
        externalContext.getApplicationMap().put(FACES_CONFIGURATION_PROVIDER_INSTANCE_KEY, returnValue);
        return returnValue;
    }

    private FacesConfigurationProvider resolveFacesConfigurationProviderFromService(ExternalContext externalContext) throws ClassNotFoundException, NoClassDefFoundError, InstantiationException, IllegalAccessException, InvocationTargetException, PrivilegedActionException {
        List<String> classList = (List<String>)externalContext.getApplicationMap().get(FACES_CONFIGURATION_PROVIDER_LIST);
        if (classList == null) {
            classList = ServiceProviderFinderFactory.getServiceProviderFinder(externalContext).getServiceProviderList(FACES_CONFIGURATION_PROVIDER);
            externalContext.getApplicationMap().put(FACES_CONFIGURATION_PROVIDER_LIST, classList);
        }
        return ClassUtils.buildApplicationObject(FacesConfigurationProvider.class, classList, new DefaultFacesConfigurationProvider());
    }
}

