/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.system;

import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.crawler.interfaces.IJobManager;
import org.apache.manifoldcf.crawler.interfaces.IPriorityCalculator;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnection;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnectionManager;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnector;
import org.apache.manifoldcf.crawler.interfaces.IReprioritizationTracker;
import org.apache.manifoldcf.crawler.interfaces.ISeedingActivity;
import org.apache.manifoldcf.crawler.system.ManifoldCF;
import org.apache.manifoldcf.crawler.system.PriorityCalculator;

public class SeedingActivity
implements ISeedingActivity {
    public static final String _rcsid = "@(#)$Id: SeedingActivity.java 988245 2010-08-23 18:39:35Z kwright $";
    protected static final int MAX_COUNT = 100;
    protected final String processID;
    protected final String connectionName;
    protected final IRepositoryConnectionManager connManager;
    protected final IJobManager jobManager;
    protected final IReprioritizationTracker rt;
    protected final IRepositoryConnection connection;
    protected final IRepositoryConnector connector;
    protected final Long jobID;
    protected final String[] legalLinkTypes;
    protected final boolean overrideSchedule;
    protected final int hopcountMethod;
    protected final String[] documentHashList = new String[100];
    protected final String[] documentList = new String[100];
    protected final String[][] documentPrereqList = new String[100][];
    protected int documentCount = 0;
    protected final String[] remainingDocumentHashList = new String[100];
    protected int remainingDocumentCount = 0;

    public SeedingActivity(String connectionName, IRepositoryConnectionManager connManager, IJobManager jobManager, IReprioritizationTracker rt, IRepositoryConnection connection, IRepositoryConnector connector, Long jobID, String[] legalLinkTypes, boolean overrideSchedule, int hopcountMethod, String processID) {
        this.processID = processID;
        this.connectionName = connectionName;
        this.connManager = connManager;
        this.jobManager = jobManager;
        this.rt = rt;
        this.connection = connection;
        this.connector = connector;
        this.jobID = jobID;
        this.legalLinkTypes = legalLinkTypes;
        this.overrideSchedule = overrideSchedule;
        this.hopcountMethod = hopcountMethod;
    }

    @Override
    public void addSeedDocument(String documentIdentifier, String[] prereqEventNames) throws ManifoldCFException {
        if (this.documentCount == 100) {
            this.writeSeedDocuments(this.documentHashList, this.documentList, this.documentPrereqList);
            this.documentCount = 0;
        }
        this.documentHashList[this.documentCount] = ManifoldCF.hash((String)documentIdentifier);
        this.documentList[this.documentCount] = documentIdentifier;
        this.documentPrereqList[this.documentCount] = prereqEventNames != null ? prereqEventNames : null;
        ++this.documentCount;
    }

    @Override
    public void addSeedDocument(String documentIdentifier) throws ManifoldCFException {
        this.addSeedDocument(documentIdentifier, null);
    }

    @Override
    public void addUnqueuedSeedDocument(String documentIdentifier) throws ManifoldCFException {
        if (this.remainingDocumentCount == 100) {
            this.jobManager.addRemainingDocumentsInitial(this.processID, this.jobID, this.legalLinkTypes, this.remainingDocumentHashList, this.hopcountMethod);
            this.remainingDocumentCount = 0;
        }
        this.remainingDocumentHashList[this.remainingDocumentCount++] = ManifoldCF.hash((String)documentIdentifier);
    }

    public void doneSeeding(boolean isPartial) throws ManifoldCFException {
        if (this.documentCount > 0) {
            String[] documentHashes = new String[this.documentCount];
            String[] documents = new String[this.documentCount];
            String[][] documentPrereqs = new String[this.documentCount][];
            for (int i = 0; i < documentHashes.length; ++i) {
                documentHashes[i] = this.documentHashList[i];
                documents[i] = this.documentList[i];
                documentPrereqs[i] = this.documentPrereqList[i];
            }
            this.writeSeedDocuments(documentHashes, documents, documentPrereqs);
            this.documentCount = 0;
        }
        if (this.remainingDocumentCount > 0) {
            String[] documents = new String[this.remainingDocumentCount];
            for (int i = 0; i < documents.length; ++i) {
                documents[i] = this.remainingDocumentHashList[i];
            }
            this.jobManager.addRemainingDocumentsInitial(this.processID, this.jobID, this.legalLinkTypes, documents, this.hopcountMethod);
            this.remainingDocumentCount = 0;
        }
        this.jobManager.doneDocumentsInitial(this.jobID, this.legalLinkTypes, isPartial, this.hopcountMethod);
    }

    @Override
    public void recordActivity(Long startTime, String activityType, Long dataSize, String entityIdentifier, String resultCode, String resultDescription, String[] childIdentifiers) throws ManifoldCFException {
        this.connManager.recordHistory(this.connectionName, startTime, activityType, dataSize, entityIdentifier, resultCode, resultDescription, childIdentifiers);
    }

    protected void writeSeedDocuments(String[] docIDHashes, String[] docIDs, String[][] prereqEventNames) throws ManifoldCFException {
        IPriorityCalculator[] docPriorities = new IPriorityCalculator[docIDHashes.length];
        this.rt.clearPreloadRequests();
        for (int i = 0; i < docIDHashes.length; ++i) {
            String[] bins = this.connector.getBinNames(docIDs[i]);
            PriorityCalculator p = new PriorityCalculator(this.rt, this.connection, bins, docIDs[i]);
            docPriorities[i] = p;
            p.makePreloadRequest();
        }
        this.rt.preloadBinValues();
        this.jobManager.addDocumentsInitial(this.processID, this.jobID, this.legalLinkTypes, docIDHashes, docIDs, this.overrideSchedule, this.hopcountMethod, docPriorities, prereqEventNames);
    }

    @Override
    public void checkJobStillActive() throws ManifoldCFException, ServiceInterruption {
        if (!this.jobManager.checkJobActive(this.jobID)) {
            throw new ServiceInterruption("Job no longer active", System.currentTimeMillis());
        }
    }

    @Override
    public String createGlobalString(String simpleString) {
        return ManifoldCF.createGlobalString(simpleString);
    }

    @Override
    public String createConnectionSpecificString(String simpleString) {
        return ManifoldCF.createConnectionSpecificString(this.connection.getName(), simpleString);
    }

    @Override
    public String createJobSpecificString(String simpleString) {
        return ManifoldCF.createJobSpecificString(this.jobID, simpleString);
    }
}

