/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc.protocolPB;

import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.hadoop.ipc.GenericRefreshProtocol;
import org.apache.hadoop.ipc.RefreshResponse;
import org.apache.hadoop.ipc.proto.GenericRefreshProtocolProtos;
import org.apache.hadoop.ipc.protocolPB.GenericRefreshProtocolPB;

public class GenericRefreshProtocolServerSideTranslatorPB
implements GenericRefreshProtocolPB {
    private final GenericRefreshProtocol impl;

    public GenericRefreshProtocolServerSideTranslatorPB(GenericRefreshProtocol impl) {
        this.impl = impl;
    }

    @Override
    public GenericRefreshProtocolProtos.GenericRefreshResponseCollectionProto refresh(RpcController controller, GenericRefreshProtocolProtos.GenericRefreshRequestProto request) throws ServiceException {
        try {
            List<String> argList = request.getArgsList();
            String[] args = argList.toArray(new String[argList.size()]);
            if (!request.hasIdentifier()) {
                throw new ServiceException("Request must contain identifier");
            }
            Collection<RefreshResponse> results = this.impl.refresh(request.getIdentifier(), args);
            return this.pack(results);
        }
        catch (IOException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    private GenericRefreshProtocolProtos.GenericRefreshResponseCollectionProto pack(Collection<RefreshResponse> responses) {
        GenericRefreshProtocolProtos.GenericRefreshResponseCollectionProto.Builder b = GenericRefreshProtocolProtos.GenericRefreshResponseCollectionProto.newBuilder();
        for (RefreshResponse response : responses) {
            GenericRefreshProtocolProtos.GenericRefreshResponseProto.Builder respBuilder = GenericRefreshProtocolProtos.GenericRefreshResponseProto.newBuilder();
            respBuilder.setExitStatus(response.getReturnCode());
            respBuilder.setUserMessage(response.getMessage());
            respBuilder.setSenderName(response.getSenderName());
            b.addResponses(respBuilder);
        }
        return b.build();
    }
}

