/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.util.Map;
import java.util.Set;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.engine.spark.job.NSparkExecutable;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.DefaultChainedExecutable;

public class NSparkLocalStep
extends NSparkExecutable {
    private static final String[] excludedSparkConf = new String[]{"spark.executor.cores", "spark.executor.memoryOverhead", "spark.executor.extraJavaOptions", "spark.executor.instances", "spark.executor.memory", "spark.executor.extraClassPath", "spark.submit.deployMode"};

    @Override
    protected Set<String> getMetadataDumpList(KylinConfig config) {
        AbstractExecutable parent = this.getParentExecutable();
        if (parent instanceof DefaultChainedExecutable) {
            return ((DefaultChainedExecutable)parent).getMetadataDumpList(config);
        }
        throw new IllegalStateException("Unsupported " + this.getName() + " for non chained executable!");
    }

    @Override
    protected Map<String, String> getSparkConfigOverride(KylinConfig config) {
        Map<String, String> sparkConfigOverride = super.getSparkConfigOverride(config);
        this.overrideSparkConf(sparkConfigOverride);
        for (String sparkConf : excludedSparkConf) {
            if (!sparkConfigOverride.containsKey(sparkConf)) continue;
            sparkConfigOverride.remove(sparkConf);
        }
        return sparkConfigOverride;
    }

    protected void overrideSparkConf(Map<String, String> sparkConfigOverride) {
        sparkConfigOverride.put("spark.master", "local");
        sparkConfigOverride.put("spark.sql.autoBroadcastJoinThreshold", "-1");
        sparkConfigOverride.put("spark.sql.adaptive.enabled", "false");
    }
}

