/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.io.Serializable;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.kylin.engine.spark.builder.CubeBuilderHelper$;
import org.apache.kylin.engine.spark.job.NSparkCubingUtil;
import org.apache.kylin.engine.spark.job.UdfManager$;
import org.apache.kylin.engine.spark.metadata.ColumnDesc;
import org.apache.kylin.engine.spark.metadata.DTType;
import org.apache.kylin.engine.spark.metadata.FunctionDesc;
import org.apache.kylin.engine.spark.metadata.LiteralColumnDesc;
import org.apache.kylin.engine.spark.metadata.cube.model.SpanningTree;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.aggregate.AggregateFunction;
import org.apache.spark.sql.catalyst.expressions.aggregate.TypedImperativeAggregate;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.udaf.EncodeApproxCountDistinct;
import org.apache.spark.sql.udaf.EncodeApproxCountDistinct$;
import org.apache.spark.sql.udaf.EncodePreciseCountDistinct;
import org.apache.spark.sql.udaf.EncodePreciseCountDistinct$;
import org.apache.spark.sql.udaf.EncodeTopN;
import org.apache.spark.sql.udaf.EncodeTopN$;
import org.apache.spark.sql.udaf.ReuseApproxCountDistinct;
import org.apache.spark.sql.udaf.ReuseApproxCountDistinct$;
import org.apache.spark.sql.udaf.ReusePreciseCountDistinct;
import org.apache.spark.sql.udaf.ReusePreciseCountDistinct$;
import org.apache.spark.sql.udaf.ReuseTopN;
import org.apache.spark.sql.udaf.ReuseTopN$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Iterable;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class CuboidAggregator$ {
    public static CuboidAggregator$ MODULE$;

    static {
        new CuboidAggregator$();
    }

    public Dataset<Row> agg(SparkSession ss, Dataset<Row> dataSet, Set<Integer> dimensions, Map<Integer, FunctionDesc> measures, SpanningTree spanningTree, boolean isSparkSql) {
        return this.aggInternal(ss, dataSet, dimensions, measures, isSparkSql);
    }

    public Dataset<Row> aggInternal(SparkSession ss, Dataset<Row> dataSet, Set<Integer> dimensions, Map<Integer, FunctionDesc> measures, boolean isSparkSql) {
        Dataset dataset;
        Dataset df;
        if (measures.isEmpty()) {
            return dataSet.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])NSparkCubingUtil.getColumns(dimensions))).dropDuplicates();
        }
        boolean reuseLayout = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dataSet.schema().fieldNames())).contains((Object)((Integer)((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(measures.keySet()).asScala()).head()).toString());
        Seq agg = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(measures).asScala()).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Column column;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Integer id = (Integer)tuple2._1();
                FunctionDesc measure = (FunctionDesc)tuple2._2();
                ListBuffer columns = new ListBuffer();
                if (reuseLayout) {
                    columns.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(id.toString())}));
                } else if (((ColumnDesc)measure.pra().head()).isColumnType()) {
                    scala.collection.immutable.Map colIndex = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dataSet.schema().fieldNames())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)tp -> new Tuple2((Object)BoxesRunTime.boxToInteger((int)tp._2$mcI$sp()), tp._1()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toMap(Predef$.MODULE$.$conforms());
                    columns.appendAll((TraversableOnce)measure.pra().map((Function1 & Serializable & scala.Serializable)p -> functions$.MODULE$.col(Integer.toString(p.id())), List$.MODULE$.canBuildFrom()));
                } else {
                    Object object;
                    Object value = ((LiteralColumnDesc)measure.pra().head()).value();
                    DataType dataType = ((ColumnDesc)measure.pra().head()).dataType();
                    if (BooleanType$.MODULE$.equals(dataType)) {
                        object = BoxesRunTime.boxToBoolean((boolean)new StringOps(Predef$.MODULE$.augmentString((String)value)).toBoolean());
                    } else if (ByteType$.MODULE$.equals(dataType)) {
                        object = BoxesRunTime.boxToByte((byte)new StringOps(Predef$.MODULE$.augmentString((String)value)).toByte());
                    } else if (ShortType$.MODULE$.equals(dataType)) {
                        object = BoxesRunTime.boxToShort((short)new StringOps(Predef$.MODULE$.augmentString((String)value)).toShort());
                    } else {
                        boolean bl = IntegerType$.MODULE$.equals(dataType) ? true : DateType$.MODULE$.equals(dataType);
                        if (bl) {
                            object = BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString((String)value)).toInt());
                        } else {
                            boolean bl2 = LongType$.MODULE$.equals(dataType) ? true : TimestampType$.MODULE$.equals(dataType);
                            if (bl2) {
                                object = BoxesRunTime.boxToLong((long)new StringOps(Predef$.MODULE$.augmentString((String)value)).toLong());
                            } else if (FloatType$.MODULE$.equals(dataType)) {
                                object = BoxesRunTime.boxToFloat((float)new StringOps(Predef$.MODULE$.augmentString((String)value)).toFloat());
                            } else if (DoubleType$.MODULE$.equals(dataType)) {
                                object = BoxesRunTime.boxToDouble((double)new StringOps(Predef$.MODULE$.augmentString((String)value)).toDouble());
                            } else if (BinaryType$.MODULE$.equals(dataType)) {
                                object = new StringOps(Predef$.MODULE$.augmentString((String)value)).toArray(ClassTag$.MODULE$.Char());
                            } else if (StringType$.MODULE$.equals(dataType)) {
                                object = (UTF8String)value;
                            } else {
                                throw new MatchError((Object)dataType);
                            }
                        }
                    }
                    value = object;
                    columns.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{new Column((Expression)Literal$.MODULE$.create(value, ((ColumnDesc)measure.pra().head()).dataType()))}));
                }
                String string = measure.expression().toUpperCase(Locale.ROOT);
                if ("MAX".equals(string)) {
                    column = functions$.MODULE$.max((Column)columns.head()).as(id.toString());
                } else if ("MIN".equals(string)) {
                    column = functions$.MODULE$.min((Column)columns.head()).as(id.toString());
                } else if ("SUM".equals(string)) {
                    column = functions$.MODULE$.sum((Column)columns.head()).as(id.toString());
                } else if ("COUNT".equals(string)) {
                    column = reuseLayout ? functions$.MODULE$.sum((Column)columns.head()).as(id.toString()) : functions$.MODULE$.count((Column)columns.head()).as(id.toString());
                } else if ("COUNT_DISTINCT".equals(string)) {
                    Column column2;
                    if (isSparkSql) {
                        column2 = functions$.MODULE$.countDistinct((Column)columns.head(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[0])).as(id.toString());
                    } else {
                        AggregateFunction cdAggregate = MODULE$.getCountDistinctAggregate((ListBuffer<Column>)columns, measure.returnType(), reuseLayout);
                        column2 = new Column((Expression)cdAggregate.toAggregateExpression()).as(id.toString());
                    }
                    column = column2;
                } else if ("TOP_N".equals(string)) {
                    StructType schema = StructType$.MODULE$.apply((Seq)measure.pra().map((Function1 & Serializable & scala.Serializable)col -> {
                        DataType dateType = col.dataType();
                        ColumnDesc columnDesc = col;
                        FunctionDesc functionDesc = measure;
                        return !(columnDesc != null ? !columnDesc.equals(functionDesc) : functionDesc != null) ? new StructField(new StringBuilder(8).append("MEASURE_").append(col.columnName()).toString(), dateType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()) : new StructField(new StringBuilder(10).append("DIMENSION_").append(col.columnName()).toString(), dateType, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
                    }, List$.MODULE$.canBuildFrom()));
                    column = reuseLayout ? new Column((Expression)new ReuseTopN(measure.returnType().precision(), schema, ((Column)columns.head()).expr(), ReuseTopN$.MODULE$.apply$default$4(), ReuseTopN$.MODULE$.apply$default$5()).toAggregateExpression()).as(id.toString()) : new Column((Expression)new EncodeTopN(measure.returnType().precision(), schema, ((Column)columns.head()).expr(), (Seq<Expression>)((Seq)((TraversableLike)columns.drop(1)).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.expr(), ListBuffer$.MODULE$.canBuildFrom())), EncodeTopN$.MODULE$.apply$default$5(), EncodeTopN$.MODULE$.apply$default$6()).toAggregateExpression()).as(id.toString());
                } else if ("PERCENTILE_APPROX".equals(string)) {
                    String udfName = UdfManager$.MODULE$.register(measure.returnType().toKylinDataType(), measure.expression(), null, !reuseLayout);
                    column = !reuseLayout ? functions$.MODULE$.callUDF(udfName, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{((Column)columns.head()).cast((DataType)StringType$.MODULE$)})).as(id.toString()) : functions$.MODULE$.callUDF(udfName, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{(Column)columns.head()})).as(id.toString());
                } else {
                    column = functions$.MODULE$.max((Column)columns.head()).as(id.toString());
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            Column column3 = column;
            return column3;
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
        Dataset dataset2 = df = !dimensions.isEmpty() ? dataSet.groupBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])NSparkCubingUtil.getColumns(dimensions))).agg((Column)agg.head(), (Seq)agg.drop(1)) : dataSet.agg((Column)agg.head(), (Seq)agg.drop(1));
        if (reuseLayout) {
            Column[] columns = (Column[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])NSparkCubingUtil.getColumns(dimensions))).$plus$plus(this.measureColumns(dataSet.schema(), measures), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)));
            dataset = df.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])columns));
        } else {
            dataset = df;
        }
        return dataset;
    }

    private AggregateFunction getCountDistinctAggregate(ListBuffer<Column> columns, DTType returnType, boolean reuseLayout) {
        TypedImperativeAggregate typedImperativeAggregate;
        Column col = (Column)columns.head();
        if (this.isBitmap(returnType)) {
            typedImperativeAggregate = !reuseLayout ? new EncodePreciseCountDistinct(this.wrapEncodeColumn((Column)columns.head()).expr(), EncodePreciseCountDistinct$.MODULE$.apply$default$2(), EncodePreciseCountDistinct$.MODULE$.apply$default$3()) : new ReusePreciseCountDistinct(col.expr(), ReusePreciseCountDistinct$.MODULE$.apply$default$2(), ReusePreciseCountDistinct$.MODULE$.apply$default$3());
        } else {
            int precision = returnType.precision();
            if (this.isMultiHllcCol(columns, returnType)) {
                col = this.wrapMutilHllcColumn((Seq<Column>)columns);
            }
            typedImperativeAggregate = !reuseLayout ? new EncodeApproxCountDistinct(col.expr(), precision, EncodeApproxCountDistinct$.MODULE$.apply$default$3(), EncodeApproxCountDistinct$.MODULE$.apply$default$4()) : new ReuseApproxCountDistinct(col.expr(), precision, ReuseApproxCountDistinct$.MODULE$.apply$default$3(), ReuseApproxCountDistinct$.MODULE$.apply$default$4());
        }
        return typedImperativeAggregate;
    }

    /*
     * WARNING - void declaration
     */
    private StructType constructTopNSchema(List<ColumnDesc> parameters) {
        void var3_3;
        ColumnDesc measure = (ColumnDesc)parameters.head();
        StructType schema = StructType$.MODULE$.apply((Seq)parameters.map((Function1 & Serializable & scala.Serializable)col -> {
            ColumnDesc columnDesc = col;
            ColumnDesc columnDesc2 = measure;
            return !(columnDesc != null ? !columnDesc.equals(columnDesc2) : columnDesc2 != null) ? new StructField(new StringBuilder(8).append("MEASURE_").append(col.columnName()).toString(), col.dataType(), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()) : new StructField(new StringBuilder(10).append("DIMENSION_").append(col.columnName()).toString(), col.dataType(), StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4());
        }, List$.MODULE$.canBuildFrom()));
        return var3_3;
    }

    private boolean isMultiHllcCol(ListBuffer<Column> columns, DTType returnDataType) {
        return columns.length() > 1 && returnDataType.dataType().startsWith("hllc");
    }

    private boolean isBitmap(DTType returnDataType) {
        return returnDataType.dataType().equalsIgnoreCase("bitmap");
    }

    private Iterable<Column> measureColumns(StructType schema, Map<Integer, FunctionDesc> measures) {
        return (Iterable)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(measures).asScala()).map((Function1 & Serializable & scala.Serializable)e -> {
            Column column;
            String string = ((FunctionDesc)e._2()).expression().toUpperCase(Locale.ROOT);
            if ("SUM".equals(string)) {
                String measureId = ((Integer)e._1()).toString();
                DataType dataType = (DataType)schema.find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)CuboidAggregator$.$anonfun$measureColumns$2(measureId, x$2))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.dataType()).get();
                column = functions$.MODULE$.col(measureId).cast(dataType).as(measureId);
            } else {
                String measureId = ((Integer)e._1()).toString();
                column = functions$.MODULE$.col(measureId);
            }
            return column;
        }, Iterable$.MODULE$.canBuildFrom());
    }

    public Column wrapEncodeColumn(Column column) {
        return new Column(new StringBuilder(0).append(column.toString()).append(CubeBuilderHelper$.MODULE$.ENCODE_SUFFIX()).toString());
    }

    public Column wrapMutilHllcColumn(Seq<Column> columns) {
        ObjectRef col = ObjectRef.create((Object)functions$.MODULE$.when(functions$.MODULE$.isnull((Column)columns.head()), null));
        ((IterableLike)columns.drop(1)).foreach((Function1 & Serializable & scala.Serializable)inputCol -> {
            col.elem = ((Column)col.elem).when(functions$.MODULE$.isnull(inputCol), null);
            return BoxedUnit.UNIT;
        });
        col.elem = ((Column)col.elem).otherwise((Object)functions$.MODULE$.hash(columns));
        return (Column)col.elem;
    }

    public static final /* synthetic */ boolean $anonfun$measureColumns$2(String measureId$1, StructField x$2) {
        return x$2.name().equals(measureId$1);
    }

    private CuboidAggregator$() {
        MODULE$ = this;
    }
}

