/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

public class Triple<A, B, C> {
    private A first;
    private B second;
    private C third;

    public Triple(A first, B second, C third) {
        this.first = first;
        this.second = second;
        this.third = third;
    }

    public static <A, B, C> Triple<A, B, C> create(A first, B second, C third) {
        return new Triple<A, B, C>(first, second, third);
    }

    public int hashCode() {
        int hashFirst = this.first != null ? this.first.hashCode() : 0;
        int hashSecond = this.second != null ? this.second.hashCode() : 0;
        int hashThird = this.third != null ? this.third.hashCode() : 0;
        return hashFirst >> 1 ^ hashSecond ^ hashThird << 1;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Triple)) {
            return false;
        }
        Triple otherTriple = (Triple)obj;
        if (this.first != otherTriple.first && this.first != null && !this.first.equals(otherTriple.first)) {
            return false;
        }
        if (this.second != otherTriple.second && this.second != null && !this.second.equals(otherTriple.second)) {
            return false;
        }
        return this.third == otherTriple.third || this.third == null || this.third.equals(otherTriple.third);
    }

    public String toString() {
        return "(" + this.first + ", " + this.second + ", " + this.third + ")";
    }

    public A getFirst() {
        return this.first;
    }

    public void setFirst(A first) {
        this.first = first;
    }

    public B getSecond() {
        return this.second;
    }

    public void setSecond(B second) {
        this.second = second;
    }

    public C getThird() {
        return this.third;
    }

    public void setThird(C third) {
        this.third = third;
    }
}

