/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Arguments for transforming HDFS Ranger service policies to Google Cloud Storage (GCS) policies. <p> Note that it's relevant only if any of the Ranger services to be replicated contain HDFS Ranger service type and replication will be done from on-prem to GCS.")
public class ApiRangerReplicationHdfsToGcsArgs {
    @SerializedName(value="gcsBucketName")
    private String gcsBucketName = null;

    public ApiRangerReplicationHdfsToGcsArgs gcsBucketName(String gcsBucketName) {
        this.gcsBucketName = gcsBucketName;
        return this;
    }

    @Schema(description="GCS bucket name for Ranger HDFS policies which need to be transformed to GCS policy.")
    public String getGcsBucketName() {
        return this.gcsBucketName;
    }

    public void setGcsBucketName(String gcsBucketName) {
        this.gcsBucketName = gcsBucketName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiRangerReplicationHdfsToGcsArgs apiRangerReplicationHdfsToGcsArgs = (ApiRangerReplicationHdfsToGcsArgs)o;
        return Objects.equals(this.gcsBucketName, apiRangerReplicationHdfsToGcsArgs.gcsBucketName);
    }

    public int hashCode() {
        return Objects.hash(this.gcsBucketName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiRangerReplicationHdfsToGcsArgs {\n");
        sb.append("    gcsBucketName: ").append(this.toIndentedString(this.gcsBucketName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

