/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.api.swagger.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="A process represents a unix process to be managed by the Cloudera Manager agents. A process can be a daemon, e.g. if it is associated with a running role. It can also be a one-off process which is expected to start, run and finish.")
public class ApiProcess {
    @SerializedName(value="configFiles")
    private List<String> configFiles = null;

    public ApiProcess configFiles(List<String> configFiles) {
        this.configFiles = configFiles;
        return this;
    }

    public ApiProcess addConfigFilesItem(String configFilesItem) {
        if (this.configFiles == null) {
            this.configFiles = new ArrayList<String>();
        }
        this.configFiles.add(configFilesItem);
        return this;
    }

    @Schema(description="List of config files supplied to the process.")
    public List<String> getConfigFiles() {
        return this.configFiles;
    }

    public void setConfigFiles(List<String> configFiles) {
        this.configFiles = configFiles;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiProcess apiProcess = (ApiProcess)o;
        return Objects.equals(this.configFiles, apiProcess.configFiles);
    }

    public int hashCode() {
        return Objects.hash(this.configFiles);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ApiProcess {\n");
        sb.append("    configFiles: ").append(this.toIndentedString(this.configFiles)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

