/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.backend.hashicorp.vault.authentication;

import java.util.Map;
import org.apache.knox.gateway.backend.hashicorp.vault.authentication.HashicorpVaultClientAuthenticationProvider;
import org.apache.knox.gateway.services.security.AliasService;
import org.springframework.vault.authentication.ClientAuthentication;
import org.springframework.vault.authentication.TokenAuthentication;

public class TokenHashicorpVaultClientAuthenticationProvider
implements HashicorpVaultClientAuthenticationProvider {
    public static final String TYPE = "token";
    public static final String TOKEN_KEY = "hashicorp.vault.authentication.token";

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public ClientAuthentication newInstance(AliasService localAliasService, Map<String, String> properties) throws Exception {
        String vaultToken = this.getVaultToken(localAliasService, properties);
        return new TokenAuthentication(vaultToken);
    }

    private String getVaultToken(AliasService localAliasService, Map<String, String> properties) throws Exception {
        String vaultToken = properties.get(TOKEN_KEY);
        if (vaultToken.startsWith("${ALIAS=") && vaultToken.endsWith("}")) {
            String vaultTokenAlias = vaultToken.substring(8, vaultToken.length() - 1);
            return new String(localAliasService.getPasswordFromAliasForGateway(vaultTokenAlias));
        }
        return vaultToken;
    }
}

