/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.topology.simple;

import org.apache.knox.gateway.i18n.messages.Message;
import org.apache.knox.gateway.i18n.messages.MessageLevel;
import org.apache.knox.gateway.i18n.messages.Messages;
import org.apache.knox.gateway.i18n.messages.StackTrace;

@Messages(logger="org.apache.knox.gateway.topology.simple")
public interface SimpleDescriptorMessages {
    @Message(level=MessageLevel.INFO, text="Skipping service discovery for the \"{0}\" descriptor because its contents do not indicate it is intended.")
    public void discoveryNotConfiguredForDescriptor(String var1);

    @Message(level=MessageLevel.INFO, text="The \"{0}\" descriptor does not include discovery-type or discovery-address.")
    public void missingDiscoveryTypeInDescriptor(String var1);

    @Message(level=MessageLevel.WARN, text="No valid URLs were discovered for {0} in the {1} cluster.")
    public void failedToDiscoverClusterServiceURLs(String var1, String var2);

    @Message(level=MessageLevel.ERROR, text="Failed to resolve the referenced provider configuration {0}.")
    public void failedToResolveProviderConfigRef(String var1);

    @Message(level=MessageLevel.ERROR, text="Failed to parse the referenced provider configuration {0}: {1}")
    public void failedToParseProviderConfig(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.ERROR, text="URL validation failed for {0} URL {1} : {2}")
    public void serviceURLValidationFailed(String var1, String var2, @StackTrace(level=MessageLevel.DEBUG) Exception var3);

    @Message(level=MessageLevel.ERROR, text="Error generating topology {0} from simple descriptor: {1}")
    public void failedToGenerateTopologyFromSimpleDescriptor(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.ERROR, text="Error creating a password for query string encryption for {0}: {1}")
    public void exceptionCreatingPasswordForEncryption(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.ERROR, text="Failed to create a password for query string encryption for {0}.")
    public void unableCreatePasswordForEncryption(String var1);

    @Message(level=MessageLevel.ERROR, text="Error comparing the generated {0} topology with the existing version: {1}")
    public void errorComparingGeneratedTopology(String var1, @StackTrace(level=MessageLevel.DEBUG) Exception var2);

    @Message(level=MessageLevel.INFO, text="Persisting the generated {0} topology because it either does not exist or it has changed.")
    public void persistingGeneratedTopology(String var1);

    @Message(level=MessageLevel.INFO, text="Skipping redeployment of the {0} topology because it already exists and has not changed.")
    public void skippingDeploymentOfGeneratedTopology(String var1);
}

