/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.oauth.profile.linkedin2;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.scribejava.core.model.OAuth2AccessToken;
import java.util.Arrays;
import org.pac4j.core.profile.AttributeLocation;
import org.pac4j.core.profile.ProfileHelper;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.core.profile.converter.AttributeConverter;
import org.pac4j.core.profile.converter.Converters;
import org.pac4j.oauth.profile.JsonHelper;
import org.pac4j.oauth.profile.converter.JsonConverter;
import org.pac4j.oauth.profile.definition.OAuth20ProfileDefinition;
import org.pac4j.oauth.profile.linkedin2.LinkedIn2Configuration;
import org.pac4j.oauth.profile.linkedin2.LinkedIn2Profile;
import org.pac4j.oauth.profile.linkedin2.LinkedIn2ProfilePicture;

public class LinkedIn2ProfileDefinition
extends OAuth20ProfileDefinition<LinkedIn2Profile, LinkedIn2Configuration> {
    public static final String LOCALIZED_FIRST_NAME = "localizedFirstName";
    public static final String LOCALIZED_LAST_NAME = "localizedLastName";
    public static final String PROFILE_PICTURE = "profilePicture";
    public static final String PROFILE_EMAILS = "profileEmails";

    public LinkedIn2ProfileDefinition() {
        super(x -> new LinkedIn2Profile());
        Arrays.stream(new String[]{LOCALIZED_FIRST_NAME, LOCALIZED_LAST_NAME}).forEach(a -> this.primary((String)a, (AttributeConverter)Converters.STRING));
        this.primary(PROFILE_PICTURE, new JsonConverter<LinkedIn2ProfilePicture>(LinkedIn2ProfilePicture.class));
    }

    @Override
    public String getProfileUrl(OAuth2AccessToken accessToken, LinkedIn2Configuration configuration) {
        return "https://api.linkedin.com/v2/me?projection=(id,localizedFirstName,localizedLastName,profilePicture(displayImage~:playableStreams))";
    }

    @Override
    public LinkedIn2Profile extractUserProfile(String body) {
        LinkedIn2Profile profile = (LinkedIn2Profile)this.newProfile(new Object[0]);
        JsonNode json = JsonHelper.getFirstNode(body);
        if (json == null) {
            this.raiseProfileExtractionJsonError(body);
        }
        profile.setId(ProfileHelper.sanitizeIdentifier((UserProfile)profile, (Object)JsonHelper.getElement(json, "id")));
        for (String attribute : this.getPrimaryAttributes()) {
            this.convertAndAdd(profile, AttributeLocation.PROFILE_ATTRIBUTE, attribute, JsonHelper.getElement(json, attribute));
        }
        return profile;
    }
}

