/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.request.search;

import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.decorators.SearchRequestDecorator;
import org.apache.directory.api.ldap.model.message.SearchRequest;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreSearchRequestAttributeDesc
extends GrammarAction<LdapMessageContainer<SearchRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreSearchRequestAttributeDesc.class);

    public StoreSearchRequestAttributeDesc() {
        super("Store attribute description");
    }

    public void action(LdapMessageContainer<SearchRequestDecorator> container) {
        SearchRequestDecorator searchRequestDecorator = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        String attributeDescription = null;
        if (tlv.getLength() != 0 && !Strings.isEmpty((String)(attributeDescription = Strings.utf8ToString((byte[])tlv.getValue().getData())).trim())) {
            ((SearchRequest)searchRequestDecorator.getDecorated()).addAttributes(new String[]{attributeDescription});
        }
        container.setGrammarEndAllowed(true);
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg((I18n)I18n.MSG_05159_DECODED_ATT_DESC, (Object[])new Object[]{attributeDescription}));
        }
    }
}

