/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.vault.support;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class VaultCertificateRequest {
    private final String commonName;
    private final List<String> altNames;
    private final List<String> ipSubjectAltNames;
    @Nullable
    private final Duration ttl;
    private final boolean excludeCommonNameFromSubjectAltNames;

    VaultCertificateRequest(String commonName, List<String> altNames, List<String> ipSubjectAltNames, @Nullable Duration ttl, boolean excludeCommonNameFromSubjectAltNames) {
        this.commonName = commonName;
        this.altNames = altNames;
        this.ipSubjectAltNames = ipSubjectAltNames;
        this.ttl = ttl;
        this.excludeCommonNameFromSubjectAltNames = excludeCommonNameFromSubjectAltNames;
    }

    public static VaultCertificateRequestBuilder builder() {
        return new VaultCertificateRequestBuilder();
    }

    public static VaultCertificateRequest create(String commonName) {
        return VaultCertificateRequest.builder().commonName(commonName).build();
    }

    public String getCommonName() {
        return this.commonName;
    }

    public List<String> getAltNames() {
        return this.altNames;
    }

    public List<String> getIpSubjectAltNames() {
        return this.ipSubjectAltNames;
    }

    @Nullable
    public Duration getTtl() {
        return this.ttl;
    }

    public boolean isExcludeCommonNameFromSubjectAltNames() {
        return this.excludeCommonNameFromSubjectAltNames;
    }

    public static class VaultCertificateRequestBuilder {
        @Nullable
        private String commonName;
        private List<String> altNames = new ArrayList<String>();
        private List<String> ipSubjectAltNames = new ArrayList<String>();
        @Nullable
        private Duration ttl;
        private boolean excludeCommonNameFromSubjectAltNames;

        VaultCertificateRequestBuilder() {
        }

        public VaultCertificateRequestBuilder commonName(String commonName) {
            Assert.hasText((String)commonName, (String)"Common name must not be empty");
            this.commonName = commonName;
            return this;
        }

        public VaultCertificateRequestBuilder altNames(Iterable<String> altNames) {
            Assert.notNull(altNames, (String)"Alt names must not be null");
            this.altNames = VaultCertificateRequestBuilder.toList(altNames);
            return this;
        }

        public VaultCertificateRequestBuilder withAltName(String altName) {
            Assert.hasText((String)altName, (String)"Alt name must not be empty");
            this.altNames.add(altName);
            return this;
        }

        public VaultCertificateRequestBuilder ipSubjectAltNames(Iterable<String> ipSubjectAltNames) {
            Assert.notNull(ipSubjectAltNames, (String)"IP subject alt names must not be null");
            this.ipSubjectAltNames = VaultCertificateRequestBuilder.toList(ipSubjectAltNames);
            return this;
        }

        public VaultCertificateRequestBuilder withIpSubjectAltName(String ipSubjectAltName) {
            Assert.hasText((String)ipSubjectAltName, (String)"IP subject alt name must not be empty");
            this.ipSubjectAltNames.add(ipSubjectAltName);
            return this;
        }

        @Deprecated
        public VaultCertificateRequestBuilder ttl(int ttl) {
            Assert.isTrue((ttl > 0 ? 1 : 0) != 0, (String)"TTL must not be negative");
            this.ttl = Duration.ofSeconds(ttl);
            return this;
        }

        public VaultCertificateRequestBuilder ttl(long ttl, TimeUnit timeUnit) {
            Assert.isTrue((ttl > 0L ? 1 : 0) != 0, (String)"TTL must not be negative");
            Assert.notNull((Object)((Object)timeUnit), (String)"TimeUnit must be greater 0");
            this.ttl = Duration.ofSeconds(timeUnit.toSeconds(ttl));
            return this;
        }

        public VaultCertificateRequestBuilder ttl(Duration ttl) {
            Assert.notNull((Object)ttl, (String)"TTL must not be null");
            Assert.isTrue((!ttl.isNegative() ? 1 : 0) != 0, (String)"TTL must not be negative");
            this.ttl = ttl;
            return this;
        }

        public VaultCertificateRequestBuilder excludeCommonNameFromSubjectAltNames() {
            this.excludeCommonNameFromSubjectAltNames = true;
            return this;
        }

        public VaultCertificateRequest build() {
            List<String> ipSubjectAltNames;
            List<String> altNames;
            Assert.notNull((Object)this.commonName, (String)"Common name must not be null");
            Assert.hasText((String)this.commonName, (String)"Common name must not be empty");
            switch (this.altNames.size()) {
                case 0: {
                    altNames = Collections.emptyList();
                    break;
                }
                case 1: {
                    altNames = Collections.singletonList(this.altNames.get(0));
                    break;
                }
                default: {
                    altNames = Collections.unmodifiableList(new ArrayList<String>(this.altNames));
                }
            }
            switch (this.ipSubjectAltNames.size()) {
                case 0: {
                    ipSubjectAltNames = Collections.emptyList();
                    break;
                }
                case 1: {
                    ipSubjectAltNames = Collections.singletonList(this.ipSubjectAltNames.get(0));
                    break;
                }
                default: {
                    ipSubjectAltNames = Collections.unmodifiableList(new ArrayList<String>(this.ipSubjectAltNames));
                }
            }
            return new VaultCertificateRequest(this.commonName, altNames, ipSubjectAltNames, this.ttl, this.excludeCommonNameFromSubjectAltNames);
        }

        private static <E> List<E> toList(Iterable<E> iter) {
            ArrayList<E> list = new ArrayList<E>();
            for (E item : iter) {
                list.add(item);
            }
            return list;
        }
    }
}

