/*
 * Decompiled with CFR 0.152.
 */
package io.burt.jmespath.node;

import io.burt.jmespath.Adapter;
import io.burt.jmespath.Expression;
import io.burt.jmespath.function.Function;
import io.burt.jmespath.node.AndNode;
import io.burt.jmespath.node.ComparisonNode;
import io.burt.jmespath.node.CreateArrayNode;
import io.burt.jmespath.node.CreateObjectNode;
import io.burt.jmespath.node.CurrentNode;
import io.burt.jmespath.node.ExpressionReferenceNode;
import io.burt.jmespath.node.FlattenArrayNode;
import io.burt.jmespath.node.FlattenObjectNode;
import io.burt.jmespath.node.FunctionCallNode;
import io.burt.jmespath.node.IndexNode;
import io.burt.jmespath.node.JsonLiteralNode;
import io.burt.jmespath.node.NegateNode;
import io.burt.jmespath.node.Node;
import io.burt.jmespath.node.NodeFactory;
import io.burt.jmespath.node.Operator;
import io.burt.jmespath.node.OrNode;
import io.burt.jmespath.node.ProjectionNode;
import io.burt.jmespath.node.PropertyNode;
import io.burt.jmespath.node.SelectionNode;
import io.burt.jmespath.node.SequenceNode;
import io.burt.jmespath.node.SliceNode;
import io.burt.jmespath.node.StringNode;
import java.util.List;

public class StandardNodeFactory<T>
implements NodeFactory<T> {
    private final Adapter<T> runtime;

    public StandardNodeFactory(Adapter<T> runtime) {
        this.runtime = runtime;
    }

    @Override
    public Node<T> createCurrent() {
        return new CurrentNode<T>(this.runtime);
    }

    @Override
    public Node<T> createSequence(List<Node<T>> nodes) {
        return new SequenceNode<T>(this.runtime, nodes);
    }

    @Override
    public Node<T> createProperty(String name) {
        return new PropertyNode<T>(this.runtime, name);
    }

    @Override
    public Node<T> createIndex(int index) {
        return new IndexNode<T>(this.runtime, index);
    }

    @Override
    public Node<T> createSlice(Integer start, Integer stop, Integer step) {
        return new SliceNode<T>(this.runtime, start, stop, step);
    }

    @Override
    public Node<T> createProjection(Expression<T> expression) {
        return new ProjectionNode<T>(this.runtime, expression);
    }

    @Override
    public Node<T> createFlattenArray() {
        return new FlattenArrayNode<T>(this.runtime);
    }

    @Override
    public Node<T> createFlattenObject() {
        return new FlattenObjectNode<T>(this.runtime);
    }

    @Override
    public Node<T> createSelection(Expression<T> test) {
        return new SelectionNode<T>(this.runtime, test);
    }

    @Override
    public Node<T> createComparison(Operator operator, Expression<T> left, Expression<T> right) {
        return ComparisonNode.create(this.runtime, operator, left, right);
    }

    @Override
    public Node<T> createOr(Expression<T> left, Expression<T> right) {
        return new OrNode<T>(this.runtime, left, right);
    }

    @Override
    public Node<T> createAnd(Expression<T> left, Expression<T> right) {
        return new AndNode<T>(this.runtime, left, right);
    }

    @Override
    public Node<T> createFunctionCall(String functionName, List<? extends Expression<T>> args) {
        return new FunctionCallNode<T>(this.runtime, this.runtime.functionRegistry().getFunction(functionName), args);
    }

    @Override
    public Node<T> createFunctionCall(Function function, List<? extends Expression<T>> args) {
        return new FunctionCallNode<T>(this.runtime, function, args);
    }

    @Override
    public Node<T> createExpressionReference(Expression<T> expression) {
        return new ExpressionReferenceNode<T>(this.runtime, expression);
    }

    @Override
    public Node<T> createString(String str) {
        return new StringNode<T>(this.runtime, str);
    }

    @Override
    public Node<T> createNegate(Expression<T> negated) {
        return new NegateNode<T>(this.runtime, negated);
    }

    @Override
    public Node<T> createCreateObject(List<CreateObjectNode.Entry<T>> entries) {
        return new CreateObjectNode<T>(this.runtime, entries);
    }

    @Override
    public Node<T> createCreateArray(List<? extends Expression<T>> entries) {
        return new CreateArrayNode<T>(this.runtime, entries);
    }

    @Override
    public Node<T> createJsonLiteral(String json) {
        return new JsonLiteralNode<T>(this.runtime, json);
    }
}

