/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.base.scale.transform;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.interval.DoubleSpan;
import org.jetbrains.letsPlot.core.plot.base.scale.BreaksGenerator;
import org.jetbrains.letsPlot.core.plot.base.scale.ScaleBreaks;
import org.jetbrains.letsPlot.core.plot.base.scale.breaks.TimeBreaksHelper;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J$\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J$\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/letsPlot/core/plot/base/scale/transform/TimeBreaksGen;", "Lorg/jetbrains/letsPlot/core/plot/base/scale/BreaksGenerator;", "()V", "breaksHelper", "Lorg/jetbrains/letsPlot/core/plot/base/scale/breaks/TimeBreaksHelper;", "domainAfterTransform", "Lorg/jetbrains/letsPlot/commons/interval/DoubleSpan;", "targetCount", "", "defaultFormatter", "Lkotlin/Function1;", "", "", "domain", "generateBreaks", "Lorg/jetbrains/letsPlot/core/plot/base/scale/ScaleBreaks;", "labelFormatter", "plot-base"})
public final class TimeBreaksGen
implements BreaksGenerator {
    @Override
    @NotNull
    public ScaleBreaks generateBreaks(@NotNull DoubleSpan domain, int targetCount) {
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        TimeBreaksHelper helper2 = this.breaksHelper(domain, targetCount);
        List<Double> ticks = helper2.getBreaks();
        List<String> labels = helper2.formatBreaks(ticks);
        return new ScaleBreaks(ticks, ticks, labels);
    }

    @Override
    @NotNull
    public Function1<Object, String> labelFormatter(@NotNull DoubleSpan domain, int targetCount) {
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        return this.breaksHelper(domain, targetCount).getFormatter();
    }

    @Override
    @NotNull
    public Function1<Object, String> defaultFormatter(@NotNull DoubleSpan domain, int targetCount) {
        Intrinsics.checkNotNullParameter((Object)domain, (String)"domain");
        return this.breaksHelper(domain, targetCount).getFormatter();
    }

    private final TimeBreaksHelper breaksHelper(DoubleSpan domainAfterTransform, int targetCount) {
        return new TimeBreaksHelper(domainAfterTransform.getLowerEnd(), domainAfterTransform.getUpperEnd(), targetCount);
    }
}

