/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.interval;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.interval.NumSpan;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0000J\u0011\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0003H\u0086\u0002J\u000e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0000J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0000J\u000e\u0010\u0015\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0000R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/letsPlot/commons/interval/IntSpan;", "Lorg/jetbrains/letsPlot/commons/interval/NumSpan;", "lower", "", "upper", "(II)V", "length", "getLength", "()I", "lowerEnd", "getLowerEnd", "()Ljava/lang/Integer;", "upperEnd", "getUpperEnd", "connected", "", "other", "contains", "v", "encloses", "intersection", "union", "commons"})
public final class IntSpan
extends NumSpan {
    private final int lowerEnd;
    private final int upperEnd;
    private final int length;

    public IntSpan(int lower, int upper) {
        this.lowerEnd = Math.min(lower, upper);
        this.upperEnd = Math.max(lower, upper);
        this.length = this.getUpperEnd() - this.getLowerEnd();
    }

    @Override
    @NotNull
    public Integer getLowerEnd() {
        return this.lowerEnd;
    }

    @Override
    @NotNull
    public Integer getUpperEnd() {
        return this.upperEnd;
    }

    public final int getLength() {
        return this.length;
    }

    public final boolean contains(int v) {
        return v >= this.getLowerEnd() && v <= this.getUpperEnd();
    }

    public final boolean encloses(@NotNull IntSpan other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.getLowerEnd() <= other.getLowerEnd() && this.getUpperEnd() >= other.getUpperEnd();
    }

    public final boolean connected(@NotNull IntSpan other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.getLowerEnd() <= other.getUpperEnd() && this.getUpperEnd() >= other.getLowerEnd();
    }

    @NotNull
    public final IntSpan union(@NotNull IntSpan other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (this.encloses(other)) {
            return this;
        }
        return other.encloses(this) ? other : new IntSpan(Math.min(this.getLowerEnd(), other.getLowerEnd()), Math.max(this.getUpperEnd(), other.getUpperEnd()));
    }

    @NotNull
    public final IntSpan intersection(@NotNull IntSpan other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        if (!this.connected(other)) {
            throw new IllegalArgumentException("Ranges are not connected: this=" + this + " other=" + other);
        }
        if (this.encloses(other)) {
            return other;
        }
        return other.encloses(this) ? this : new IntSpan(Math.max(this.getLowerEnd(), other.getLowerEnd()), Math.min(this.getUpperEnd(), other.getUpperEnd()));
    }
}

